/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is BlueGriffon.
 *
 * The Initial Developer of the Original Code is
 * Disruptive Innovations SARL.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Daniel Glazman <daniel.glazman@disruptive-innovations.com>, Original author
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

Components.utils.import("resource://app/modules/editorHelper.jsm");
Components.utils.import("resource://app/modules/urlHelper.jsm");
Components.utils.import("resource://app/modules/cssHelper.jsm");
Components.utils.import("resource://app/modules/cssInspector.jsm");
Components.utils.import("resource://app/modules/prompterHelper.jsm");

var gMain = null;
var gCurrentElement = null;
var gInUtils;
//@line 53 "c:\trees\official1.4\bluegriffon\sidebars\cssproperties\content\cssproperties.js"
var gIsPanelActive = false;
//@line 56 "c:\trees\official1.4\bluegriffon\sidebars\cssproperties\content\cssproperties.js"
var gPrefs = null;
var gXmlNAMERegExp = null;

function Startup()
{
  GetUIElements();

  Bezier.init();

  InitLocalFontFaceMenu(gDialog.addFontMenupopup);

  gPrefs = GetPrefs();

  gInUtils = Components.classes["@mozilla.org/inspector/dom-utils;1"]
              .getService(Components.interfaces.inIDOMUtils);

  if (window.top &&
      "NotifierUtils" in window.top)
    gMain = window.top;
  else if (window.top && window.top.opener &&
           "NotifierUtils" in window.top.opener)
    gMain = window.top.opener;

  if (!gMain)
    return;
  
  gMain.NotifierUtils.addNotifierCallback("selection",
                                          SelectionChanged,
                                          window);
  gMain.NotifierUtils.addNotifierCallback("tabClosed",
                                          Inspect,
                                          window);
  gMain.NotifierUtils.addNotifierCallback("tabCreated",
                                          Inspect,
                                          window);
  gMain.NotifierUtils.addNotifierCallback("tabSelected",
                                          Inspect,
                                          window);
  gMain.NotifierUtils.addNotifierCallback("afterEnteringSourceMode",
                                          Inspect,
                                          window);
  gMain.NotifierUtils.addNotifierCallback("afterLeavingSourceMode",
                                          Inspect,
                                          window);

  gMain.NotifierUtils.addNotifierCallback("redrawPanel",
                                          RedrawAll,
                                          window);
  gMain.NotifierUtils.addNotifierCallback("panelClosed",
                                          PanelClosed,
                                          window);
  Inspect();
  if (gMain && gMain.EditorUtils && gIsPanelActive &&
      gMain.EditorUtils.getCurrentEditor()) {
    var c = gMain.EditorUtils.getSelectionContainer();
    if (c)
      SelectionChanged(null, c.node, c.oneElementSelected);
  }
  var nameStartChar = "A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD";
  var nameChar = nameStartChar + "\-\.0-9\\u00B7\\u0300-\\u036F\\u203F-\\u2040";
  gXmlNAMERegExp = new RegExp("^[" + nameStartChar + "][" + nameChar + "]*$");
}

function Shutdown()
{
  if (gMain)
  {
    gMain.NotifierUtils.removeNotifierCallback("selection",
                                               SelectionChanged,
                                               window);
    gMain.NotifierUtils.removeNotifierCallback("tabClosed",
                                               Inspect);
    gMain.NotifierUtils.removeNotifierCallback("tabCreated",
                                               Inspect);
    gMain.NotifierUtils.removeNotifierCallback("tabSelected",
                                               Inspect);
    gMain.NotifierUtils.removeNotifierCallback("afterEnteringSourceMode",
                                               Inspect);
    gMain.NotifierUtils.removeNotifierCallback("afterLeavingSourceMode",
                                               Inspect);
    gMain.NotifierUtils.removeNotifierCallback("redrawPanel",
                                                RedrawAll,
                                                window);
    gMain.NotifierUtils.removeNotifierCallback("panelClosed",
                                                PanelClosed,
                                                window);
  }
}

function Inspect()
{
  if (gMain && gMain.EditorUtils)
  {
    var editor = gMain.EditorUtils.getCurrentEditor();
    var visible = editor && (gMain.GetCurrentViewMode() == "wysiwyg");
    gDialog.mainBox.style.visibility = visible ? "" : "hidden";
    if (visible) {
      var node = EditorUtils.getSelectionContainer().node;
      if (node) {
        SelectionChanged(null, node, true);
      }
    }
  }
}

function RedrawAll(aNotification, aPanelId)
{
  if (aPanelId == "panel-cssproperties") {
    gIsPanelActive = true;
    if (gCurrentElement) {
      // force query of all properties on the current element
      SelectionChanged(null, gCurrentElement, true);
    }
  }
}

function PanelClosed(aNotification, aPanelId)
{
  if (aPanelId == "panel-cssproperties")
    gIsPanelActive = false;
}

function SelectionChanged(aArgs, aElt, aOneElementSelected)
{
  if (!gIsPanelActive) {
    gCurrentElement = aElt;
    return;
  }

  gCurrentElement = aElt;
  deleteAllChildren(gDialog.classPickerPopup);
  gDialog.classPicker.value =  "";

  var item;
  for (var i = aElt.classList.length -1; i >= 0; i--) {
    var c = aElt.classList.item(i);
    item = gDialog.classPicker.appendItem(c, c);
  }
  if (item)
    gDialog.classPicker.selectedItem = item;
  CheckClass(gDialog.classPicker);

  gDialog.typePicker.setAttribute("value", gCurrentElement.localName);

  var inspector = Components.classes["@mozilla.org/inspector/dom-utils;1"]
                    .getService(Components.interfaces.inIDOMUtils);
  var state;
  var dynamicPseudo = "";
  if (gDialog.hoverStateCheckbox.checked) {
    state = inspector.getContentState(gCurrentElement);
    inspector.setContentState(gCurrentElement, state | 4); // NS_EVENT_STATE_HOVER
    dynamicPseudo = "hover";
  }
  var ruleset = CssInspector.getCSSStyleRules(aElt, false, dynamicPseudo);
  if (gDialog.hoverStateCheckbox.checked) {
    inspector.setContentState(gCurrentElement.ownerDocument.documentElement, 4); // NS_EVENT_STATE_HOVER
    var display = gCurrentElement.style.display;
  }
  for (var i = 0; i < gIniters.length; i++)
    gIniters[i](aElt, ruleset);

  gDialog.currentElementBox.setAttribute("value",
       "<" + gCurrentElement.localName +
       (gCurrentElement.id ? " id='" + gCurrentElement.id + "'" : "") +
       (gCurrentElement.className ? " class='" + gCurrentElement.className + "'" : "") +
       ">" +
       gCurrentElement.innerHTML.substr(0, 100));
}

function CheckClass(aElt)
{
  var value = aElt.value;
  var valid;
  if (value && value.match( gXmlNAMERegExp ))
    valid = "true";
  else if (!value)
    valid = "empty";
  else
    valid = "false";
  aElt.setAttribute("valid", valid);
}

function onCssPolicyChange(aElt)
{
  var cssPolicy = aElt.value;
  switch (cssPolicy) {
    case "class":
      gDialog.classPicker.hidden = false;
      gDialog.typePicker.hidden  = true;
      gDialog.classPicker.focus();
      break;
    case "id":
      gDialog.classPicker.hidden = true;
      gDialog.typePicker.hidden  = true;
      break;
    case "type":
      gDialog.classPicker.hidden = true;
      gDialog.typePicker.hidden  = false;
      break;
  }
}

function ToggleSection(aEvent, header)
{
  if (aEvent && aEvent.button) // only first button...
    return;

  var section = header.nextElementSibling;
  if (header.hasAttribute("open")) {
    section.style.height = "0px";
    header.removeAttribute("open");
  }
  else {
    section.style.height = "";
    header.setAttribute("open", "true");
    section.style.height = document.defaultView.getComputedStyle(section, "").getPropertyValue("height");
  }
  document.persist(header.id, "open");
  document.persist(section.id, "style");
}

var gIniters = [];

function RegisterIniter(aFn)
{
  gIniters.push(aFn);
}

function GetComputedValue(aElt, aProperty)
{
  return aElt.ownerDocument.defaultView.getComputedStyle(aElt, "").getPropertyValue(aProperty);
}

var gSavedSelection;
function SaveSelection()
{
  var editor = EditorUtils.getCurrentEditor();
  var selection = editor.selection;
  gSavedSelection = [];
  for (var i = 0; i < selection.rangeCount; i++) {
    var r = selection.getRangeAt(i);
    gSavedSelection.push( {
                            startContainer: r.startContainer,
                           startOffset   : r.startOffset,
                           endContainer  : r.endContainer,
                           endOffset     : r.endOffset
                         });
  }
}

function RestoreSelection()
{
  if (!gSavedSelection)
    return;
  var editor = EditorUtils.getCurrentEditor();
  var selection = editor.selection;
  selection.removeAllRanges();
  for (var i = 0 ; i < gSavedSelection.length; i++) {
    var s = gSavedSelection[i];
    var range = document.createRange();
    range.setStart(s.startContainer, s.startOffset);
    range.setEnd(s.endContainer, s.endOffset);
    selection.addRange(range);
  }
  // don't preserve a reference to nodes !
  gSavedSelection = null;
}

function ApplyStyles(aStyles)
{
  var className;
  var editor = EditorUtils.getCurrentEditor();
  if (gDialog.hoverStateCheckbox.checked && gDialog.cssPolicyMenulist.value == "inline")
    gDialog.cssPolicyMenulist.value = "id";
  var cssPolicy = gPrefs.getCharPref("bluegriffon.css.policy"); 
  switch (gDialog.cssPolicyMenulist.value) {
    case "id":
      // if the element has no ID, ask for one...
      if (gCurrentElement.id)
        editor.beginTransaction();
      else if (cssPolicy == "automatic") {
        var prefix = gPrefs.getCharPref("bluegriffon.css.prefix");
        var id = prefix + new Date().valueOf() +
                          "_" + Math.round(Math.random() * 100000);
        editor.beginTransaction();
        editor.setAttribute(gCurrentElement, "id", id);
      }
      else {
        var result = {};
        var valid = false;

        while (!valid) {
          if (!PromptUtils.prompt(window,
                                  gDialog.csspropertiesBundle.getString("EnterAnId"),
                                  gDialog.csspropertiesBundle.getString("EnterUniqueId"),
                                  result)) {
            Inspect();
            return;
          }
          valid = (null != result.value.match( gXmlNAMERegExp ));
        }
        var id = result.value;
        var elt = id ? editor.document.getElementById(id) : null;
        var rv = 0;
        if (elt && elt != gCurrentElement)
          rv = PromptUtils.confirmWithTitle(
                                 L10NUtils.getString("IdAlreadyTaken"),
                                 L10NUtils.getString("RemoveIdFromElement"),
                                 L10NUtils.getString("YesRemoveId"),
                                 L10NUtils.getString("NoCancel"),
                                 null);
        if (rv == 1) {
          Inspect();
          return;
        }
        editor.beginTransaction();
        if (elt && elt != gCurrentElement) {
          editor.removeAttribute(elt, "id");
        }
        editor.setAttribute(gCurrentElement, "id", result.value);
      }
      break;

    case "class":
      if (!gDialog.classPicker.value) {
        if (cssPolicy == "automatic") {
          var prefix = gPrefs.getCharPref("bluegriffon.css.prefix");
          className = prefix + new Date().valueOf() +
                            "_" + Math.round(Math.random() * 100000);
          editor.beginTransaction();
          editor.setAttribute(gCurrentElement, "class", className);
          gDialog.classPicker.value = className;
        }
        else {
          PromptUtils.alertWithTitle(gDialog.csspropertiesBundle.getString("NoClasSelected"),
                                     gDialog.csspropertiesBundle.getString("PleaseSelectAClass"),
                                     window);
          Inspect();
          return;
        }
      }
      else {
        CheckClass(gDialog.classPicker);
        if (gDialog.classPicker.getAttribute("valid") == "false"){
          PromptUtils.alertWithTitle(gDialog.csspropertiesBundle.getString("NoClasSelected"),
                                     gDialog.csspropertiesBundle.getString("PleaseSelectAClass"),
                                     window);
          Inspect();
          return;
        }
        editor.beginTransaction();
        // make sure the element carries the user-selected class
        className = gDialog.classPicker.value;
        if (!gCurrentElement.classList.contains(gDialog.classPicker.value)) {
          var c = (gCurrentElement.classList ? gCurrentElement.classList + " " : "") + className;
          editor.setAttribute(gCurrentElement, "class", className);
        }
      }
      break;

    default:
      editor.beginTransaction();
      break;
  }

  SaveSelection();
  for (var i = 0; i < aStyles.length; i++) {
    var s = aStyles[i];
    var property = s.property;
    var value = s.value;

    switch (gDialog.cssPolicyMenulist.value) {

      case "id":
          ApplyStyleChangesToStylesheets(editor, gCurrentElement, property, value,
                                         "#", "#", gCurrentElement.id);
        break;

      case "inline":
        try {
          var txn = new diStyleAttrChangeTxn(gCurrentElement, property, value, "");
          EditorUtils.getCurrentEditor().transactionManager.doTransaction(txn);  
          EditorUtils.getCurrentEditor().incrementModificationCount(1);  
        }
        catch(e) {}
        break;

      case "class":
          ApplyStyleChangesToStylesheets(editor, gCurrentElement, property, value,
                                         ".", "\\.", className);
        break;

      case "type":
          ApplyStyleChangesToStylesheets(editor, gCurrentElement, property, value,
                                         "", "", gCurrentElement.localName);
        break;
      default:
        break;
    }
  }
  editor.endTransaction();
  RestoreSelection();
}

function FindLastEditableStyleSheet()
{
  var doc = EditorUtils.getCurrentDocument();
  var headElt = doc.querySelector("head");
  var child = headElt.lastElementChild;
  var found = false;
  while (!found && child) {
    var name = child.localName;
    if (name == "style" ||
        (name == "link" &&
         child.getAttribute("rel").toLowerCase() == "stylesheet" &&
         !child.hasAttribute("title"))) {
      var media = child.getAttribute("media") || "";
      var mediaArray = media.split(",");
      mediaArray.forEach(function(element,index,array) {array[index] = array[index].toLowerCase().trim()});
      var isForScreen = (!media || media == "all" || mediaArray.indexOf("screen") != -1);
      if (name == "link") {
        var uri = Components.classes["@mozilla.org/network/io-service;1"]
                                .getService(Components.interfaces.nsIIOService)
                                .newURI(child.sheet.href, null, null);
        if (uri.scheme == "file" && isForScreen) {
          // is the file writable ?
          var file = UrlUtils.newLocalFile(UrlUtils.makeAbsoluteUrl(child.sheet.href));
          if (file.isWritable())
            found = true;
          else
            child = child.previousElementSibling;
        }
        else
          child = child.previousElementSibling;
      }
      else if (isForScreen)
        found = true;
      else
        child = child.previousElementSibling;
    }
    else
      child = child.previousElementSibling;
  }
  if (found)
    sheet = child.sheet;
  else { // no editable stylesheet in the document, create one
    var styleElt = doc.createElement("style");
    styleElt.setAttribute("type", "text/css");
    EditorUtils.getCurrentEditor().insertNode(styleElt, headElt, headElt.childNodes.length);
    sheet = styleElt.sheet;
  }
  return sheet;
}

function ToggleProperty(aElt)
{
  var checked   = aElt.hasAttribute("checked");
  var value = (aElt.hasAttribute("value") ? aElt.getAttribute("value") : aElt.value);
  if (!checked &&
      (aElt.nodeName.toLowerCase() == "checkbox" || aElt.getAttribute("type") == "checkbox"))
    value = "";
  var property  = aElt.getAttribute("property");
  var resetter  = aElt.getAttribute("resetter");
  var group     = aElt.getAttribute("group");
  var agregator = aElt.getAttribute("agregator");
  var others = [];
  if (agregator)
    others = document.querySelectorAll("[agregator='" + agregator + "']");
  else if (group)
    others = document.querySelectorAll("[group='" + group + "']");
  for (var i = 0; i < others.length; i++) {
    var e = others[i];
    if (e != aElt) {
      if (resetter == "true" || group)
        e.removeAttribute("checked");
      else {
        if (agregator && e.hasAttribute("checked"))
          value += " " + e.getAttribute("value");
      }
    }
  }
  ApplyStyles([ { property: property, value: value} ]);
}

function CheckToggle(aToggle, aChecked)
{
  if (aChecked)
    aToggle.setAttribute("checked", "true");
  else
    aToggle.removeAttribute("checked");
}

function PopulateLengths(aElt, aUnitsString)
{
  var menuseparator = aElt.querySelector("menuseparator");
  if (menuseparator) {
    var child = aElt.firstChild;
    while (child && child != menuseparator) {
      var tmp = child.nextSibling;
      aElt.removeChild(child);
      child = tmp;
    }
  }
  else
    deleteAllChildren(aElt);

  var v = parseFloat(aElt.parentNode.value);
  if (isNaN(v))
    v = 0;
  var unitsArray;
  if (aUnitsString == " ")
    unitsArray = [""];
  else
    unitsArray = aUnitsString.split(" ");
  unitsArray.forEach(function(aArrayElt, aIndex, aArray) {
    var menuitem = document.createElement("menuitem");
    menuitem.setAttribute("label", v + aArrayElt);
    menuitem.setAttribute("value", v + aArrayElt);
    aElt.insertBefore(menuitem, menuseparator);
  });
}

function ApplyPropertyFromMenulist(aElt)
{
  var value;
  if (aElt.selectedItem)
    value = aElt.selectedItem.value;
  else
    value = aElt.value;

  var toApply = [
                  {
                    property: aElt.getAttribute("property"),
                    value: value
                  }
                ];
  if (aElt.hasAttribute("fouredges") && aElt.hasAttribute("fouredgescontrol")) {
    if (document.getElementById(aElt.getAttribute("fouredgescontrol")).checked) {
      var edgesArray = aElt.getAttribute("fouredges").split(",");
      for (var i = 0; i < edgesArray.length; i++)
        toApply.push({
                       property: edgesArray[i],
                       value: value
                     } );
    }
  }
  ApplyStyles(toApply);
}

function IncreaseLength(aElt, aUnitsString, aCallback)
{
  var value;
  var menulist = aElt.previousSibling;
  if (menulist.selectedItem)
    value = menulist.selectedItem.value;
  else
    value = menulist.value;
  var units = aUnitsString.replace( / /g, "|");
  var r = new RegExp( "([+-]?[0-9]*\\.[0-9]+|[+-]?[0-9]+)(" + units + ")*", "");
  var match = value.match( r );
  if (match) {
    var unit = match[2];
    var v    = parseFloat(match[1]);
    switch (unit) {
      case "in":
      case "cm":
        v += 0.1;
        v = Math.round( v * 10) / 10;
        break;
      case "em":
      case "rem":
      case "ch":
      case "ex":
        v += 0.5;
        v = Math.round( v * 10) / 10;
        break;
      default:
        v += 1;
        break;
    }
    menulist.value = v + (unit ? unit : "");
    onLengthMenulistCommand(menulist, aUnitsString, '', false, aCallback);
  }
}

function DecreaseLength(aElt, aUnitsString, aAllowNegative, aCallback)
{
  var value;
  var menulist = aElt.previousSibling;
  if (menulist.selectedItem)
    value = menulist.selectedItem.value;
  else
    value = menulist.value;
  var units = aUnitsString.replace( / /g, "|");
  var r = new RegExp( "([+-]?[0-9]*\\.[0-9]+|[+-]?[0-9]+)(" + units + ")*", "");
  var match = value.match( r );
  if (match) {
    var unit = match[2];
    var v    = parseFloat(match[1]);
    switch (unit) {
      case "in":
      case "cm":
        v -= 0.1;
        v = Math.round( v * 10) / 10;
        break;
      case "em":
      case "ex":
        v -= 0.5;
        v = Math.round( v * 10) / 10;
        break;
      default:
        v -= 1;
        break;
    }
    if (!aAllowNegative && v < 0)
      v = 0;
    menulist.value = v + (unit ? unit : "");
    onLengthMenulistCommand(menulist, aUnitsString, '', aAllowNegative, aCallback);
  }
}

function onLengthMenulistCommand(aElt, aUnitsString, aIdentsString, aAllowNegative, aCallback)
{
  var idents = aIdentsString.split(" ");
  var value;
  if (aElt.selectedItem)
    value = aElt.selectedItem.value;
  else
    value = aElt.value;
  aElt.value = value;
  var units = aUnitsString.replace( / /g, "|");
  var r = new RegExp( "([+-]?[0-9]*\\.[0-9]+|[+-]?[0-9]+)(" + units + ")*", "");
  var match = value.match( r );
  if (aElt.getAttribute("property")) {
    if (!value ||
        (match && !(!aAllowNegative && parseFloat(match[1]) < 0) &&
         (match[2] || units[0] == "|")) ||
        idents.indexOf(value) != -1) {
      var toApply = [ {
                        property: aElt.getAttribute("property"),
                        value: value
                      } ];
      if (aElt.hasAttribute("fouredges") && aElt.hasAttribute("fouredgescontrol")) {
        if (document.getElementById(aElt.getAttribute("fouredgescontrol")).checked) {
          var edgesArray = aElt.getAttribute("fouredges").split(",");
          for (var i = 0; i < edgesArray.length; i++)
            toApply.push({
                           property: edgesArray[i],
                           value: value
                         } );
        }
      }
      if (aElt.hasAttribute("checkimageratio") &&
          gCurrentElement.localName == "img" &&
          gDialog.preserveImageRatioCheckbox.checked) {
        var id = aElt.id;
        var otherId = (id == "widthMenulist") ? "heightMenulist" : "widthMenulist";
        var otherValue = null;
        if (value == "auto" ||
            (value && value.indexOf("%") != -1))
          otherValue = value;
        else if (match) {
          var ratio = (id == "widthMenulist") ? gCurrentElement.naturalHeight / gCurrentElement.naturalWidth :
                                                gCurrentElement.naturalWidth / gCurrentElement.naturalHeight;
          otherValue = (parseFloat(match[1]) * ratio) + match[2]; 
        }
  
        if (value) {
          gDialog[otherId].value = otherValue;
          toApply.push({
                         property: gDialog[otherId].getAttribute("property"),
                         value: otherValue
                       } );
        }
      }
      ApplyStyles(toApply);
    }
  }
  if (aCallback)
    aCallback(aElt);
}

function InitLocalFontFaceMenu(menuPopup)
{
  // fill in the menu only once...
  var callingId = menuPopup.parentNode.id;

  if(!BlueGriffonVars.fontMenuOk)
    BlueGriffonVars.fontMenuOk = {};
  if (BlueGriffonVars.fontMenuOk[callingId])
    return;
  BlueGriffonVars.fontMenuOk[callingId ] = callingId ;

  if (!BlueGriffonVars.localFonts)
  {
    // Build list of all local fonts once per editor
    try 
    {
      var enumerator = Components.classes["@mozilla.org/gfx/fontenumerator;1"]
                                 .getService(Components.interfaces.nsIFontEnumerator);
      var localFontCount = { value: 0 }
      BlueGriffonVars.localFonts = enumerator.EnumerateAllFonts(localFontCount);
    }
    catch(e) { }
  }
  
  for (var i = 0; i < BlueGriffonVars.localFonts.length; ++i)
  {
    if (BlueGriffonVars.localFonts[i] != "")
    {
      var itemNode = document.createElementNS(BlueGriffonVars.kXUL_NS, "menuitem");
      itemNode.setAttribute("label", BlueGriffonVars.localFonts[i]);
      itemNode.setAttribute("value", BlueGriffonVars.localFonts[i]);
      itemNode.setAttribute("style", "font-family: " + BlueGriffonVars.localFonts[i]);
      menuPopup.appendChild(itemNode);
    }
  }
}

function ApplyStyleChangesToStylesheets(editor, aElement, property, value,
                                        aDelimitor, aRegExpDelimitor, aIdent)
{
  // first, clean the style attribute for the style to apply
  var txn = new diStyleAttrChangeTxn(aElement, property, "", "");
  EditorUtils.getCurrentEditor().transactionManager.doTransaction(txn);
  EditorUtils.getCurrentEditor().incrementModificationCount(1);  

  var inspector = Components.classes["@mozilla.org/inspector/dom-utils;1"]
                    .getService(Components.interfaces.inIDOMUtils);
  var state;
  var dynamicPseudo = "";
  if (gDialog.hoverStateCheckbox.checked) {
    state = inspector.getContentState(gCurrentElement);
    inspector.setContentState(gCurrentElement, state | 4); // NS_EVENT_STATE_HOVER
    aIdent += ":hover";
    dynamicPseudo = "hover";
  }
  var ruleset = CssInspector.getCSSStyleRules(aElement, true, dynamicPseudo);
  if (gDialog.hoverStateCheckbox.checked) {
    inspector.setContentState(gCurrentElement.ownerDocument.documentElement, state | 4);
  }
  var inspectedRule = CssInspector.findRuleForProperty(ruleset, property);
  if (inspectedRule && inspectedRule.rule) {
    // ok, that property is already applied through a CSS rule

    // is that rule dependent on the ID selector for that ID?
    // if yes, let's try to tweak it
    var priority = inspectedRule.rule.style.getPropertyPriority(property);
    var selector = inspectedRule.rule.selectorText;
    var r = new RegExp( aRegExpDelimitor + aIdent + "$|" + aRegExpDelimitor + aIdent + "[\.:,\\[]", "g");
    if (selector.match(r)) {
      // yes! can we edit the corresponding stylesheet or not?
      var sheet = inspectedRule.rule.parentStyleSheet;
      var topSheet = sheet;
      while (topSheet.parentStyleSheet)
        topSheet = topSheet.parentStyleSheet;
      if (topSheet.ownerNode &&
          (!sheet.href || sheet.href.substr(0, 4) != "http")) {
        // yes we can edit it...
        if (sheet.href) { // external stylesheet
          var txn = new diChangeFileStylesheetTxn(sheet.href, inspectedRule.rule,
                                                  property, value, priority);
          EditorUtils.getCurrentEditor().transactionManager.doTransaction(txn);  
        }
        else { // it's an embedded stylesheet
          if (value) {
            inspectedRule.rule.style.setProperty(property, value, priority);
          }
          else
            inspectedRule.rule.style.removeProperty(property);
          if (!inspectedRule.rule.style.length)
            sheet.deleteRule(inspectedRule.rule);
          CssUtils.reserializeEmbeddedStylesheet(sheet, editor);
        }
        return;
      }
    }
    // we need to check if the rule
    // has a specificity no greater than an ID's one

    // we need to find the last locally editable stylesheet
    // attached to the document
    var sheet = FindLastEditableStyleSheet();
    var spec = inspectedRule.specificity;
    if (!spec.a &&
        ((spec.b == 1 && spec.c == 0 && spec.d == 0) ||
         !spec.b)) { 
      var existingRule = CssInspector.findLastRuleInRulesetForSelector(
                           ruleset, aDelimitor + aIdent);
      if (existingRule &&
          (!existingRule.parentStyleSheet.href || existingRule.parentStyleSheet.href.substr(0, 4) != "http")) {
        sheet = existingRule.parentStyleSheet;
        existingRule.style.setProperty(property, value, priority);
      }
      else { 
        // cool, we can just create a new rule with an ID selector
        // but don't forget to set the priority...
        sheet.insertRule(aDelimitor + aIdent + "{" +
                           property + ": " + value + " " +
                           (priority ? "!important" : "") + "}",
                         sheet.cssRules.length);
      }
      if (sheet.ownerNode.href)
        CssInspector.serializeFileStyleSheet(sheet, sheet.href);
      else
        CssUtils.reserializeEmbeddedStylesheet(sheet, editor);
      return;
    }
    // at this point, we have a greater specificity; hum, then what's
    // the priority of the declaration?
    if (!priority) {
      var existingRule = CssInspector.findLastRuleInRulesetForSelector(
                           ruleset, aDelimitor + aIdent);
      if (existingRule &&
          (!existingRule.parentStyleSheet.href || existingRule.parentStyleSheet.href.substr(0, 4) != "http")) {
        sheet = existingRule.parentStyleSheet;
        existingRule.style.setProperty(property, value, "important");
      }
      else {
        // no priority, so cool we can create a !important declaration
        // for the ID
        sheet.insertRule(aDelimitor + aIdent + "{" +
                           property + ": " + value + " !important }",
                         sheet.cssRules.length);
      }
      if (sheet.ownerNode.href)
        CssInspector.serializeFileStyleSheet(sheet, sheet.href);
      else
        CssUtils.reserializeEmbeddedStylesheet(sheet, editor);
      return;
    }
    // argl, it's already a !important declaration :-( our only
    // choice is a !important style attribute... We can't just clean the
    // style on inspectedRule because some other rules could also apply
    // is that one goes away.
    var txn = new diStyleAttrChangeTxn(aElement, property, value, "important");
    EditorUtils.getCurrentEditor().transactionManager.doTransaction(txn);
    EditorUtils.getCurrentEditor().incrementModificationCount(1);  
  }
  else {
    // oh, the property is not applied yet, let's just create a rule
    // with the ID selector for that property
    var sheet;
    var existingRule = CssInspector.findLastRuleInRulesetForSelector(
                         ruleset, aDelimitor + aIdent);
    if (existingRule &&
          (!existingRule.parentStyleSheet.href || existingRule.parentStyleSheet.href.substr(0, 4) != "http")) {
      sheet = existingRule.parentStyleSheet;
      existingRule.style.setProperty(property, value, "");
    }
    else {
      sheet = FindLastEditableStyleSheet();
      sheet.insertRule(aDelimitor + aIdent + "{" +
                         property + ": " + value + " " + "}",
                       sheet.cssRules.length);
    }
    if (sheet.ownerNode.href)
      CssInspector.serializeFileStyleSheet(sheet, sheet.href);
    else
      CssUtils.reserializeEmbeddedStylesheet(sheet, editor);
  }
}

function SetColor(aElt)
{
  var color = aElt.color;
  var toApply = [
                  {
                    property: aElt.getAttribute("property"),
                    value: color
                  }
                ];
  if (aElt.hasAttribute("fouredges") && aElt.hasAttribute("fouredgescontrol")) {
    if (document.getElementById(aElt.getAttribute("fouredgescontrol")).checked) {
      var edgesArray = aElt.getAttribute("fouredges").split(",");
      for (var i = 0; i < edgesArray.length; i++)
        toApply.push({
                       property: edgesArray[i],
                       value: color
                     } );
    }
  }
  ApplyStyles(toApply);
}

function CloseAllSection(aAlsoCloseOriginalTarget)
{
  var h = document.popupNode;
  while (h && !h.classList.contains("csspropertiesHeader"))
    h = h.parentNode;
  if (!h) return; // sanity check...

  var headers = document.querySelectorAll(".csspropertiesHeader");
  for (var i = 0; i < headers.length; i++) {
    var header = headers[i];
    if ((aAlsoCloseOriginalTarget || header != h) &&
        header.hasAttribute("open"))
      ToggleSection(null, header);
  }
}

RegisterIniter(GeneralSectionIniter);

function GeneralSectionIniter(aElt, aRuleset)
{
  deleteAllChildren(gDialog.fontFamilyListbox);

  var fontFamily = CssInspector.getCascadedValue(aRuleset, "font-family");
  if (fontFamily) {
    var fonts = fontFamily.split(",");
    fonts.forEach(function(aElt, aIndex, aArray) {
        gDialog.fontFamilyListbox.appendItem(aElt, aElt);
      });
    //SetEnabledElement(gDialog.removeFontButton, gDialog.fontFamilyListbox.itemCount);
  }

  var webFonts = CssInspector.getWebFonts(EditorUtils.getCurrentDocument());
  var child = gDialog.beforeWebfontsMenuseparator.nextSibling;
  while (child && child.id != "afterWebfontsMenuseparator") {
    var tmp = child.nextSibling;
    gDialog.addFontMenupopup.removeChild(child);
    child = tmp;
  }
  var found = false;
  for (var i in webFonts) {
    found = true;
    var item = document.createElement("menuitem");
    item.setAttribute("label", i);
    item.setAttribute("value", i);
    gDialog.addFontMenupopup.insertBefore(item, gDialog.afterWebfontsMenuseparator)
  }
  gDialog.afterWebfontsMenuseparator.hidden = !found;

  var fw = CssInspector.getCascadedValue(aRuleset, "font-weight");
  CheckToggle(gDialog.fontWeightBoldButton,    fw == "bold" || fw == "700");
  CheckToggle(gDialog.fontWeightLighterButton, fw == "lighter");
  CheckToggle(gDialog.fontWeightBolderButton,  fw == "bolder");

  var fs = CssInspector.getCascadedValue(aRuleset, "font-style");
  CheckToggle(gDialog.fontStyleItalicButton,   fs == "italic");
  CheckToggle(gDialog.fontStyleObliqueButton,  fs == "oblique");

  var td = CssInspector.getCascadedValue(aRuleset, "text-decoration");
  var tdArray = td.split(" ");
  CheckToggle(gDialog.textDecorationUnderlineButton,    tdArray.indexOf("underline") != -1);
  CheckToggle(gDialog.textDecorationOverlineButton,     tdArray.indexOf("overline") != -1);
  CheckToggle(gDialog.textDecorationLinethroughButton,  tdArray.indexOf("line-through") != -1);

  var tt = CssInspector.getCascadedValue(aRuleset, "text-transform");
  CheckToggle(gDialog.textTransformLowercaseButton,   tt == "lowercase");
  CheckToggle(gDialog.textTransformUppercaseButton,   tt == "uppercase");
  CheckToggle(gDialog.textTransformLinethroughButton, tt == "capitalize");

  var ta = CssInspector.getCascadedValue(aRuleset, "text-align");
  CheckToggle(gDialog.textAlignLeftButton,    ta == "left");
  CheckToggle(gDialog.textAlignCenterButton,  ta == "center");
  CheckToggle(gDialog.textAlignRightButton,   ta == "right");
  CheckToggle(gDialog.textAlignJustifyButton, ta == "justify");

  CheckToggle(gDialog.textAlignStartButton,   ta == "start");
  CheckToggle(gDialog.textAlignEndButton,     ta == "end");

  //var fs = CssUtils.getComputedValue(aElt, "font-size");
  var fs = CssInspector.getCascadedValue(aRuleset, "font-size");
  gDialog.fontSizeMenulist.value = fs;

  var lh = CssInspector.getCascadedValue(aRuleset, "line-height");
  gDialog.lineHeightMenulist.value = lh;

  var fv = CssInspector.getCascadedValue(aRuleset, "font-variant");
  CheckToggle(gDialog.fontVariantNormalButton,    fv == "normal");
  CheckToggle(gDialog.fontVariantSmallCapsButton, fv == "small-caps");

  var ls = CssInspector.getCascadedValue(aRuleset, "letter-spacing");
  gDialog.letterSpacingMenulist.value = ls;

  var ws = CssInspector.getCascadedValue(aRuleset, "word-spacing");
  gDialog.wordSpacingMenulist.value = ws;

  var ww = CssInspector.getCascadedValue(aRuleset, "word-wrap");
  CheckToggle(gDialog.normalWordWrapButton,    ww == "normal");
  CheckToggle(gDialog.breakWrapWordWrapButton, ww == "break-word");

  var d = CssInspector.getCascadedValue(aRuleset, "direction");
  CheckToggle(gDialog.ltrDirectionButton,    d == "ltr");
  CheckToggle(gDialog.rtlDirectionButton,    d == "rtl");

  var ti = CssInspector.getCascadedValue(aRuleset, "text-indent");
  gDialog.textIndentMenulist.value = ti;

  var va = CssInspector.getCascadedValue(aRuleset, "vertical-align");
  gDialog.verticalAlignMenulist.value = va;
}

function AddFont(aEvent)
{
  var elt = aEvent.originalTarget;
  if (elt.nodeName.toLowerCase() != "menuitem")
    return;
  var value = elt.getAttribute("label");
  if (elt.hasAttribute("global")) {
    deleteAllChildren(gDialog.fontFamilyListbox);
    var fontsArray = value.split(",");
    for (var i = 0; i < fontsArray.length; i++) {
      var v = fontsArray[i].trim();
      gDialog.fontFamilyListbox.appendItem(v, v);
    }
  }
  else {
    gDialog.fontFamilyListbox.appendItem(value, value);
  }
  ApplyFontFamily();
}

function OnFontFamilySelect(aElt)
{
  var item = aElt.selectedItem;
  SetEnabledElement(gDialog.removeFontButton, (item != null));    
}

function DeleteFont()
{
  var item = gDialog.fontFamilyListbox.selectedItem;
  if (!item) return; // sanity check
  item.parentNode.removeChild(item);
  ApplyFontFamily();
}

function ApplyFontFamily()
{
  var child = gDialog.fontFamilyListbox.firstChild;
  var ff = "";
  while (child) {
    ff += (ff ? ", " : "");
    if (child.value.indexOf(" ") != -1)
      ff += '"' + child.value + '"';
    else
      ff += child.value;
    child = child.nextSibling;
  }
  ApplyStyles([
                {
                  property: "font-family",
                  value: ff
                }
              ]);
}

RegisterIniter(ColorsSectionIniter);

function ColorsSectionIniter(aElt, aRuleset)
{
  deleteAllChildren(gDialog.backgroundsRichlistbox);
  var color = CssInspector.getCascadedValue(aRuleset, "color");
  gDialog.colorColorpicker.color = color;

  var bgColor = CssInspector.getCascadedValue(aRuleset, "background-color");
  gDialog.bgColorColorpicker.color = bgColor;

  var bgImages = CssInspector.getCascadedValue(aRuleset, "background-image");
  var parsedImages = CssInspector.parseBackgroundImages(bgImages);
  var bgAttachment = CssInspector.getCascadedValue(aRuleset, "background-attachment").split(",");
  var bgRepeat     = CssInspector.getCascadedValue(aRuleset, "background-repeat").split(",");
  var bgPosition   = CssInspector.getCascadedValue(aRuleset, "background-position").split(",");
  var bgSize       = CssInspector.getCascadedValue(aRuleset, "background-size").split(",");
  var bgClip       = CssInspector.getCascadedValue(aRuleset, "background-clip").split(",");
  var bgOrigin     = CssInspector.getCascadedValue(aRuleset, "background-origin").split(",");
  if (bgImages != "none") {
    for (var i = 0; i < parsedImages.length; i++) {
      var item = document.createElement("richlistitem");
      item.className = "backgrounditem";
      var type = parsedImages[i].type;
      item.setAttribute("type", type);
      gDialog.backgroundsRichlistbox.appendChild(item);
  
      item.reset();
      var button = item.getChild("backgrounditemButton");
      item.parsedValue = parsedImages[i].value;
      switch (type) {
        case "image":
          // pfff, find the real URL...
          var match = item.parsedValue.match ( /^url\(\s*"([^"]*)"\s*\)|^url\(\s*'([^']*)'\s*\)|^url\(\s*([^\)]*)\s*\)/ );
          if (match) {
            if (match[1]) item.setAttribute("image", match[1]);
            else if (match[2]) item.setAttribute("image", match[2]);
            else if (match[3]) item.setAttribute("image", match[3]);
          }
          button.style.backgroundImage = "url('" + UrlUtils.makeAbsoluteUrl(item.getAttribute("image")) + "')";
          break;
        default:
          button.style.backgroundImage =
            CssInspector.serializeGradient(item.parsedValue);
          break;
      }
      item.getChild("backgrounditem-attachment").value =
        (i < bgAttachment.length ? bgAttachment[i].trim() : "");
      item.getChild("backgrounditem-repeat").value =
        (i < bgRepeat.length ? bgRepeat[i].trim() : "");
      item.getChild("backgrounditem-position").value =
        (i < bgPosition.length ? bgPosition[i].trim() : "");
      item.getChild("backgrounditem-size").value =
        (i < bgSize.length ? bgSize[i].trim() : "");
      item.getChild("backgrounditem-clip").value =
        (i < bgClip.length ? bgClip[i].trim() : "");
      item.getChild("backgrounditem-origin").value =
        (i < bgOrigin.length ? bgOrigin[i].trim() : "");
    }
  }
}

function AddBackground(aEvent)
{
  var type = aEvent.originalTarget.value;
  var item = document.createElement("richlistitem");
  item.className = "backgrounditem";
  item.setAttribute("type", type);
  gDialog.backgroundsRichlistbox.appendChild(item);
  item.reset();
  item.openEditor();
}

function OnBackgroundSelect(aElt)
{
  var item = aElt.selectedItem;
  SetEnabledElement(gDialog.removeBackgroundButton, (item != null));    
}

function DeleteBackground()
{
  var item = gDialog.backgroundsRichlistbox.selectedItem;
  if (!item) return; // sanity check
  item.parentNode.removeChild(item);
  SetEnabledElement(gDialog.removeBackgroundButton, (gDialog.backgroundsRichlistbox.itemCount != 0));
  ReapplyBackgrounds();
}

function LoadImage()
{
  gDialog.previewBackgroundImage.style.backgroundImage =
    'url("' + UrlUtils.makeAbsoluteUrl(gDialog.imageURLTextbox.inputField.value) + '")';
}

function BackgroundImageSelected()
{
  gDialog.backgroundImagePanel.hidePopup();
  var item = gDialog.backgroundsRichlistbox.selectedItem;
  item.applyBackgroundImage(gDialog.imageURLTextbox.value);
}

function ReapplyBackgrounds()
{
  var items = gDialog.backgroundsRichlistbox.querySelectorAll("richlistitem");
  var bgColor = "", bgImages = [];
  for (var i = 0; i < items.length; i++) {
    var item = items[i];
    bgImages.push(item.serializedValue);
  }
  ApplyStyles([
                {
                  property: "background-image",
                  value: bgImages.join(", ")
                }
              ]);
  SelectionChanged(null, gCurrentElement, true);
}

function RepaintGradient()
{
  var angle = gDialog.linearGradientAngleCheckbox.checked ? gDialog.linearGradientAngleRotator.value + "deg"
                                                          : "";
  var startingPoint = gDialog.linearGradientStartingPointCheckbox.checked ? gDialog.linearGradientStartingPointMenulist.value
                                                          : "";
  var hOffset = gDialog.linearGradientHorizOffsetCheckbox.checked ? gDialog.linearGradientHorizOffset.value
                                                          : "";
  var type = gDialog.shapeAndSizeTab.hidden
             ? (gDialog.repeatingGradientCheckbox.checked ? "-moz-repeating-linear-gradient(" : "-moz-linear-gradient(")
             : (gDialog.repeatingGradientCheckbox.checked ? "-moz-repeating--radial-gradient(" : "-moz-radial-gradient(");
  var str = type + ((angle || startingPoint) ? angle + " " + startingPoint + "," : "");
  if (!gDialog.shapeAndSizeTab.hidden) {
    var shape = gDialog.radialGradientShape.selectedItem.value;
    var size  = gDialog.radioGradientSize.value;
    str += ((shape || size) ? shape + " " + size + "," : "");
  }

  var stops = gDialog.colorStopsRichlistbox.querySelectorAll("richlistitem.colorstopitem");
  for (var i = 0; i < stops.length; i++) {
    if (i)
      str += ", ";
    var s = stops[i];
    str += s.color + (s.offset ? " " + s.offset : "");
  }
  str += ")";
  gDialog.linearGradientPreview.style.backgroundImage = str;
}

function SetLinearGradient()
{
  var gradient = gDialog.linearGradientPreview.style.backgroundImage;
  var item = gDialog.backgroundsRichlistbox.selectedItem;
  item.getChild("backgrounditemButton").style.backgroundImage = gradient;
  item.parsedValue = CssInspector.parseBackgroundImages(gradient)[0].value;
  gDialog.linearGradientPanel.hidePopup();
  ReapplyBackgrounds();
}

function UpdateColorStopsRichlistbox()
{
  var item = gDialog.colorStopsRichlistbox.selectedItem;
  if (gDialog.colorStopsRichlistbox.itemCount && item &&
      item.parentNode) {
    gDialog.removeColorStopButton.disabled = false;
    gDialog.upColorStopButton.disabled = !item.previousElementSibling;
    gDialog.downColorStopButton.disabled = !item.nextElementSibling;
  }
  else {
    gDialog.removeColorStopButton.disabled = true;
    gDialog.upColorStopButton.disabled = true;
    gDialog.downColorStopButton.disabled = true;
  }
  gDialog.linearGradientOkButton.disabled = (gDialog.colorStopsRichlistbox.itemCount < 2);
}

function AddColorStopToLinearGradient()
{
  var e = document.createElement("richlistitem");
  e.className = "colorstopitem";
  gDialog.colorStopsRichlistbox.appendChild(e);
  UpdateColorStopsRichlistbox();
  e.openEditor();
}

function DeleteColorStopFromLinearGradient()
{
  gDialog.colorStopsRichlistbox.removeChild(gDialog.colorStopsRichlistbox.selectedItem);
  UpdateColorStopsRichlistbox();
}

function FlushBackgroundProperties(aEvent)
{
  var target = aEvent.originalTarget;
  while (target && !target.hasAttribute("property"))
    target = target.parentNode;
  var property = target.getAttribute("property");
  var anonid = target.getAttribute("anonid");

  var valueArray = []
  var items = document.querySelectorAll("richlistitem.backgrounditem");
  for (var i = 0; i < items.length; i++) {
    var xulElt = items[i].getChild(anonid);
    valueArray.push( xulElt.value );
  }
  // cleanup
  for (var i = valueArray.length - 1 ; i >=0; i++)
    if (valueArray[i] == "")
      valueArray.pop();
    else
      break;
  ApplyStyles([
                {
                  property: property,
                  value: valueArray.join(", ")
                }
              ]);
}

function ToggleRelativeOrAbsoluteBackgroundImage()
{
  if (gDialog.relativeBackgroundImageCheckbox.checked) {
    MakeRelativeUrlBackgroundImage();
  }
  else {
    MakeAbsoluteUrlBackgroundImage();
  }
}

function MakeRelativeUrlBackgroundImage()
{
  var spec = gDialog.imageURLTextbox.value;
  var docUrl = EditorUtils.getDocumentUrl();
  var docUrlScheme = UrlUtils.getScheme(docUrl);
  if (docUrlScheme && docUrlScheme != "resource") {
    spec = UrlUtils.makeRelativeUrl(spec);
    gDialog.imageURLTextbox.value = spec;
    gDialog.relativeBackgroundImageCheckbox.checked = true;
  }
}

function MakeAbsoluteUrlBackgroundImage()
{
  var spec = gDialog.imageURLTextbox.value;
  var docUrl = EditorUtils.getDocumentUrl();
  var docUrlScheme = UrlUtils.getScheme(docUrl);
  if (docUrlScheme && docUrlScheme != "resource") {
    spec = UrlUtils.makeAbsoluteUrl(spec);
    gDialog.imageURLTextbox.value = spec;
    gDialog.relativeBackgroundImageCheckbox.checked = false;
  }
}
RegisterIniter(GeometrySectionIniter);

function GeometrySectionIniter(aElt, aRuleset)
{
  var mt = CssInspector.getCascadedValue(aRuleset, "margin-top");
  var mb = CssInspector.getCascadedValue(aRuleset, "margin-bottom");
  var ml = CssInspector.getCascadedValue(aRuleset, "margin-left");
  var mr = CssInspector.getCascadedValue(aRuleset, "margin-right");
  var afm = (mt == mb && mt == ml && mt == mr);
  gDialog.useSameFourMarginsCheckbox.checked = afm;
  gDialog.marginRightMenulist.style.visibility = (afm ? "hidden": "");
  gDialog.marginLeftMenulist.style.visibility = (afm ? "hidden": "");
  gDialog.marginTopMenulist.style.visibility = (afm ? "hidden": "");
  gDialog.marginRightMenulist.nextElementSibling.style.visibility = afm ? "hidden": "";
  gDialog.marginLeftMenulist.nextElementSibling.style.visibility = afm ? "hidden": "";
  gDialog.marginTopMenulist.nextElementSibling.style.visibility = afm ? "hidden": "";
  gDialog.marginTopMenulist.value = mt;
  gDialog.marginBottomMenulist.value = mb;
  gDialog.marginLeftMenulist.value = ml;
  gDialog.marginRightMenulist.value = mr;

  var pt = CssInspector.getCascadedValue(aRuleset, "padding-top");
  var pb = CssInspector.getCascadedValue(aRuleset, "padding-bottom");
  var pl = CssInspector.getCascadedValue(aRuleset, "padding-left");
  var pr = CssInspector.getCascadedValue(aRuleset, "padding-right");
  var afp = (pt == pb && pt == pl && pt == pr);
  gDialog.useSameFourPaddingsCheckbox.checked = afp;
  gDialog.paddingRightMenulist.style.visibility = (afp ? "hidden" : "");
  gDialog.paddingLeftMenulist.style.visibility = (afp ? "hidden" : "");
  gDialog.paddingTopMenulist.style.visibility = (afp ? "hidden" : "");
  gDialog.paddingRightMenulist.nextElementSibling.style.visibility = (afp ? "hidden" : "");
  gDialog.paddingLeftMenulist.nextElementSibling.style.visibility = (afp ? "hidden" : "");
  gDialog.paddingTopMenulist.nextElementSibling.style.visibility = (afp ? "hidden" : "");
  gDialog.paddingTopMenulist.value = pt;
  gDialog.paddingBottomMenulist.value = pb;
  gDialog.paddingLeftMenulist.value = pl;
  gDialog.paddingRightMenulist.value = pr;

  var w = CssInspector.getCascadedValue(aRuleset, "width");
  gDialog.widthMenulist.value = w;
  var mw = CssInspector.getCascadedValue(aRuleset, "min-width");
  gDialog.minWidthMenulist.value = mw;
  var Mw = CssInspector.getCascadedValue(aRuleset, "max-width");
  gDialog.maxWidthMenulist.value = Mw;
  var h = CssInspector.getCascadedValue(aRuleset, "height");
  gDialog.heightMenulist.value = h;
  var mh = CssInspector.getCascadedValue(aRuleset, "min-height");
  gDialog.minHeightMenulist.value = mh;
  var Mh = CssInspector.getCascadedValue(aRuleset, "max-height");
  gDialog.maxHeightMenulist.value = Mh;

  var isImg = ("nodeName" in aElt
               && aElt.nodeName.toLowerCase() == "img");
  gDialog.preserveImageRatioCheckbox.hidden = !isImg;
  if (isImg)
    gDialog.getNaturalSizeButton.removeAttribute("hidden");
  else
    gDialog.getNaturalSizeButton.setAttribute("hidden", "true");
}

function ToggleFourEdges(aCheckbox, aPrefix)
{
  var checked = aCheckbox.checked;
  gDialog[aPrefix + "RightMenulist"].style.visibility = (checked ? "hidden": "");
  gDialog[aPrefix + "LeftMenulist"].style.visibility = (checked ? "hidden": "");
  gDialog[aPrefix + "TopMenulist"].style.visibility = (checked ? "hidden": "");
  gDialog[aPrefix + "RightMenulist"].nextElementSibling.style.visibility = (checked ? "hidden": "");
  gDialog[aPrefix + "LeftMenulist"].nextElementSibling.style.visibility = (checked ? "hidden": "");
  gDialog[aPrefix + "TopMenulist"].nextElementSibling.style.visibility = (checked ? "hidden": "");
  if (checked) {
    var value = gDialog[aPrefix + "BottomMenulist"].value;
    gDialog[aPrefix + "RightMenulist"].value= value;
    gDialog[aPrefix + "LeftMenulist"].value= value;
    gDialog[aPrefix + "TopMenulist"].value= value;
    onLengthMenulistCommand(gDialog[aPrefix + "BottomMenulist"], '% px pt cm in mm pc em ex rem ch', '', false);
  }
}

function GetNaturalSize()
{
  gDialog.widthMenulist.value = gCurrentElement.naturalWidth + "px";
  gDialog.heightMenulist.value = gCurrentElement.naturalHeight + "px";
  gDialog.preserveImageRatioCheckbox.checked = true;
  ApplyStyles( [ {
                  property: "width",
                  value: gDialog.widthMenulist.value
                },
                {
                  property: "height",
                  value: gDialog.heightMenulist.value
                }
  ]);
}
RegisterIniter(PositionSectionIniter);

function PositionSectionIniter(aElt, aRuleset)
{
  var d = CssInspector.getCascadedValue(aRuleset, "display");
  gDialog.displayMenulist.value = d;

  var v = CssInspector.getCascadedValue(aRuleset, "visibility");
  CheckToggle(gDialog.visibleVisibilityButton,   v == "visible");
  CheckToggle(gDialog.hiddenVisibilityButton,    v == "hidden");
  CheckToggle(gDialog.collapseVisibilityButton,  v == "collapse");

  var f = CssInspector.getCascadedValue(aRuleset, "float");
  CheckToggle(gDialog.floatLeftButton,   f == "left");
  CheckToggle(gDialog.floatNoneButton,   f == "none");
  CheckToggle(gDialog.floatRightButton,  f == "right");

  var p = CssInspector.getCascadedValue(aRuleset, "position");
  CheckToggle(gDialog.positionStaticButton,   p == "static");
  CheckToggle(gDialog.positionRelativeButton, p == "relative");
  CheckToggle(gDialog.positionAbsoluteButton, p == "absolute");
  CheckToggle(gDialog.positionFixedButton,    p == "fixed");

  var zi = CssInspector.getCascadedValue(aRuleset, "z-index");
  gDialog.zIndexMenulist.value = zi;

  var t = CssInspector.getCascadedValue(aRuleset, "top");
  var l = CssInspector.getCascadedValue(aRuleset, "left");
  var r = CssInspector.getCascadedValue(aRuleset, "right");
  var b = CssInspector.getCascadedValue(aRuleset, "bottom");
  gDialog.topMenulist.value = t;
  gDialog.leftMenulist.value = l;
  gDialog.rightMenulist.value = r;
  gDialog.bottomMenulist.value = b;

  var c = CssInspector.getCascadedValue(aRuleset, "clear");
  CheckToggle(gDialog.clearLeftButton,   c == "left");
  CheckToggle(gDialog.clearRightButton,  c == "right");
  CheckToggle(gDialog.clearBothButton,   c == "both");
  CheckToggle(gDialog.clearNoneButton,   c == "none");

  var o = CssInspector.getCascadedValue(aRuleset, "overflow");
  CheckToggle(gDialog.visibleOverflowButton,  o == "visible");
  CheckToggle(gDialog.hiddenOverflowButton,   o == "hidden");
  CheckToggle(gDialog.scrollOverflowButton,   o == "scroll");
  CheckToggle(gDialog.autoOverflowButton,     o == "auto");

  var to = CssInspector.getCascadedValue(aRuleset, "text-overflow");
  CheckToggle(gDialog.clipTextOverflowButton,       to == "clip");
  CheckToggle(gDialog.ellipsisTextOverflowButton,   to == "ellipsis");
}
Components.utils.import("resource://app/modules/urlHelper.jsm");

RegisterIniter(BordersSectionIniter);

function BordersSectionIniter(aElt, aRuleset)
{
  var bbw = CssInspector.getCascadedValue(aRuleset, "border-bottom-width");
  var btw = CssInspector.getCascadedValue(aRuleset, "border-top-width");
  var blw = CssInspector.getCascadedValue(aRuleset, "border-left-width");
  var brw = CssInspector.getCascadedValue(aRuleset, "border-right-width");

  var bbs = CssInspector.getCascadedValue(aRuleset, "border-bottom-style");
  var bts = CssInspector.getCascadedValue(aRuleset, "border-top-style");
  var bls = CssInspector.getCascadedValue(aRuleset, "border-left-style");
  var brs = CssInspector.getCascadedValue(aRuleset, "border-right-style");

  var bbc = CssInspector.getCascadedValue(aRuleset, "border-bottom-color");
  var btc = CssInspector.getCascadedValue(aRuleset, "border-top-color");
  var blc = CssInspector.getCascadedValue(aRuleset, "border-left-color");
  var brc = CssInspector.getCascadedValue(aRuleset, "border-right-color");

  gDialog.borderTopColorpicker.color    = btc;
  gDialog.borderLeftColorpicker.color   = blc;
  gDialog.borderRightColorpicker.color  = brc;
  gDialog.borderBottomColorpicker.color = bbc;

  gDialog.borderTopWidthMenulist.value    = btw;
  gDialog.borderLeftWidthMenulist.value   = blw;
  gDialog.borderRightWidthMenulist.value  = brw;
  gDialog.borderBottomWidthMenulist.value = bbw;

  gDialog.borderTopStyleMenulist.value    = bts;
  gDialog.borderLeftStyleMenulist.value   = bls;
  gDialog.borderRightStyleMenulist.value  = brs;
  gDialog.borderBottomStyleMenulist.value = bbs;

  var sameOnFourEdges =  (bbw == btw && bbw == blw && bbw == brw &&
                          bbs == bts && bbs == bls && bbs == brs &&
                          bbc == btc && bbc == blc && bbc == brc);
  gDialog.sameBorderOnFourEdgesCheckbox.checked = sameOnFourEdges;

  gDialog.borderTopColorpicker.parentNode.hidden = sameOnFourEdges;
  gDialog.borderLeftColorpicker.parentNode.hidden = sameOnFourEdges;
  gDialog.borderRightColorpicker.parentNode.hidden = sameOnFourEdges;
  gDialog.borderBottomLabel.style.visibility = (sameOnFourEdges ? "hidden" : "visible");

  var tlCorner = CssInspector.getCascadedValue(aRuleset, "border-top-left-radius");
  var trCorner = CssInspector.getCascadedValue(aRuleset, "border-top-right-radius");
  var blCorner = CssInspector.getCascadedValue(aRuleset, "border-bottom-left-radius");
  var brCorner = CssInspector.getCascadedValue(aRuleset, "border-bottom-right-radius");
  var sameFourCorners = (tlCorner == trCorner && tlCorner == blCorner && tlCorner == brCorner);
  var r = new RegExp( "([+-]?[0-9]*\\.[0-9]+|[+-]?[0-9]+)(%|px|pt|cm|in|mm|pc|em|ex|ch|rem)*", "g");
  tlCorner = tlCorner.match(r);
  trCorner = trCorner.match(r);
  blCorner = blCorner.match(r);
  brCorner = brCorner.match(r);
  gDialog.topLeftBorderRadiusXMenulist.value = (tlCorner && tlCorner.length) ? tlCorner[0] : "0px";
  gDialog.topLeftBorderRadiusYMenulist.value = (tlCorner && tlCorner.length == 2) ? tlCorner[1] : gDialog.topLeftBorderRadiusXMenulist.value;
  gDialog.topRightBorderRadiusXMenulist.value = (trCorner && trCorner.length) ? trCorner[0] : "0px";
  gDialog.topRightBorderRadiusYMenulist.value = (trCorner && trCorner.length == 2) ? trCorner[1] : gDialog.topRightBorderRadiusXMenulist.value;
  gDialog.bottomLeftBorderRadiusXMenulist.value = (blCorner && blCorner.length) ? blCorner[0] : "0px";
  gDialog.bottomLeftBorderRadiusYMenulist.value = (blCorner && blCorner.length == 2) ? blCorner[1] : gDialog.bottomLeftBorderRadiusXMenulist.value;
  gDialog.bottomRightBorderRadiusXMenulist.value = (brCorner && brCorner.length) ? brCorner[0] : "0px";
  gDialog.bottomRightBorderRadiusYMenulist.value = (brCorner && brCorner.length == 2) ? brCorner[1] : gDialog.bottomRightBorderRadiusXMenulist.value;

  gDialog.topLeftBorderRadiusXMenulist.parentNode.parentNode.hidden = sameFourCorners;
  gDialog.topRightBorderRadiusXMenulist.parentNode.parentNode.hidden = sameFourCorners;
  gDialog.bottomLeftBorderRadiusXMenulist.parentNode.parentNode.hidden = sameFourCorners;
  gDialog.bottomRightCornerLabel.style.visibility = sameFourCorners ? "hidden" : "visible";
  gDialog.sameFourCornersCheckbox.checked = sameFourCorners;

  var bi = CssInspector.getCascadedValue(aRuleset, "-moz-border-image");
  var hasBorderImage = (bi && bi != "none");
  gDialog.useImageAsBorderCheckbox.checked = hasBorderImage
  gDialog.useImageAsBorderVbox.hidden = !hasBorderImage;
  var parsedBi = CssInspector.parseBorderImage(bi);
  gDialog.borderImageURLTextbox.value = parsedBi ? MakeAbsoluteUrl(parsedBi.url) : "";
  gDialog.topEdgeSlicingTextbox.value    = 0;
  gDialog.leftEdgeSlicingTextbox.value   = 0;
  gDialog.rightEdgeSlicingTextbox.value  = 0;
  gDialog.bottomEdgeSlicingTextbox.value = 0;
  gDialog.borderSliceLeftWidthMenulist.value = "";
  gDialog.borderSliceRightWidthMenulist.value = "";
  gDialog.borderSliceTopWidthMenulist.value = "";
  gDialog.borderSliceBottomWidthMenulist.value = "";
  if (parsedBi) {
    LoadBorderImage();
    switch (parsedBi.offsets.length) {
      case 1:
        gDialog.topEdgeSlicingTextbox.value = parsedBi.offsets[0];
        gDialog.leftEdgeSlicingTextbox.value = parsedBi.offsets[0];
        gDialog.rightEdgeSlicingTextbox.value = parsedBi.offsets[0];
        gDialog.bottomEdgeSlicingTextbox.value = parsedBi.offsets[0];
        break;
      case 2:
        gDialog.topEdgeSlicingTextbox.value = parsedBi.offsets[0];
        gDialog.leftEdgeSlicingTextbox.value = parsedBi.offsets[1];
        gDialog.rightEdgeSlicingTextbox.value = parsedBi.offsets[1];
        gDialog.bottomEdgeSlicingTextbox.value = parsedBi.offsets[0];
        break;
      case 3:
        gDialog.topEdgeSlicingTextbox.value = parsedBi.offsets[0];
        gDialog.leftEdgeSlicingTextbox.value = parsedBi.offsets[1];
        gDialog.rightEdgeSlicingTextbox.value = parsedBi.offsets[1];
        gDialog.bottomEdgeSlicingTextbox.value = parsedBi.offsets[2];
        break;
      case 4:
        gDialog.topEdgeSlicingTextbox.value = parsedBi.offsets[0];
        gDialog.leftEdgeSlicingTextbox.value = parsedBi.offsets[3];
        gDialog.rightEdgeSlicingTextbox.value = parsedBi.offsets[1];
        gDialog.bottomEdgeSlicingTextbox.value = parsedBi.offsets[2];
        break;
      default: break; // should never happen
    }
    switch (parsedBi.widths.length) {
      case 1:
        gDialog.borderSliceTopWidthMenulist.value = parsedBi.widths[0];
        gDialog.borderSliceLeftWidthMenulist.value = parsedBi.widths[0];
        gDialog.borderSliceRightWidthMenulist.value = parsedBi.widths[0];
        gDialog.borderSliceBottomWidthMenulist.value = parsedBi.widths[0];
        break;
      case 2:
        gDialog.borderSliceTopWidthMenulist.value = parsedBi.widths[0];
        gDialog.borderSliceLeftWidthMenulist.value = parsedBi.widths[1];
        gDialog.borderSliceRightWidthMenulist.value = parsedBi.widths[1];
        gDialog.borderSliceBottomWidthMenulist.value = parsedBi.widths[0];
        break;
      case 3:
        gDialog.borderSliceTopWidthMenulist.value = parsedBi.widths[0];
        gDialog.borderSliceLeftWidthMenulist.value = parsedBi.widths[1];
        gDialog.borderSliceRightWidthMenulist.value = parsedBi.widths[1];
        gDialog.borderSliceBottomWidthMenulist.value = parsedBi.widths[2];
        break;
      case 4:
        gDialog.borderSliceTopWidthMenulist.value = parsedBi.widths[0];
        gDialog.borderSliceLeftWidthMenulist.value = parsedBi.widths[3];
        gDialog.borderSliceRightWidthMenulist.value = parsedBi.widths[1];
        gDialog.borderSliceBottomWidthMenulist.value = parsedBi.widths[2];
        break;
      default: break; // should never happen
    }
    MakeRelativeUrl();
    gDialog.borderImageFromTop.setAttribute("top", 15 + parseFloat(gDialog.topEdgeSlicingTextbox.value));
    gDialog.borderImageFromLeft.setAttribute("left", 15 + parseFloat(gDialog.leftEdgeSlicingTextbox.value));
    gDialog.borderImageFromRight.setAttribute("right", 15 + parseFloat(gDialog.rightEdgeSlicingTextbox.value));
    gDialog.borderImageFromBottom.setAttribute("bottom", 15 + parseFloat(gDialog.bottomEdgeSlicingTextbox.value));
  }
}

function ToggleSameBorderOnFourEdges(aElt)
{
  var sameOnFourEdges = aElt.checked;
  if (sameOnFourEdges) {
    var bbc = gDialog.borderBottomColorpicker.color;
    var bbs = gDialog.borderBottomStyleMenulist.value;
    var bbw = gDialog.borderBottomWidthMenulist.value;

    gDialog.borderTopColorpicker.color = bbc;
    gDialog.borderLeftColorpicker.color = bbc;
    gDialog.borderRightColorpicker.color = bbc;

    gDialog.borderTopStyleMenulist.value = bbs;
    gDialog.borderLeftStyleMenulist.value = bbs;
    gDialog.borderRightStyleMenulist.value = bbs;

    gDialog.borderTopWidthMenulist.value = bbw;
    gDialog.borderLeftWidthMenulist.value = bbw;
    gDialog.borderRightWidthMenulist.value = bbw;
    var toApply = [
                    {
                      property: "border-top-color",
                      value: bbc
                    },
                    {
                      property: "border-left-color",
                      value: bbc
                    },
                    {
                      property: "border-right-color",
                      value: bbc
                    },
                    {
                      property: "border-top-style",
                      value: bbs
                    },
                    {
                      property: "border-left-style",
                      value: bbs
                    },
                    {
                      property: "border-right-style",
                      value: bbs
                    },
                    {
                      property: "border-top-width",
                      value: bbw
                    },
                    {
                      property: "border-left-width",
                      value: bbw
                    },
                    {
                      property: "border-right-width",
                      value: bbw
                    }
                  ];
    ApplyStyles(toApply);
  }
  gDialog.borderTopColorpicker.parentNode.hidden = sameOnFourEdges;
  gDialog.borderLeftColorpicker.parentNode.hidden = sameOnFourEdges;
  gDialog.borderRightColorpicker.parentNode.hidden = sameOnFourEdges;
  gDialog.borderBottomLabel.style.visibility = (sameOnFourEdges ? "hidden" : "visible");
}

function ApplyBorderRadius(aElt)
{
  var id = aElt.id;
  var elts = [];
  var property = "";
  switch (id) {
    case "topLeftBorderRadiusXMenulist":
    case "topLeftBorderRadiusYMenulist":
      elts.push("topLeftBorderRadiusXMenulist");
      elts.push("topLeftBorderRadiusYMenulist");
      property = "border-top-left-radius";
      break;
    case "topRightBorderRadiusXMenulist":
    case "topRightBorderRadiusYMenulist":
      elts.push("topRightBorderRadiusXMenulist");
      elts.push("topRightBorderRadiusYMenulist");
      property = "border-top-right-radius";
      break;
    case "bottomLeftBorderRadiusXMenulist":
    case "bottomLeftBorderRadiusYMenulist":
      elts.push("bottomLeftBorderRadiusXMenulist");
      elts.push("bottomLeftBorderRadiusYMenulist");
      property = "border-bottom-left-radius";
      break;
    case "bottomRightBorderRadiusXMenulist":
    case "bottomRightBorderRadiusYMenulist":
      elts.push("bottomRightBorderRadiusXMenulist");
      elts.push("bottomRightBorderRadiusYMenulist");
      property = "border-bottom-right-radius";
      break;
  }
  var val1    = gDialog[elts[0]].value;
  var val2    = (gDialog[elts[1]].value ? "/ " + gDialog[elts[1]].value : "");
  var val2bis = (gDialog[elts[1]].value ? gDialog[elts[1]].value : "");
  if (gDialog.sameFourCornersCheckbox.checked)
    ApplyStyles([
                  {
                    property: "border-radius",
                    value: val1 + val2
                  }
                ]);
  else
    ApplyStyles([
                  {
                    property: property,
                    value: val1 + val2bis
                  }
                ]);
}

function ToggleSameFourCorners(aElt)
{
  var sameFourCorners = aElt.checked;
  if (sameFourCorners) {
    var brCX = gDialog.bottomRightBorderRadiusXMenulist.value;
    var brCY = gDialog.bottomRightBorderRadiusYMenulist.value;
    gDialog.topLeftBorderRadiusXMenulist.value = brCX;
    gDialog.topRightBorderRadiusXMenulist.value = brCX;
    gDialog.bottomLeftBorderRadiusXMenulist.value = brCX;
    gDialog.topLeftBorderRadiusYMenulist.value = brCY;
    gDialog.topRightBorderRadiusYMenulist.value = brCY;
    gDialog.bottomLeftBorderRadiusYMenulist.value = brCY;
    var str = brCX;
    str += ((str || brCY) ? " " + brCY : "");
    ApplyStyles([
                  {
                    property: "border-radius",
                    value: str.trim()
                  }
                ]);
  }
  gDialog.topLeftBorderRadiusXMenulist.parentNode.parentNode.hidden = sameFourCorners;
  gDialog.topRightBorderRadiusXMenulist.parentNode.parentNode.hidden = sameFourCorners;
  gDialog.bottomLeftBorderRadiusXMenulist.parentNode.parentNode.hidden = sameFourCorners;
  gDialog.bottomRightCornerLabel.style.visibility = sameFourCorners ? "hidden" : "visible";
}

function ToggleImageAsBorder(aElt)
{
  var ok = aElt.checked;
  gDialog.useImageAsBorderVbox.hidden = !ok;
  if (!ok) {
    ApplyStyles([
                  {
                    property: "-moz-border-image",
                    value: ""
                  }
                ]);
  }
}

function MakeRelativeUrl()
{
  var spec = gDialog.borderImageURLTextbox.value;
  var docUrl = EditorUtils.getDocumentUrl();
  var docUrlScheme = UrlUtils.getScheme(docUrl);
  if (docUrlScheme && docUrlScheme != "resource") {
    spec = UrlUtils.makeRelativeUrl(spec);
    gDialog.borderImageURLTextbox.value = spec;
  }
}

function MakeAbsoluteUrl(spec)
{
  var docUrl = EditorUtils.getDocumentUrl();
  var docUrlScheme = UrlUtils.getScheme(docUrl);
  if (docUrlScheme && docUrlScheme != "resource") {
    spec = UrlUtils.makeAbsoluteUrl(spec);
  }
  return spec;
}

function LoadBorderImage()
{
  gDialog.borderImagePreviewBox.hidden = false;
  // reset all
  gDialog.topEdgeSlicingTextbox.value    = 0;
  gDialog.leftEdgeSlicingTextbox.value   = 0;
  gDialog.rightEdgeSlicingTextbox.value  = 0;
  gDialog.bottomEdgeSlicingTextbox.value = 0;

  gDialog.borderImageFromTop.setAttribute("top", 15);
  gDialog.borderImageFromLeft.setAttribute("left", 15);
  gDialog.borderImageFromRight.setAttribute("right", 15);
  gDialog.borderImageFromBottom.setAttribute("bottom", 15);
  gDialog.borderImagePreview.setAttribute("src", gDialog.borderImageURLTextbox.value);
}

function ErrorLoadingBorderImage()
{
  gDialog.borderImagePreview.setAttribute("src", "");
  gDialog.borderImagePreviewBox.hidden = true;
}

function SizeBorderImageRulers(aElt)
{
  var w = aElt.boxObject.width;
  var h = aElt.boxObject.height;
  gDialog.borderImageFromTop.style.width = (w + 30) + "px";
  gDialog.borderImageFromBottom.style.width = (w + 30) + "px";
  gDialog.borderImageFromLeft.style.height = (h + 30) + "px";
  gDialog.borderImageFromRight.style.height = (h + 30) + "px";
}

var gMoving = false;
var gX, gY;
var gOriginal;
function StartMovingBorderImageSliceEdge(aEvent, aElt, aEdge)
{
  gMoving = true;
  gX = aEvent.clientX;
  gY = aEvent.clientY;
  gOriginal = aElt.getAttribute(aEdge);
  aElt.setCapture(false);
  aElt.className = "moving";
}

function MoveBorderImageSliceEdge(aEvent, aElt, aEdge)
{
  if (!gMoving)
    return;
  var x = aEvent.clientX
  var y = aEvent.clientY;
  var diff;
  switch (aEdge)
  {
    case "top":    diff = y - gY; break;
    case "left":   diff = x - gX; break;
    case "right":  diff = gX - x; break;
    case "bottom": diff = gY - y; break;
    default: break; //should never happen
  }
  value = parseFloat(gOriginal) + diff;
  if (value < 15)
    value = 15;
  switch (aEdge)
  {
    case "top":    
    case "bottom": value = Math.min(value, gDialog.borderImagePreview.boxObject.height + 15); break;

    case "left":
    case "right":  value = Math.min(value, gDialog.borderImagePreview.boxObject.width + 15); break;
    default: break; //should never happen
  }
  aElt.setAttribute(aEdge, value);
  gDialog[aEdge + "EdgeSlicingTextbox"].value = value - 15;
  switch (aEdge) {
    case "top":
      gDialog.borderSliceTopWidthMenulist.value = (value -15) + "px";
      break;
    case "right":
      gDialog.borderSliceRightWidthMenulist.value = (value -15) + "px";
      break;
    case "bottom":
      gDialog.borderSliceBottomWidthMenulist.value = (value -15) + "px";
      break;
    case "left":
      gDialog.borderSliceLeftWidthMenulist.value = (value -15) + "px";
      break;
  }
}

function StopMovingBorderImageSliceEdge(aEvent, aElt, aEdge)
{
  aElt.releaseCapture();
  aElt.className = "";
  gMoving = false;
  ApplyBorderImage(false);
}

function ApplyBorderImageSliceChangeFromTextbox(aElt)
{
  var id = aElt.id;
  var value = aElt.value;
  switch (id) {
    case "leftEdgeSlicingTextbox":
      gDialog.borderImageFromLeft.setAttribute("left", 15 + Number(value));
      gDialog.borderSliceLeftWidthMenulist.value = value + "px";
      break;
    case "rightEdgeSlicingTextbox":
      gDialog.borderImageFromRight.setAttribute("right", 15 + Number(value));
      gDialog.borderSliceRightWidthMenulist.value = value + "px";
      break;
    case "topEdgeSlicingTextbox":
      gDialog.borderImageFromTop.setAttribute("top", 15 + Number(value));
      gDialog.borderSliceRightWidthMenulist.value = value + "px";
      break;
    case "bottomEdgeSlicingTextbox":
      gDialog.borderImageFromBottom.setAttribute("bottom", 15 + Number(value));
      gDialog.borderSliceRightWidthMenulist.value = value + "px";
      break;
    default: break; // should never happen
  }
  ApplyBorderImage(false);
}

function ApplyBorderImage(aZeroWidths)
{
  var url = gDialog.borderImageURLTextbox.value;

  var leftOffset    = gDialog.leftEdgeSlicingTextbox.value;
  var rightOffset   = gDialog.rightEdgeSlicingTextbox.value;
  var topOffset     = gDialog.topEdgeSlicingTextbox.value;
  var bottomOffset = gDialog.bottomEdgeSlicingTextbox.value;

  function ZeroTextboxIfNeededed(id)
  {
    if (gDialog[id].value == "")
      gDialog[id].value = "0px";
  }
  if (aZeroWidths) {
    ZeroTextboxIfNeededed("borderSliceLeftWidthMenulist");
    ZeroTextboxIfNeededed("borderSliceRightWidthMenulist");
    ZeroTextboxIfNeededed("borderSliceTopWidthMenulist");
    ZeroTextboxIfNeededed("borderSliceBottomWidthMenulist");
  }
  var leftWidth   = gDialog.borderSliceLeftWidthMenulist.value;
  var rightWidth  = gDialog.borderSliceRightWidthMenulist.value;
  var topWidth    = gDialog.borderSliceTopWidthMenulist.value;
  var bottomWidth = gDialog.borderSliceBottomWidthMenulist.value;

  var repeatHoriz = gDialog.horizontalBorderImageRepeatMenulist.value;
  var repeatVert  = gDialog.VerticalBorderImageRepeatMenulist.value;

  str = "url('" + url + "') " +
        topOffset + " " + rightOffset + " " + bottomOffset + " " + leftOffset +
        (topWidth ? " / " + topWidth + " " + rightWidth + " " + bottomWidth + " " + leftWidth : "") +
        " " + gDialog.horizontalBorderImageRepeatMenulist.value + " " +
        gDialog.VerticalBorderImageRepeatMenulist.value;
  ApplyStyles( [
                 {
                  property: "-moz-border-image",
                  value: str
                 }
               ]);
}

RegisterIniter(ShadowsSectionIniter);

function ShadowsSectionIniter(aElt, aRuleset)
{
  deleteAllChildren(gDialog.textShadowRichlistbox);
  var ts = CssInspector.getCascadedValue(aRuleset, "text-shadow");
  var shadows = CssInspector.parseTextShadows(ts);
  for (var i = 0; i < shadows.length; i++) {
    var s = shadows[i];
    var item = document.createElement("richlistitem");
    item.className = s.none ? "noneTextShadow" : "shadowTextShadow";
    gDialog.textShadowRichlistbox.appendChild(item);
    if (!s.none) {
      item.color = s.color;
      item.offsetX = s.offsetX;
      item.offsetY = s.offsetY;
      item.blurRadius = s.blurRadius;
    }
  }

  deleteAllChildren(gDialog.boxShadowRichlistbox);
  var bs = CssInspector.getCascadedValue(aRuleset, "box-shadow");
  var shadows = CssInspector.parseBoxShadows(bs);
  for (var i = 0; i < shadows.length; i++) {
    var s = shadows[i];
    var item = document.createElement("richlistitem");
    item.className = s.none ? "noneBoxShadow" : "shadowBoxShadow";
    gDialog.boxShadowRichlistbox.appendChild(item);
    if (!s.none) {
      item.inset = s.inset;
      item.color = s.color;
      item.offsetX = s.offsetX;
      item.offsetY = s.offsetY;
      item.blurRadius = s.blurRadius;
      item.spreadRadius = s.spreadRadius;
    }
  }
  UpdateBoxShadowUI();
  UpdateTextShadowUI();
}

function OnTextShadowSelect(aElt)
{
  var item = aElt.selectedItem;
  SetEnabledElement(gDialog.removeTextShadowButton, (item != null));    
}

function AddTextShadow(aEvent)
{
  var type = aEvent.originalTarget.value;
  var item = document.createElement("richlistitem");
  item.className = type + "TextShadow";
  gDialog.textShadowRichlistbox.appendChild(item);
  UpdateTextShadowUI();
  if (type == "none")
    ReapplyTextShadows();
}

function DeleteTextShadow()
{
  var item = gDialog.textShadowRichlistbox.selectedItem;
  if (!item) return; // sanity check
  item.parentNode.removeChild(item);
  UpdateTextShadowUI();
  ReapplyTextShadows();
}

function ReapplyTextShadows()
{
  var items = gDialog.textShadowRichlistbox.querySelectorAll("richlistitem");
  var shadows = [];
  for (var i = 0; i < items.length; i++) {
    var item = items[i];
    var s;
    if (item.className == "shadowTextShadow") {
      if (item.offsetX != "" && item.offsetY != "") {
        var r = new RegExp( "([+-]?[0-9]*\\.[0-9]+|[+-]?[0-9]+)(" + '% px pt cm in mm pc em ex rem ch'.replace( / /g, "|") + ")*", "");
        var mX = item.offsetX.match(r);
        var mY = item.offsetY.match(r);
        if (!mX || !mY || !mX[2] || !mY[2])
          return;
      }
      else
        return;
      s = item.color + " " + item.offsetX + " " + item.offsetY + " " + item.blurRadius;
    }
    else
      s = "none";
    shadows.push(s);
  }
  ApplyStyles([{
                 property: "text-shadow",
                 value: shadows.join(",")
               }])
}

function UpdateTextShadowUI()
{
  var isEmpty = (gDialog.textShadowRichlistbox.itemCount == 0);
  var isNone = !isEmpty &&
                    (gDialog.textShadowRichlistbox.getItemAtIndex(0).className == "noneTextShadow");
  SetEnabledElement(gDialog.addTextShadowButton, !isNone);
  SetEnabledElement(gDialog.removeTextShadowButton, false);
  
  SetEnabledElement(gDialog.shadowTextShadowMenuitem, isEmpty || !isNone);
  SetEnabledElement(gDialog.noneTextShadowMenuitem, isEmpty);
}

function OnBoxShadowSelect(aElt)
{
  var item = aElt.selectedItem;
  SetEnabledElement(gDialog.removeBoxShadowButton, (item != null));    
}

function AddBoxShadow(aEvent)
{
  var type = aEvent.originalTarget.value;
  var item = document.createElement("richlistitem");
  item.className = type + "BoxShadow";
  gDialog.boxShadowRichlistbox.appendChild(item);
  UpdateBoxShadowUI();
  if (type == "none")
    ReapplyBoxShadows();
}

function DeleteBoxShadow()
{
  var item = gDialog.boxShadowRichlistbox.selectedItem;
  if (!item) return; // sanity check
  item.parentNode.removeChild(item);
  UpdateBoxShadowUI();
  ReapplyBoxShadows();
}

function ReapplyBoxShadows()
{
  var items = gDialog.boxShadowRichlistbox.querySelectorAll("richlistitem");
  var shadows = [];
  for (var i = 0; i < items.length; i++) {
    var item = items[i];
    var s;
    if (item.className == "shadowBoxShadow") {
      if (item.offsetX != "" && item.offsetY != "") {
        var r = new RegExp( "([+-]?[0-9]*\\.[0-9]+|[+-]?[0-9]+)(" + '% px pt cm in mm pc em ex rem ch'.replace( / /g, "|") + ")*", "");
        var mX = item.offsetX.match(r);
        var mY = item.offsetY.match(r);
        if (!mX || !mY || !mX[2] || !mY[2])
          return;
      }
      else
        return;
      s = (item.inset ? "inset " : "");
      s += item.offsetX + " " + item.offsetY + " " + item.blurRadius + " " +
           item.spreadRadius + " " + item.color;
    }
    else
     s = "none";
    shadows.push(s);
  }
  ApplyStyles([{
                 property: "box-shadow",
                 value: shadows.join(",")
               }])
}

function UpdateBoxShadowUI()
{
  var isEmpty = (gDialog.boxShadowRichlistbox.itemCount == 0);
  var isNone = !isEmpty &&
                    (gDialog.boxShadowRichlistbox.getItemAtIndex(0).className == "noneBoxShadow");
  SetEnabledElement(gDialog.addBoxShadowButton, !isNone);
  SetEnabledElement(gDialog.removeBoxShadowButton, false);
  
  SetEnabledElement(gDialog.shadowBoxShadowMenuitem, isEmpty || !isNone);
  SetEnabledElement(gDialog.noneBoxShadowMenuitem, isEmpty);
}
RegisterIniter(ListsSectionIniter);

function ListsSectionIniter(aElt, aRuleset)
{
  var lst = CssInspector.getCascadedValue(aRuleset, "list-style-type");
  gDialog.listStyleTypeMenulist.value = lst;

  var lsp = CssInspector.getCascadedValue(aRuleset, "list-style-position");
  CheckToggle(gDialog.insideListStylePositionButton,    lsp == "inside");
  CheckToggle(gDialog.outsideListStylePositionButton,   lsp == "outside");

  var lsi = CssInspector.getCascadedValue(aRuleset, "list-style-image");
  gDialog.listStyleImageURLTextbox.value = lsi;
}

function LoadListStyleImage()
{
  ApplyStyles( [
                 {
                   property: "list-style-image",
                   value: 'url("' + gDialog.listStyleImageURLTextbox.value + '")'
                 }
               ]);
}
RegisterIniter(TransformsSectionIniter);

function TransformsSectionIniter(aElt, aRuleset)
{
  var mto = CssInspector.getCascadedValue(aRuleset, "-moz-transform-origin");
  var mtoArray = mto.split(" ");
  switch (mtoArray.length) {
    case 1:
      gDialog.transformOriginXMenulist.value = mtoArray[0];
      gDialog.transformOriginYMenulist.value = "";
      break;
    case 2:
      gDialog.transformOriginXMenulist.value = mtoArray[0];
      gDialog.transformOriginYMenulist.value = mtoArray[1];
      break;
    case 3:
      gDialog.transformOriginXMenulist.value = mtoArray[0];
      gDialog.transformOriginYMenulist.value = mtoArray[1];
      gDialog.transformOriginZMenulist.value = mtoArray[2];
      break;
    default:
      gDialog.transformOriginXMenulist.value = "";
      gDialog.transformOriginYMenulist.value = "";
      gDialog.transformOriginZMenulist.value = "";
      break;
  }

  var mpo = CssInspector.getCascadedValue(aRuleset, "-moz-perspective-origin");
  var mpoArray = mto.split(" ");
  switch (mpoArray.length) {
    case 1:
      gDialog.perspectiveOriginXMenulist.value = mpoArray[0];
      gDialog.perspectiveOriginYMenulist.value = "";
      break;
    case 2:
      gDialog.perspectiveOriginXMenulist.value = mpoArray[0];
      gDialog.perspectiveOriginYMenulist.value = mpoArray[1];
      break;
    default:
      gDialog.perspectiveOriginXMenulist.value = "";
      gDialog.perspectiveOriginYMenulist.value = "";
      break;
  }

  var mts = CssInspector.getCascadedValue(aRuleset, "-moz-transform-style");
  CheckToggle(gDialog.transformStyleFlatButton, mts == "flat");
  CheckToggle(gDialog.transformStyle3DButton,   mts == "preserve-3d");

  var mbv = CssInspector.getCascadedValue(aRuleset, "-moz-backface-visibility");
  CheckToggle(gDialog.backfaceVisibilityVisibleButton, mbv == "visible");
  CheckToggle(gDialog.backfaceVisibilityHiddenButton,  mbv == "hidden");

  deleteAllChildren(gDialog.transformsRichlistbox);
  var mt = CssInspector.getCascadedValue(aRuleset, "-moz-transform");
  var transformsArray = [];
  if (mt) {
   var mtArray = mt.split(")");
   for (var i = 0; i < mtArray.length; i++) {
    var transformation = mtArray[i].trim();
    var parsed = transformation.match(/([a-z0-9]*)\((.*)/i);
    if (parsed) {
      var t = parsed[1];
      var values = parsed[2];
      var valuesArray = values.split(",");
      valuesArray = valuesArray.map(function(s){return s.trim();})
      transformsArray.push( {
                              transformation: t,
                              values: valuesArray
                            });
    }
   }
  }

  for (var i = 0; i < transformsArray.length; i++) {
    var t = transformsArray[i];
    var item = document.createElement("richlistitem");
    switch (t.transformation.toLowerCase()) {
      case "perspective":
        item.className = "perspectiveTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.depth = t.values[0];
        break;
      case "rotate":
        item.className = "rotateTransform";
        if (i >= gDialog.transformsRichlistbox.itemCount)
          gDialog.transformsRichlistbox.appendChild(item);
        else if (gDialog.transformsRichlistbox.getItemAtIndex(i).className != "rotateTransform")
          gDialog.transformsRichlistbox.replaceChild(gDialog.transformsRichlistbox.getItemAtIndex(i), item);
        else
          item = gDialog.transformsRichlistbox.getItemAtIndex(i);
        item.value = parseFloat(t.values[0]);
        break;
      case "translate":
        item.className = "translate3dTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.horizontally = t.values[0];
        if (t.values.length > 1)
          item.vertically = t.values[1];
        else
          item.vertically = "";
        item.zindexally = "";
        break;
      case "translate3d":
        item.className = "translate3dTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.horizontally = t.values[0];
        item.vertically = t.values[1];
        item.zindexally = t.values[2];
        break;
      case "translatex":
        item.className = "translate3dTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.horizontally = t.values[0];
        item.vertically = "";
        item.zindexally = "";
        break;
      case "translatey":
        item.className = "translate3dTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.horizontally = "";
        item.vertically = t.values[0];
        item.zindexally = "";
        break;
      case "translatez":
        item.className = "translate3dTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.horizontally = "";
        item.vertically = "";
        item.zindexally = t.values[0];
        break;
      case "skew":
        item.className = "skewTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.valueX = parseFloat(t.values[0]);
        item.valueY = parseFloat(t.values[1]);
        break;
      case "skewx":
        item.className = "skewTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.valueX = parseFloat(t.values[0]);
        item.valueY = "";
        break;
      case "skewy":
        item.className = "skewTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.valueX = "";
        item.valueY = parseFloat(t.values[0]);
        break;
      case "scale":
        item.className = "scale3dTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.horizontally = parseFloat(t.values[0]);
        if (t.values.length > 1)
          item.vertically = parseFloat(t.values[1]);
        else
          item.vertically = item.horizontally;
        item.zindexally = "";
        break;
      case "scalex":
        item.className = "scale3dTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.horizontally = parseFloat(t.values[0]);
        item.vertically = "";
        item.zindexally = "";
        break;
      case "scaley":
        item.className = "scale3dTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.horizontally = "";
        item.vertically = parseFloat(t.values[0]);
        item.zindexally = "";
        break;
      case "scalez":
        item.className = "scale3dTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.horizontally = "";
        item.vertically = "";
        item.zindexally = parseFloat(t.values[0]);
        break;
      case "scale3d":
        item.className = "scale3dTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.horizontally = parseFloat(t.values[0]);
        item.vertically   = parseFloat(t.values[1]);
        item.zindexally   = parseFloat(t.values[2]);
        break;
      case "rotatex":
        item.className = "rotate3dTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.setValues(1, 0, 0);
        item.angle = parseFloat(t.values[0]);
        break;
      case "rotatey":
        item.className = "rotate3dTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.setValues(0, 1, 0);
        item.angle = parseFloat(t.values[0]);
        break;
      case "rotatez":
        item.className = "rotate3dTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.setValues(0, 0, 1);
        item.angle = parseFloat(t.values[0]);
        break;
      case "rotate3d":
        item.className = "rotate3dTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.setValues(parseFloat(t.values[0]), parseFloat(t.values[1]), parseFloat(t.values[2]));
        item.angle = parseFloat(t.values[3]);
        break;
      default: break;
    }
  }
}

function OnTransformSelect(aElt)
{
  var item = aElt.selectedItem;
  SetEnabledElement(gDialog.removeTransformButton, (item != null));    
}

function AddTransform(aEvent)
{
  var type = aEvent.originalTarget.value;
  var item = document.createElement("richlistitem");
  item.className = type + "Transform";
  gDialog.transformsRichlistbox.appendChild(item);
}

function DeleteTransform()
{
  var item = gDialog.transformsRichlistbox.selectedItem;
  if (!item) return; // sanity check
  item.parentNode.removeChild(item);
  SetEnabledElement(gDialog.removeTransformButton, (gDialog.transformsRichlistbox.itemCount != 0));
  ReapplyTransforms();
}

function ReapplyTransforms()
{
  var items = gDialog.transformsRichlistbox.querySelectorAll("richlistitem");
  var transforms = [];
  var r = new RegExp( "([+-]?[0-9]*\\.[0-9]+|[+-]?[0-9]+)(" + '% px pt cm in mm pc em ex rem ch'.replace( / /g, "|") + ")*", "");
  var r2 = new RegExp( "([+-]?[0-9]*\\.[0-9]+|[+-]?[0-9]+)(" + 'px pt cm in mm pc em ex rem ch'.replace( / /g, "|") + ")*", "");
  for (var i = 0; i < items.length; i++) {
    var item = items[i];
    switch (item.className) {
      case "rotateTransform":
        transforms.push( "rotate(" + item.value + "deg)");
        break;
      case "translate3dTransform":
        {
          var h = (item.horizontally != "") ? item.horizontally : "0px";
          var v = (item.vertically != "") ? item.vertically : "0px";
          var z = (item.zindexally != "") ? item.zindexally : "0px";
          var mH, mV, mZ;
          if (h) {
            mH = h.match(r);
            if (!mH || !mH[2])
              return;
          }
          if (v) {
            mV = v.match(r);
            if (!mV || !mV[2])
              return;
          }
          if (z) {
            mZ = z.match(r2);
            if (!mZ || !mZ[2])
              return;
          }
          if (mV[1] == "0" && mZ[1] == "0")
            transforms.push("translateX(" + h + ")");
          else if (mH[1] == "0" && mZ[1] == "0")
            transforms.push("translateY(" + v + ")");
          else if (mH[1] == "0" && mV[1] == "0")
            transforms.push("translateZ(" + z + ")");
          else if (mZ[1] == "0")
            transforms.push("translate(" + h + ", " + v + ")");
          else
            transforms.push("translate3d(" + h + ", " + v + ", " + z + ")");
        }
        break;
      case "skewTransform":
        {
          var x = item.valueX;
          var y = item.valueY;
          if (!x && !y)
            return;
          if (x && y && parseFloat(x) && parseFloat(y))
            transforms.push("skew(" + x + "deg, " + y + "deg)");
          else if (x && parseFloat(x))
            transforms.push("skewX(" + x + "deg)");
          else if (y && parseFloat(y))
            transforms.push("skewY(" + y + "deg)");
        }
        break;
      case "scale3dTransform":
        {
          var h = item.horizontally;
          var v = item.vertically;
          var z = item.zindexally;
          if (!h && !v && !z)
            return;
          if (h && v && z && parseFloat(h) && parseFloat(v) && parseFloat(z)) {
            transforms.push("scale3d(" + h + ", " + v + ", " + z + ")");
            h = ""; v = ""; z = "";
          }
          if (h && v && (h == v) && parseFloat(h)) {
            transforms.push("scale(" + h +  ")");
            h = ""; v = "";
          }
          if (h && v && parseFloat(h) && parseFloat(v)) {
            transforms.push("scale(" + h + ", " + v + ")");
            h = ""; v = "";
          }
          if (h && parseFloat(h)) {
            transforms.push("scaleX(" + h + ")");
          }
          if (v && parseFloat(v)) {
            transforms.push("scaleY(" + v + ")");
          }
          if (z && parseFloat(z)) {
            transforms.push("scaleZ(" + z + ")");
          }
        }
        break;
      case "perspectiveTransform":
        {
          var depth = item.depth;
          if (depth) {
            mDepth = depth.match(r2);
            if (!mDepth || !mDepth[2] ||!parseFloat(mDepth[1]))
              return;
            transforms.push("perspective(" + depth + ")");
          }
        }
        break;
      case "rotate3dTransform":
        {
          var x = item.getChild("Xvalue").value;
          var y = item.getChild("Yvalue").value;
          var z = item.getChild("Zvalue").value;
          if (x != ""
              && y != "" 
              && z != "") {
            var x = parseFloat(x);
            var y = parseFloat(y);
            var z = parseFloat(z);
            if (x || y || z) {
              // normalize
              x = x / Math.sqrt(x*x + y*y +z*z);
              y = y / Math.sqrt(x*x + y*y +z*z);
              z = z / Math.sqrt(x*x + y*y +z*z);
              var angle = parseFloat(item.angle);
              if (!x && !y)
                transforms.push( "rotateZ(" + (( z > 0 ) ? angle : -angle) + "deg)");
              else if (!x && !z)
                transforms.push( "rotateY(" + (( y > 0 ) ? angle : -angle) + "deg)");
              else if (!z && !y)
                transforms.push( "rotateX(" + (( x > 0 ) ? angle : -angle) + "deg)");
              else
                transforms.push( "rotate3d("
                                 + x + ", "
                                 + y + ", "
                                 + z + ", "
                                 + angle + "deg)");
            }
          }
        }
        break;
      default: break;
    }
  }
  ApplyStyles([
                {
                  property: "-moz-transform",
                  value: transforms.join(" ")
                },
                {
                  property: "-moz-perspective",
                  value: gDialog.perspectiveMenulist.value
                },
                {
                  property: "-moz-transform-origin",
                  value: (gDialog.transformOriginXMenulist.value
                          + " "
                          + gDialog.transformOriginYMenulist.value
                          + " "
                          + gDialog.transformOriginZMenulist.value).trim()
                },
                {
                  property: "-moz-perspective-origin",
                  value: (gDialog.perspectiveOriginXMenulist.value
                          + " "
                          + gDialog.perspectiveOriginYMenulist.value).trim()
                }
              ]);
}




RegisterIniter(TransitionsSectionIniter);

function TransitionsSectionIniter(aElt, aRuleset)
{
  deleteAllChildren(gDialog.transitionsRichlistbox);
  var mtp = CssInspector.getCascadedValue(aRuleset, "-moz-transition-property");
  var mtpArray = [];
  if (mtp) {
    mtpArray = mtp.split(",");
    for (var i = 0; i < mtpArray.length; i++) {
      var item = document.createElement("richlistitem");
      var v = mtpArray[i].trim();
      switch (v) {
        case "all":
        case "none":
          item.className = v + "Transition";
          gDialog.transitionsRichlistbox.appendChild(item)
          break;
        default:
          item.className = "propertyTransition";
          gDialog.transitionsRichlistbox.appendChild(item);
          item.propertyValue = v;
          break;
      }
    }
  }
  var mtde = CssInspector.getCascadedValue(aRuleset, "-moz-transition-delay") || "0s";
  var mtdeArray = mtde.split(",");
  while (mtdeArray.length < mtpArray.length)
    mtdeArray = mtdeArray.concat(mtdeArray);
  for (var i = 0 ; i < mtpArray.length; i++) {
    var item = gDialog.transitionsRichlistbox.getItemAtIndex(i);
    item.delayValue = parseFloat(mtdeArray[i]);
  }

  var mtdu = CssInspector.getCascadedValue(aRuleset, "-moz-transition-duration") || "0s";
  var mtduArray = mtdu.split(",");
  while (mtduArray.length < mtpArray.length)
    mtduArray = mtduArray.concat(mtduArray);
  for (var i = 0 ; i < mtpArray.length; i++) {
    var item = gDialog.transitionsRichlistbox.getItemAtIndex(i);
    item.durationValue = parseFloat(mtduArray[i]);
  }

  var mttf = CssInspector.getCascadedValue(aRuleset, "-moz-transition-timing-function") || "ease";
  var mttfArray = mttf.match( /linear|ease-in-out|ease-in|ease-out|ease|cubic-bezier\([^\)]*\)/g ) || [];
  while (mttfArray.length < mtpArray.length)
    mttfArray = mttfArray.concat(mttfArray);
  for (var i = 0 ; i < mtpArray.length; i++) {
    var item = gDialog.transitionsRichlistbox.getItemAtIndex(i);
    item.functionValue = mttfArray[i];
  }

  if (!(aElt instanceof Components.interfaces.nsIDOMCSSStyleSheet) ||
      (aElt.parentStyleSheet &&
       (!aElt.parentStyleSheet.href ||
        aElt.parentStyleSheet.href.substr(0, 7) == "file://")))
    UpdateTransitionUI();
}

function OnTransitionSelect(aElt)
{
  var item = aElt.selectedItem;
  SetEnabledElement(gDialog.removeTransitionButton, (item != null));    
}

function AddTransition(aEvent)
{
  var type = aEvent.originalTarget.value;
  var item = document.createElement("richlistitem");
  item.className = type + "Transition";
  gDialog.transitionsRichlistbox.appendChild(item);
  UpdateTransitionUI();
  if (type != "property")
    ReapplyTransitions();
}

function DeleteTransition()
{
  var item = gDialog.transitionsRichlistbox.selectedItem;
  if (!item) return; // sanity check
  item.parentNode.removeChild(item);
  UpdateTransitionUI();
  ReapplyTransitions();
}

function ReapplyTransitions()
{
  var items = gDialog.transitionsRichlistbox.querySelectorAll("richlistitem");
  var properties = [];
  var durations  = [];
  var functions  = [];
  var delays     = [];
  for (var i = 0; i < items.length; i++) {
    var item = items[i];
    if (item.propertyValue) {
      properties.push( item.propertyValue );
      durations.push( item.durationValue + "s" );
      functions.push( item.functionValue );
      delays.push( item.delayValue + "s");
    }
    else
      return;
  }
  ApplyStyles( [
                 {
                   property: "-moz-transition-property",
                   value: properties.join(", ")
                 },
                 {
                   property: "-moz-transition-duration",
                   value: durations.join(", ")
                 },
                 {
                   property: "-moz-transition-timing-function",
                   value: functions.join(", ")
                 },
                 {
                   property: "-moz-transition-delay",
                   value: delays.join(", ")
                 }
               ] );
}

function UpdateTransitionUI()
{
  var isEmpty = (gDialog.transitionsRichlistbox.itemCount == 0);
  var isNoneOrAll = !isEmpty &&
                    (gDialog.transitionsRichlistbox.getItemAtIndex(0).className == "noneTransition" ||
                     gDialog.transitionsRichlistbox.getItemAtIndex(0).className == "allTransition");
  SetEnabledElement(gDialog.addTransitionButton, !isNoneOrAll);
  SetEnabledElement(gDialog.removeTransitionButton, false);
  
  SetEnabledElement(gDialog.onePropertyTransitionMenuitem, isEmpty || !isNoneOrAll);
  SetEnabledElement(gDialog.noneTransitionMenuitem, isEmpty);
  SetEnabledElement(gDialog.allTransitionMenuitem, isEmpty);
}

function OpenPanelIfBezier(e)
{
  var v = e.value.trim();
  gDialog.bezierPanel.openPopupAtScreen(e.boxObject.screenX,
                                        e.boxObject.screenY,
                                        false);
  Bezier.initWithBezier(v, e);
  setTimeout(function() {
    gDialog.p1_x.focus(); }, 100);
}
RegisterIniter(FlexBoxSectionIniter);

function FlexBoxSectionIniter(aElt, aRuleset)
{
  var d = CssInspector.getCascadedValue(aRuleset, "display");
  gDialog.flexBoxEnabledCheckbox.checked = (d == "-moz-box" || d == "-moz-inline-box");
  gDialog.inlineBoxCheckbox.disabled = !gDialog.flexBoxEnabledCheckbox.checked;
  gDialog.inlineBoxCheckbox.checked = (d == "-moz-inline-box");

  var ba = CssInspector.getCascadedValue(aRuleset, "-moz-box-align");
  CheckToggle(gDialog.startBoxAlignButton,    ba == "start");
  CheckToggle(gDialog.centerBoxAlignButton,   ba == "center");
  CheckToggle(gDialog.endBoxAlignButton,      ba == "end");
  CheckToggle(gDialog.baselineBoxAlignButton, ba == "baseline");
  CheckToggle(gDialog.stretchBoxAlignButton,  ba == "stretch");

  var bd = CssInspector.getCascadedValue(aRuleset, "-moz-box-direction");
  CheckToggle(gDialog.normalBoxDirectionButton,    bd == "normal");
  CheckToggle(gDialog.reverseBoxDirectionButton,   bd == "reverse");

  var bf = CssInspector.getCascadedValue(aRuleset, "-moz-box-flex");
  gDialog.boxFlexTextbox.value = bf;

  var bo = CssInspector.getCascadedValue(aRuleset, "-moz-box-orient");
  CheckToggle(gDialog.horizontalBoxOrientButton,   bo == "horizontal");
  CheckToggle(gDialog.verticalBoxOrientButton,     bo == "vertical");

  var bog = CssInspector.getCascadedValue(aRuleset, "-moz-box-ordinal-group");
  gDialog.boxOrdinalGroupTextbox.value = bog;

  var bp = CssInspector.getCascadedValue(aRuleset, "-moz-box-pack");
  CheckToggle(gDialog.startBoxPackButton,    bp == "start");
  CheckToggle(gDialog.centerBoxPackButton,   bp == "center");
  CheckToggle(gDialog.endBoxPackButton,      bp == "end");
  CheckToggle(gDialog.justifyBoxPackButton,  bp == "justify");
}

function ToggleFlexBox()
{
  gDialog.inlineBoxCheckbox.disabled = !gDialog.flexBoxEnabledCheckbox.checked;
  ApplyStyles( [
                 {
                   property: "display",
                   value: gDialog.flexBoxEnabledCheckbox.checked ?
                          (gDialog.inlineBoxCheckbox.checked ? "-moz-inline-box" : "-moz-box") :
                          ""
                 }
               ]);
}
RegisterIniter(ColumnsSectionIniter);

function ColumnsSectionIniter(aElt, aRuleset)
{
  var cc = CssInspector.getCascadedValue(aRuleset, "-moz-column-count");
  if (cc == "auto")
    cc = "1";
  gDialog.columnCount.value = cc;

  var cw = CssInspector.getCascadedValue(aRuleset, "-moz-column-width");
  gDialog.columnWidthMenulist.value = cw;

  var cg = CssInspector.getCascadedValue(aRuleset, "-moz-column-gap");
  gDialog.columnGapMenulist.value = cg;

  var crc = CssInspector.getCascadedValue(aRuleset, "-moz-column-rule-color");
  gDialog.columnRuleColorpicker.color = crc;
  var crs = CssInspector.getCascadedValue(aRuleset, "-moz-column-rule-style");
  gDialog.columnRuleStyleMenulist.value = crs;
  var crw = CssInspector.getCascadedValue(aRuleset, "-moz-column-rule-width");
  gDialog.columnRuleWidthMenulist.value = crw;
}

function SetColumnCount(aN)
{
  gDialog.columnCount.value = aN;
  ColumnCountChanged();
}

function ColumnCountChanged()
{
  var count = gDialog.columnCount.value;
  if (count == "1")
    count = "";

  ApplyStyles([
                {
                  property: "-moz-column-count",
                  value: count
                }
              ]);
}

RegisterIniter(TablesSectionIniter);

function TablesSectionIniter(aElt, aRuleset)
{
  var c = CssInspector.getCascadedValue(aRuleset, "table-layout");
  CheckToggle(gDialog.autoTableLayoutButton, c == "auto");
  CheckToggle(gDialog.fixedTableLayoutButton, c == "fixed");

  var bc = CssInspector.getCascadedValue(aRuleset, "border-collapse");
  CheckToggle(gDialog.collapseBorderCollapseButton, bc == "collapse");
  CheckToggle(gDialog.separateBorderCollapseButton, bc == "separate");

  var bs = CssInspector.getCascadedValue(aRuleset, "border-spacing");
  if (bs) {
    var bsArray = bs.split(" ");
    gDialog.borderSpacingHMenulist.value = bsArray[0];
    if (bsArray.length == 2)
      gDialog.borderSpacingVMenulist.value = bsArray[1];
    else
      gDialog.borderSpacingVMenulist.value = "";
  }
  else {
    gDialog.borderSpacingHMenulist.value = "";
    gDialog.borderSpacingVMenulist.value = "";
  }

  var ec = CssInspector.getCascadedValue(aRuleset, "empty-cells");
  CheckToggle(gDialog.showEmptyCellsButton, ec == "show");
  CheckToggle(gDialog.hideEmptyCellsButton, ec == "hide");
}

function ApplyBorderSpacing()
{
  var h = gDialog.borderSpacingHMenulist.value;
  var v = gDialog.borderSpacingVMenulist.value;
  ApplyStyles( [ {
                   property: "border-spacing",
                   value: h + " " + v
                 }])
}
RegisterIniter(MiscSectionIniter);

function MiscSectionIniter(aElt, aRuleset)
{
  var c = CssInspector.getCascadedValue(aRuleset, "cursor");
  gDialog.cursorMenulist.value = c;

  var ub = CssInspector.getCascadedValue(aRuleset, "unicode-bidi");
  CheckToggle(gDialog.normalUnicodeBidiButton,       ub == "normal");
  CheckToggle(gDialog.embedUnicodeBidiButton,        ub == "embed");
  CheckToggle(gDialog.bidiOverrideUnicodeBidiButton, ub == "bidi-override");

  var w = CssInspector.getCascadedValue(aRuleset, "widows");
  gDialog.widowsTextbox.value = w;

  var o = CssInspector.getCascadedValue(aRuleset, "orphans");
  gDialog.orphansTextbox.value = o;

  var pbb = CssInspector.getCascadedValue(aRuleset, "page-break-before");
  gDialog.pageBreakBeforeMenulist.value = pbb;

  var pbi = CssInspector.getCascadedValue(aRuleset, "page-break-inside");
  gDialog.pageBreakInsideMenulist.value = pbi;

  var pba = CssInspector.getCascadedValue(aRuleset, "page-break-after");
  gDialog.pageBreakAfterMenulist.value = pba;
}
//@line 970 "c:\trees\official1.4\bluegriffon\sidebars\cssproperties\content\cssproperties.js"

function ToggleHover(aElt)
{
  if (aElt.checked && gDialog.cssPolicyMenulist.value == "inline")
    gDialog.cssPolicyMenulist.value = "id";
  var node = gCurrentElement;
  SelectionChanged(null, node, null);
}
