/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");
XPCOMUtils.defineLazyModuleGetter(this, "Services", "resource://gre/modules/Services.jsm");

this.EXPORTED_SYMBOLS = ["AppConstants"];

// Immutable for export.
this.AppConstants = Object.freeze({
  // See this wiki page for more details about channel specific build
  // defines: https://wiki.mozilla.org/Platform/Channel-specific_build_defines
  NIGHTLY_BUILD:
//@line 20 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  true,
//@line 24 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  RELEASE_BUILD:
//@line 29 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 31 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  ACCESSIBILITY:
//@line 34 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  true,
//@line 38 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  // Official corresponds, roughly, to whether this build is performed
  // on Mozilla's continuous integration infrastructure. You should
  // disable developer-only functionality when this flag is set.
  MOZILLA_OFFICIAL:
//@line 46 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 48 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_OFFICIAL_BRANDING:
//@line 53 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 55 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_DEV_EDITION:
//@line 60 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 62 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_HEALTHREPORT:
//@line 67 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 69 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_DATA_REPORTING:
//@line 74 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 76 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_SAFE_BROWSING:
//@line 81 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 83 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_SANDBOX:
//@line 86 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  true,
//@line 90 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_REPORTING:
//@line 95 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 97 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_ON_BY_DEFAULT:
//@line 102 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 104 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_CLOUDSYNC:
//@line 109 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 111 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_UPDATER:
//@line 116 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 118 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_SWITCHBOARD:
//@line 123 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 125 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_WEBRTC:
//@line 130 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 132 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

//@line 134 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  MOZ_B2G:
//@line 138 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 140 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  XP_UNIX:
//@line 143 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  true,
//@line 147 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

//@line 150 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  platform:
//@line 152 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  "linux",
//@line 168 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  isPlatformAndVersionAtLeast(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) >= 0;
  },

  isPlatformAndVersionAtMost(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) <= 0;
  },

  MOZ_CRASHREPORTER:
//@line 185 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 187 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_VERIFY_MAR_SIGNATURE:
//@line 192 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 194 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_MAINTENANCE_SERVICE:
//@line 199 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 201 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  E10S_TESTING_ONLY:
//@line 204 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  true,
//@line 208 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  DEBUG:
//@line 213 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 215 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_B2G_RIL:
//@line 220 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 222 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_B2GDROID:
//@line 227 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 229 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_GRAPHENE:
//@line 234 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 236 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_SYSTEM_NSS:
//@line 241 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 243 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_PLACES:
//@line 246 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  true,
//@line 250 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_REQUIRE_SIGNING:
//@line 255 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 257 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MENUBAR_CAN_AUTOHIDE:
//@line 260 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  true,
//@line 264 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  CAN_DRAW_IN_TITLEBAR:
//@line 269 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 271 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_ANDROID_HISTORY:
//@line 276 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 278 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  DLL_PREFIX: "lib",
  DLL_SUFFIX: ".so",

  MOZ_APP_NAME: "bluegriffon",
  MOZ_APP_VERSION: "2.1.2",
  MOZ_APP_VERSION_DISPLAY: "2.1.2",
  MOZ_BUILD_APP: "bluegriffon",
  MOZ_MACBUNDLE_NAME: "BlueGriffon.app",
  MOZ_UPDATE_CHANNEL: "default",
  INSTALL_LOCALE: "en-US",
  MOZ_WIDGET_TOOLKIT: "gtk2",
  ANDROID_PACKAGE_NAME: "org.mozilla.bluegriffon",
  MOZ_B2G_VERSION: "1.0.0",
  MOZ_B2G_OS_NAME: "",

  MOZ_ANDROID_APZ:
//@line 298 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
    false,
//@line 300 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  DEBUG_JS_MODULES: "",

  // URL to the hg revision this was built from (e.g.
  // "https://hg.mozilla.org/mozilla-central/rev/6256ec9113c1")
  // On unofficial builds, this is an empty string.
//@line 308 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  SOURCE_REVISION_URL: "",

  MOZ_NUWA_PROCESS:
//@line 314 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
    false
//@line 316 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
});
