/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");
XPCOMUtils.defineLazyModuleGetter(this, "Services", "resource://gre/modules/Services.jsm");

this.EXPORTED_SYMBOLS = ["AppConstants"];

// Immutable for export.
this.AppConstants = Object.freeze({
  // See this wiki page for more details about channel specific build
  // defines: https://wiki.mozilla.org/Platform/Channel-specific_build_defines
  NIGHTLY_BUILD:
//@line 20 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  true,
//@line 24 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  RELEASE_BUILD:
//@line 29 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 31 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  ACCESSIBILITY:
//@line 34 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  true,
//@line 38 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  // Official corresponds, roughly, to whether this build is performed
  // on Mozilla's continuous integration infrastructure. You should
  // disable developer-only functionality when this flag is set.
  MOZILLA_OFFICIAL:
//@line 46 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 48 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_OFFICIAL_BRANDING:
//@line 53 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 55 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_DEV_EDITION:
//@line 60 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 62 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_SERVICES_HEALTHREPORT:
//@line 67 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 69 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_DATA_REPORTING:
//@line 74 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 76 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_SAFE_BROWSING:
//@line 81 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 83 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_SANDBOX:
//@line 86 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  true,
//@line 90 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_TELEMETRY_REPORTING:
//@line 95 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 97 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_TELEMETRY_ON_BY_DEFAULT:
//@line 102 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 104 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_SERVICES_CLOUDSYNC:
//@line 109 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 111 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_UPDATER:
//@line 116 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 118 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_SWITCHBOARD:
//@line 123 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 125 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_WEBRTC:
//@line 130 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 132 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

//@line 134 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  MOZ_B2G:
//@line 138 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 140 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  XP_UNIX:
//@line 145 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 147 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

//@line 150 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  platform:
//@line 156 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  "win",
//@line 168 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  isPlatformAndVersionAtLeast(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) >= 0;
  },

  isPlatformAndVersionAtMost(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) <= 0;
  },

  MOZ_CRASHREPORTER:
//@line 185 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 187 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_VERIFY_MAR_SIGNATURE:
//@line 192 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 194 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_MAINTENANCE_SERVICE:
//@line 199 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 201 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  E10S_TESTING_ONLY:
//@line 204 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  true,
//@line 208 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  DEBUG:
//@line 213 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 215 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_B2G_RIL:
//@line 220 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 222 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_B2GDROID:
//@line 227 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 229 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_GRAPHENE:
//@line 234 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 236 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_SYSTEM_NSS:
//@line 241 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 243 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_PLACES:
//@line 246 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  true,
//@line 250 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_REQUIRE_SIGNING:
//@line 255 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 257 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MENUBAR_CAN_AUTOHIDE:
//@line 260 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  true,
//@line 264 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  CAN_DRAW_IN_TITLEBAR:
//@line 267 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  true,
//@line 271 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  MOZ_ANDROID_HISTORY:
//@line 276 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  false,
//@line 278 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"

  DLL_PREFIX: "",
  DLL_SUFFIX: ".dll",

  MOZ_APP_NAME: "bluegriffon",
  MOZ_APP_VERSION: "2.2",
  MOZ_APP_VERSION_DISPLAY: "2.2",
  MOZ_BUILD_APP: "bluegriffon",
  MOZ_MACBUNDLE_NAME: "BlueGriffon.app",
  MOZ_UPDATE_CHANNEL: "default",
  INSTALL_LOCALE: "en-US",
  MOZ_WIDGET_TOOLKIT: "windows",
  ANDROID_PACKAGE_NAME: "org.mozilla.bluegriffon",
  MOZ_B2G_VERSION: "1.0.0",
  MOZ_B2G_OS_NAME: "",

  MOZ_ANDROID_APZ:
//@line 298 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
    false,
//@line 300 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  DEBUG_JS_MODULES: "",

  // URL to the hg revision this was built from (e.g.
  // "https://hg.mozilla.org/mozilla-central/rev/6256ec9113c1")
  // On unofficial builds, this is an empty string.
//@line 308 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
  SOURCE_REVISION_URL: "",

  MOZ_NUWA_PROCESS:
//@line 314 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
    false
//@line 316 "c:\trees\bg22\toolkit\modules\AppConstants.jsm"
});
