/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");
XPCOMUtils.defineLazyModuleGetter(this, "Services", "resource://gre/modules/Services.jsm");

this.EXPORTED_SYMBOLS = ["AppConstants"];

// Immutable for export.
this.AppConstants = Object.freeze({
  // See this wiki page for more details about channel specific build
  // defines: https://wiki.mozilla.org/Platform/Channel-specific_build_defines
  NIGHTLY_BUILD:
//@line 20 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  true,
//@line 24 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  RELEASE_OR_BETA:
//@line 29 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 31 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  ACCESSIBILITY:
//@line 34 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  true,
//@line 38 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  // Official corresponds, roughly, to whether this build is performed
  // on Mozilla's continuous integration infrastructure. You should
  // disable developer-only functionality when this flag is set.
  MOZILLA_OFFICIAL:
//@line 46 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 48 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_OFFICIAL_BRANDING:
//@line 53 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 55 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_DEV_EDITION:
//@line 60 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 62 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_HEALTHREPORT:
//@line 67 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 69 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_DATA_REPORTING:
//@line 74 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 76 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_SANDBOX:
//@line 81 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 83 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_CONTENT_SANDBOX:
//@line 88 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 90 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_REPORTING:
//@line 95 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 97 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_ON_BY_DEFAULT:
//@line 102 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 104 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_CLOUDSYNC:
//@line 109 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 111 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_UPDATER:
//@line 116 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 118 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_SWITCHBOARD:
//@line 123 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 125 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_WEBRTC:
//@line 130 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 132 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_WIDGET_GTK:
//@line 135 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  true,
//@line 139 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

//@line 141 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  MOZ_B2G:
//@line 145 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 147 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  XP_UNIX:
//@line 150 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  true,
//@line 154 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

//@line 157 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  platform:
//@line 159 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  "linux",
//@line 173 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  isPlatformAndVersionAtLeast(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) >= 0;
  },

  isPlatformAndVersionAtMost(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) <= 0;
  },

  MOZ_CRASHREPORTER:
//@line 190 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 192 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_VERIFY_MAR_SIGNATURE:
//@line 197 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 199 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_MAINTENANCE_SERVICE:
//@line 204 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 206 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  E10S_TESTING_ONLY:
//@line 209 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  true,
//@line 213 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  DEBUG:
//@line 218 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 220 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  ASAN:
//@line 225 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 227 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_B2G_RIL:
//@line 232 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 234 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_GRAPHENE:
//@line 239 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 241 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_SYSTEM_NSS:
//@line 246 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 248 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_PLACES:
//@line 253 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 255 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_REQUIRE_SIGNING:
//@line 260 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 262 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  INSTALL_COMPACT_THEMES:
//@line 265 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  true,
//@line 269 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MENUBAR_CAN_AUTOHIDE:
//@line 272 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  true,
//@line 276 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  CAN_DRAW_IN_TITLEBAR:
//@line 281 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 283 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_ANDROID_HISTORY:
//@line 288 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 290 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_TOOLKIT_SEARCH:
//@line 293 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  true,
//@line 297 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_GECKO_PROFILER:
//@line 300 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  true,
//@line 304 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  MOZ_ANDROID_ACTIVITY_STREAM:
//@line 309 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  false,
//@line 311 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  DLL_PREFIX: "lib",
  DLL_SUFFIX: ".so",

  MOZ_APP_NAME: "bluegriffon",
  MOZ_APP_VERSION: "3.0",
  MOZ_APP_VERSION_DISPLAY: "3.0",
  MOZ_BUILD_APP: "bluegriffon",
  MOZ_MACBUNDLE_NAME: "BlueGriffon.app",
  MOZ_UPDATE_CHANNEL: "default",
  INSTALL_LOCALE: "en-US",
  MOZ_WIDGET_TOOLKIT: "gtk3",
  ANDROID_PACKAGE_NAME: "org.mozilla.bluegriffon",
  MOZ_B2G_VERSION: "1.0.0",
  MOZ_B2G_OS_NAME: "",

  DEBUG_JS_MODULES: "",

  // URL to the hg revision this was built from (e.g.
  // "https://hg.mozilla.org/mozilla-central/rev/6256ec9113c1")
  // On unofficial builds, this is an empty string.
//@line 335 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
  SOURCE_REVISION_URL: "",

  HAVE_USR_LIB64_DIR:
//@line 341 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
    false,
//@line 343 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"

  HAVE_SHELL_SERVICE:
//@line 346 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
    true,
//@line 350 "/home/glazou/trees/trunk/toolkit/modules/AppConstants.jsm"
});
