Components.utils.import("resource://gre/modules/editorHelper.jsm");
Components.utils.import("resource://gre/modules/cssHelper.jsm");
Components.utils.import("resource://gre/modules/cssInspector.jsm");
Components.utils.import("resource://gre/modules/prompterHelper.jsm");

var gMain = null;
var gCurrentElement = null;
var gInUtils;
//@line 15 "c:\trees\bg-trunk\bluegriffon\sidebars\cssproperties\content\cssproperties.js"
var gIsPanelActive = false;
//@line 18 "c:\trees\bg-trunk\bluegriffon\sidebars\cssproperties\content\cssproperties.js"

function Startup()
{
  GetUIElements();

  Bezier.init();

  InitLocalFontFaceMenu(gDialog.addFontMenupopup);

  gInUtils = Components.classes["@mozilla.org/inspector/dom-utils;1"]
              .getService(Components.interfaces.inIDOMUtils);

  if (window.top &&
      "NotifierUtils" in window.top)
    gMain = window.top;
  else if (window.top && window.top.opener &&
           "NotifierUtils" in window.top.opener)
    gMain = window.top.opener;

  if (!gMain)
    return;
  
  gMain.NotifierUtils.addNotifierCallback("selection",
                                          SelectionChanged,
                                          window);
  gMain.NotifierUtils.addNotifierCallback("tabClosed",
                                          Inspect,
                                          window);
  gMain.NotifierUtils.addNotifierCallback("tabCreated",
                                          Inspect,
                                          window);
  gMain.NotifierUtils.addNotifierCallback("tabSelected",
                                          Inspect,
                                          window);
  gMain.NotifierUtils.addNotifierCallback("redrawPanel",
                                          RedrawAll,
                                          window);
  gMain.NotifierUtils.addNotifierCallback("panelClosed",
                                          PanelClosed,
                                          window);
  Inspect();
  if (gMain && gMain.EditorUtils && gIsPanelActive &&
      gMain.EditorUtils.getCurrentEditor()) {
    var c = gMain.EditorUtils.getSelectionContainer();
    if (c)
      SelectionChanged(null, c.node, c.oneElementSelected);
  }
}

function Shutdown()
{
  if (gMain)
  {
    gMain.NotifierUtils.removeNotifierCallback("selection",
                                               SelectionChanged,
                                               window);
    gMain.NotifierUtils.removeNotifierCallback("tabClosed",
                                               Inspect);
    gMain.NotifierUtils.removeNotifierCallback("tabCreated",
                                               Inspect);
    gMain.NotifierUtils.removeNotifierCallback("tabSelected",
                                               Inspect);
	  gMain.NotifierUtils.removeNotifierCallback("redrawPanel",
			                                          RedrawAll,
			                                          window);
	  gMain.NotifierUtils.removeNotifierCallback("panelClosed",
			                                          PanelClosed,
			                                          window);
  }
}

function Inspect()
{
  if (gMain && gMain.EditorUtils)
  {
    var editor = gMain.EditorUtils.getCurrentEditor();
    gDialog.mainBox.hidden = !editor;
    if (editor) {
      var node = EditorUtils.getSelectionContainer().node;
      if (node) {
        gCurrentElement = null;
        SelectionChanged(null, node, true);
      }
    }
  }
}

function RedrawAll(aNotification, aPanelId)
{
  if (aPanelId == "panel-cssproperties") {
    gIsPanelActive = true;
    if (gCurrentElement) {
      // force query of all properties on the current element
      var elt = gCurrentElement;
      gCurrentElement = null;
      SelectionChanged(null, elt, true);
    }
  }
}

function PanelClosed(aNotification, aPanelId)
{
  if (aPanelId == "panel-cssproperties")
    gIsPanelActive = false;
}

function SelectionChanged(aArgs, aElt, aOneElementSelected)
{
  if (!gIsPanelActive || (gCurrentElement == aElt)) {
    gCurrentElement = aElt;
    return;
  }

  gCurrentElement = aElt;
  deleteAllChildren(gDialog.classPickerPopup);
  gDialog.classPicker.value =  "";

  var item;
  for (var i = aElt.classList.length -1; i >= 0; i--) {
    var c = aElt.classList.item(i);
    item = gDialog.classPicker.appendItem(c, c);
  }
  if (item)
    gDialog.classPicker.selectedItem = item;

  var inspector = Components.classes["@mozilla.org/inspector/dom-utils;1"]
                    .getService(Components.interfaces.inIDOMUtils);
  var state;
  var dynamicPseudo = "";
  if (gDialog.hoverStateCheckbox.checked) {
    state = inspector.getContentState(gCurrentElement);
    inspector.setContentState(gCurrentElement, state | 4); // NS_EVENT_STATE_HOVER
    dynamicPseudo = "hover";
  }
  var ruleset = CssInspector.getCSSStyleRules(aElt, false, dynamicPseudo);
  if (gDialog.hoverStateCheckbox.checked) {
    inspector.setContentState(gCurrentElement.ownerDocument.documentElement, 4); // NS_EVENT_STATE_HOVER
    var display = gCurrentElement.style.display;
  }
  for (var i = 0; i < gIniters.length; i++)
    gIniters[i](aElt, ruleset);

  gDialog.currentElementBox.setAttribute("value",
       "<" + gCurrentElement.nodeName.toLowerCase() +
       (gCurrentElement.id ? " id='" + gCurrentElement.id + "'" : "") +
       (gCurrentElement.className ? " class='" + gCurrentElement.className + "'" : "") +
       ">" +
       gCurrentElement.innerHTML.substr(0, 100));
}

function onCssPolicyChange(aElt)
{
  var cssPolicy = aElt.value;
  gDialog.classPicker.hidden = (cssPolicy !="class");
  if (cssPolicy == "class")
    gDialog.classPicker.focus();
}

function ToggleSection(header)
{
  var section = header.nextElementSibling;
  if (header.hasAttribute("open")) {
    section.style.height = "0px";
    header.removeAttribute("open");
  }
  else {
    section.style.height = "";
    header.setAttribute("open", "true");
    section.style.height = document.defaultView.getComputedStyle(section, "").getPropertyValue("height");
  }
  document.persist(header.id, "open");
  document.persist(section.id, "style");
}

var gIniters = [];

function RegisterIniter(aFn)
{
  gIniters.push(aFn);
}

function GetComputedValue(aElt, aProperty)
{
  return aElt.ownerDocument.defaultView.getComputedStyle(aElt, "").getPropertyValue(aProperty);
}

var gSavedSelection;
function SaveSelection()
{
  var editor = EditorUtils.getCurrentEditor();
  var selection = editor.selection;
  gSavedSelection = [];
  for (var i = 0; i < selection.rangeCount; i++) {
    var r = selection.getRangeAt(i);
    gSavedSelection.push( {
                            startContainer: r.startContainer,
                           startOffset   : r.startOffset,
                           endContainer  : r.endContainer,
                           endOffset     : r.endOffset
                         });
  }
}

function RestoreSelection()
{
  if (!gSavedSelection)
    return;
  var editor = EditorUtils.getCurrentEditor();
  var selection = editor.selection;
  selection.removeAllRanges();
  for (var i = 0 ; i < gSavedSelection.length; i++) {
    var s = gSavedSelection[i];
    var range = document.createRange();
    range.setStart(s.startContainer, s.startOffset);
    range.setEnd(s.endContainer, s.endOffset);
    selection.addRange(range);
  }
  // don't preserve a reference to nodes !
  gSavedSelection = null;
}

function ApplyStyles(aStyles)
{
  var className;
  var editor = EditorUtils.getCurrentEditor();
  if (gDialog.hoverStateCheckbox.checked)
    gDialog.cssPolicyMenulist.value = "id";
  switch (gDialog.cssPolicyMenulist.value) {
    case "id":
	    // if the element has no ID, ask for one...
	    if (!gCurrentElement.id) {
	      var result = {};
	      if (!PromptUtils.prompt(window,
	                              gDialog.csspropertiesBundle.getString("EnterAnId"),
	                              gDialog.csspropertiesBundle.getString("EnterUniqueId"),
	                              result))
	        return;
        editor.beginTransaction();
	      editor.setAttribute(gCurrentElement, "id", result.value);
	    }
      else
        editor.beginTransaction();
      break;

    case "class":
      if (!gDialog.classPicker.value) {
        PromptUtils.alertWithTitle(gDialog.csspropertiesBundle.getString("NoClasSelected"),
                                   gDialog.csspropertiesBundle.getString("PleaseSelectAClass"),
                                   window);
        return;
      }

      editor.beginTransaction();
      // make sure the element carries the user-selected class
      if (!gCurrentElement.classList.contains(gDialog.classPicker.value))
        gCurrentElement.classList.add(gDialog.classPicker.value); // XXX
      className = gDialog.classPicker.value;
      break;

    default:
      editor.beginTransaction();
      break;
  }

  SaveSelection();
  for (var i = 0; i < aStyles.length; i++) {
    var s = aStyles[i];
    var property = s.property;
    var value = s.value;

    switch (gDialog.cssPolicyMenulist.value) {

      case "id":
          ApplyStyleChangesToStylesheets(editor, gCurrentElement, property, value,
                                         "#", "#", gCurrentElement.id);
        break;

      case "inline":
        try {
          var txn = new diStyleAttrChangeTxn(gCurrentElement, property, value, "");
          EditorUtils.getCurrentEditor().transactionManager.doTransaction(txn);  
        }
        catch(e) {}
        break;

      case "class":
          ApplyStyleChangesToStylesheets(editor, gCurrentElement, property, value,
                                         ".", "\\.", className);
        break;
      default:
        break;
    }
  }
  editor.endTransaction();
  RestoreSelection();
}

function FindLastEditableStyleSheet()
{
  var doc = EditorUtils.getCurrentDocument();
  var headElt = doc.querySelector("head");
  var child = headElt.lastElementChild;
  var found = false;
  while (!found && child) {
    var name = child.nodeName.toLowerCase();
    if (name == "style" ||
        (name == "link" &&
         child.getAttribute("rel").toLowerCase() == "stylesheet" &&
         !child.hasAttribute("title"))) {
      var media = child.getAttribute("media") || "";
      var mediaArray = media.split(",");
      mediaArray.forEach(function(element,index,array) {array[index] = array[index].toLowerCase().trim()});
      var isForScreen = (!media || media == "all" || mediaArray.indexOf("screen") != -1);
      if (name == "link") {
	      var uri = Components.classes["@mozilla.org/network/io-service;1"]
	                              .getService(Components.interfaces.nsIIOService)
	                              .newURI(child.sheet.href, null, null);
	      if (uri.scheme == "file" && isForScreen)
	        found = true;
	      else
	        child = child.previousElementSibling;
      }
      else if (isForScreen)
        found = true;
      else
        child = child.previousElementSibling;
    }
    else
      child = child.previousElementSibling;
  }
  if (found)
    sheet = child.sheet;
  else { // no editable stylesheet in the document, create one
    var styleElt = doc.createElement("style");
    styleElt.setAttribute("type", "text/css");
    EditorUtils.getCurrentEditor().insertNode(styleElt, headElt, headElt.childNodes.length);
    sheet = styleElt.sheet;
  }
  return sheet;
}

function ToggleProperty(aElt)
{
  var checked   = aElt.hasAttribute("checked");
  var value = (aElt.hasAttribute("value") ? aElt.getAttribute("value") : aElt.value);
  if (!checked &&
      (aElt.nodeName.toLowerCase() == "checkbox" || aElt.getAttribute("type") == "checkbox"))
    value = "";
  var property  = aElt.getAttribute("property");
  var resetter  = aElt.getAttribute("resetter");
  var group     = aElt.getAttribute("group");
  var agregator = aElt.getAttribute("agregator");
  var others = [];
  if (agregator)
    others = document.querySelectorAll("[agregator='" + agregator + "']");
  else if (group)
    others = document.querySelectorAll("[group='" + group + "']");
  for (var i = 0; i < others.length; i++) {
    var e = others[i];
    if (e != aElt) {
      if (resetter == "true" || group)
        e.removeAttribute("checked");
      else {
        if (agregator && e.hasAttribute("checked"))
          value += " " + e.getAttribute("value");
      }
    }
  }
  ApplyStyles([ { property: property, value: value} ]);
}

function CheckToggle(aToggle, aChecked)
{
  if (aChecked)
    aToggle.setAttribute("checked", "true");
  else
    aToggle.removeAttribute("checked");
}

function PopulateLengths(aElt, aUnitsString)
{
  var menuseparator = aElt.querySelector("menuseparator");
  if (menuseparator) {
    var child = aElt.firstChild;
    while (child && child != menuseparator) {
      var tmp = child.nextSibling;
      aElt.removeChild(child);
      child = tmp;
    }
  }
  else
    deleteAllChildren(aElt);

  var v = parseFloat(aElt.parentNode.value);
  if (isNaN(v))
    v = 0;
  var unitsArray;
  if (aUnitsString == " ")
    unitsArray = [""];
  else
    unitsArray = aUnitsString.split(" ");
  unitsArray.forEach(function(aArrayElt, aIndex, aArray) {
    var menuitem = document.createElement("menuitem");
    menuitem.setAttribute("label", v + aArrayElt);
    menuitem.setAttribute("value", v + aArrayElt);
    aElt.insertBefore(menuitem, menuseparator);
  });
}

function ApplyPropertyFromMenulist(aElt)
{
  var value;
  if (aElt.selectedItem)
    value = aElt.selectedItem.value;
  else
    value = aElt.value;

  var toApply = [
                  {
                    property: aElt.getAttribute("property"),
                    value: value
                  }
                ];
  if (aElt.hasAttribute("fouredges") && aElt.hasAttribute("fouredgescontrol")) {
    if (document.getElementById(aElt.getAttribute("fouredgescontrol")).checked) {
      var edgesArray = aElt.getAttribute("fouredges").split(",");
      for (var i = 0; i < edgesArray.length; i++)
        toApply.push({
                       property: edgesArray[i],
                       value: value
                     } );
    }
  }
  ApplyStyles(toApply);
}

function IncreaseLength(aElt, aUnitsString, aCallback)
{
  var value;
  var menulist = aElt.previousSibling;
  if (menulist.selectedItem)
    value = menulist.selectedItem.value;
  else
    value = menulist.value;
  var units = aUnitsString.replace( / /g, "|");
  var r = new RegExp( "([+-]?[0-9]*\\.[0-9]+|[+-]?[0-9]+)(" + units + ")*", "");
  var match = value.match( r );
  if (match) {
    var unit = match[2];
    var v    = parseFloat(match[1]);
    switch (unit) {
      case "in":
      case "cm":
        v += 0.1;
        v = Math.round( v * 10) / 10;
        break;
      case "em":
      case "ex":
        v += 0.5;
        v = Math.round( v * 10) / 10;
        break;
      default:
        v += 1;
        break;
    }
    menulist.value = v + (unit ? unit : "");
    onLengthMenulistCommand(menulist, aUnitsString, '', false, aCallback);
  }
}

function DecreaseLength(aElt, aUnitsString, aAllowNegative, aCallback)
{
  var value;
  var menulist = aElt.previousSibling;
  if (menulist.selectedItem)
    value = menulist.selectedItem.value;
  else
    value = menulist.value;
  var units = aUnitsString.replace( / /g, "|");
  var r = new RegExp( "([+-]?[0-9]*\\.[0-9]+|[+-]?[0-9]+)(" + units + ")*", "");
  var match = value.match( r );
  if (match) {
    var unit = match[2];
    var v    = parseFloat(match[1]);
    switch (unit) {
      case "in":
      case "cm":
        v -= 0.1;
        v = Math.round( v * 10) / 10;
        break;
      case "em":
      case "ex":
        v -= 0.5;
        v = Math.round( v * 10) / 10;
        break;
      default:
        v -= 1;
        break;
    }
    if (!aAllowNegative && v < 0)
      v = 0;
    menulist.value = v + (unit ? unit : "");
    onLengthMenulistCommand(menulist, aUnitsString, '', aAllowNegative, aCallback);
  }
}

function onLengthMenulistCommand(aElt, aUnitsString, aIdentsString, aAllowNegative, aCallback)
{
  var idents = aIdentsString.split(" ");
  var value;
  if (aElt.selectedItem)
    value = aElt.selectedItem.value;
  else
    value = aElt.value;
  aElt.value = value;
  var units = aUnitsString.replace( / /g, "|");
  var r = new RegExp( "([+-]?[0-9]*\\.[0-9]+|[+-]?[0-9]+)(" + units + ")*", "");
  var match = value.match( r );
  if (aElt.getAttribute("property")) {
	  if (!value ||
	      (match && !(!aAllowNegative && parseFloat(match[1]) < 0) &&
	       (match[2] || units[0] == "|")) ||
	      idents.indexOf(value) != -1) {
	    var toApply = [ {
		                    property: aElt.getAttribute("property"),
		                    value: value
	                    } ];
	    if (aElt.hasAttribute("fouredges") && aElt.hasAttribute("fouredgescontrol")) {
	      if (document.getElementById(aElt.getAttribute("fouredgescontrol")).checked) {
		      var edgesArray = aElt.getAttribute("fouredges").split(",");
		      for (var i = 0; i < edgesArray.length; i++)
			      toApply.push({
			                     property: edgesArray[i],
			                     value: value
			                   } );
	      }
	    }
	    if (aElt.hasAttribute("checkimageratio") &&
	        gCurrentElement.nodeName.toLowerCase() == "img" &&
	        gDialog.preserveImageRatioCheckbox.checked) {
	      var id = aElt.id;
	      var otherId = (id == "widthMenulist") ? "heightMenulist" : "widthMenulist";
	      var otherValue = null;
	      if (value == "auto" ||
	          (value && value.indexOf("%") != -1))
	        otherValue = value;
	      else if (match) {
	        var ratio = (id == "widthMenulist") ? gCurrentElement.naturalHeight / gCurrentElement.naturalWidth :
	                                              gCurrentElement.naturalWidth / gCurrentElement.naturalHeight;
	        otherValue = (parseFloat(match[1]) * ratio) + match[2]; 
	      }
	
	      if (value)
	        toApply.push({
	                       property: gDialog[otherId].getAttribute("property"),
	                       value: otherValue
	                     } );
	    }
	    ApplyStyles(toApply);
	  }
  }
  if (aCallback)
    aCallback(aElt);
}

function InitLocalFontFaceMenu(menuPopup)
{
  // fill in the menu only once...
  var callingId = menuPopup.parentNode.id;

  if(!BlueGriffonVars.fontMenuOk)
    BlueGriffonVars.fontMenuOk = {};
  if (BlueGriffonVars.fontMenuOk[callingId])
    return;
  BlueGriffonVars.fontMenuOk[callingId ] = callingId ;

  if (!BlueGriffonVars.localFonts)
  {
    // Build list of all local fonts once per editor
    try 
    {
      var enumerator = Components.classes["@mozilla.org/gfx/fontenumerator;1"]
                                 .getService(Components.interfaces.nsIFontEnumerator);
      var localFontCount = { value: 0 }
      BlueGriffonVars.localFonts = enumerator.EnumerateAllFonts(localFontCount);
    }
    catch(e) { }
  }
  
  for (var i = 0; i < BlueGriffonVars.localFonts.length; ++i)
  {
    if (BlueGriffonVars.localFonts[i] != "")
    {
      var itemNode = document.createElementNS(BlueGriffonVars.kXUL_NS, "menuitem");
      itemNode.setAttribute("label", BlueGriffonVars.localFonts[i]);
      itemNode.setAttribute("value", BlueGriffonVars.localFonts[i]);
      itemNode.setAttribute("style", "font-family: " + BlueGriffonVars.localFonts[i]);
      menuPopup.appendChild(itemNode);
    }
  }
}

function ApplyStyleChangesToStylesheets(editor, aElement, property, value,
                                        aDelimitor, aRegExpDelimitor, aIdent)
{
  // first, clean the style attribute for the style to apply
  var txn = new diStyleAttrChangeTxn(aElement, property, "", "");
  EditorUtils.getCurrentEditor().transactionManager.doTransaction(txn);

  var inspector = Components.classes["@mozilla.org/inspector/dom-utils;1"]
                    .getService(Components.interfaces.inIDOMUtils);
  var state;
  var dynamicPseudo = "";
  if (gDialog.hoverStateCheckbox.checked) {
    state = inspector.getContentState(gCurrentElement);
    inspector.setContentState(gCurrentElement, state | 4); // NS_EVENT_STATE_HOVER
    aIdent += ":hover";
    dynamicPseudo = "hover";
  }
  var ruleset = CssInspector.getCSSStyleRules(aElement, true, dynamicPseudo);
  if (gDialog.hoverStateCheckbox.checked) {
    inspector.setContentState(gCurrentElement.ownerDocument.documentElement, state | 4);
  }
  var inspectedRule = CssInspector.findRuleForProperty(ruleset, property);
  if (inspectedRule && inspectedRule.rule) {
    // ok, that property is already applied through a CSS rule

    // is that rule dependent on the ID selector for that ID?
    // if yes, let's try to tweak it
    var priority = inspectedRule.rule.style.getPropertyPriority(property);
    var selector = inspectedRule.rule.selectorText;
    var r = new RegExp( aRegExpDelimitor + aIdent + "$|" + aRegExpDelimitor + aIdent + "[\.:,\\[]", "g");
    if (selector.match(r)) {
      // yes! can we edit the corresponding stylesheet or not?
      var sheet = inspectedRule.rule.parentStyleSheet;
      var topSheet = sheet;
      while (topSheet.parentStyleSheet)
        topSheet = topSheet.parentStyleSheet;
      if (topSheet.ownerNode &&
          (!sheet.href || sheet.href.substr(0, 4) != "http")) {
        // yes we can edit it...
        if (sheet.href) { // external stylesheet
          var txn = new diChangeFileStylesheetTxn(sheet.href, inspectedRule.rule,
                                                  property, value, priority);
          EditorUtils.getCurrentEditor().transactionManager.doTransaction(txn);  
        }
        else { // it's an embedded stylesheet
          if (value) {
            inspectedRule.rule.style.setProperty(property, value, priority);
          }
          else
            inspectedRule.rule.style.removeProperty(property);
          if (!inspectedRule.rule.style.length)
            sheet.deleteRule(inspectedRule.rule);
          CssUtils.reserializeEmbeddedStylesheet(sheet, editor);
        }
        return;
      }
    }
    // we need to check if the rule
    // has a specificity no greater than an ID's one

    // we need to find the last locally editable stylesheet
    // attached to the document
    var sheet = FindLastEditableStyleSheet();
    var spec = inspectedRule.specificity;
    if (!spec.a &&
        ((spec.b == 1 && spec.c == 0 && spec.d == 0) ||
         !spec.b)) { 
      var existingRule = CssInspector.findLastRuleInRulesetForSelector(
                           ruleset, aDelimitor + aIdent);
      if (existingRule &&
          (!existingRule.parentStyleSheet.href || existingRule.parentStyleSheet.href.substr(0, 4) != "http")) {
        sheet = existingRule.parentStyleSheet;
        existingRule.style.setProperty(property, value, priority);
      }
      else { 
        // cool, we can just create a new rule with an ID selector
        // but don't forget to set the priority...
        sheet.insertRule(aDelimitor + aIdent + "{" +
                           property + ": " + value + " " +
                           (priority ? "!important" : "") + "}",
                         sheet.cssRules.length);
      }
      if (sheet.ownerNode.href)
        CssInspector.serializeFileStyleSheet(sheet, sheet.href);
      else
        CssUtils.reserializeEmbeddedStylesheet(sheet, editor);
      return;
    }
    // at this point, we have a greater specificity; hum, then what's
    // the priority of the declaration?
    if (!priority) {
      var existingRule = CssInspector.findLastRuleInRulesetForSelector(
                           ruleset, aDelimitor + aIdent);
      if (existingRule &&
          (!existingRule.parentStyleSheet.href || existingRule.parentStyleSheet.href.substr(0, 4) != "http")) {
        sheet = existingRule.parentStyleSheet;
        existingRule.style.setProperty(property, value, "important");
      }
      else {
        // no priority, so cool we can create a !important declaration
        // for the ID
        sheet.insertRule(aDelimitor + aIdent + "{" +
                           property + ": " + value + " !important }",
                         sheet.cssRules.length);
      }
      if (sheet.ownerNode.href)
        CssInspector.serializeFileStyleSheet(sheet, sheet.href);
      else
        CssUtils.reserializeEmbeddedStylesheet(sheet, editor);
      return;
    }
    // argl, it's already a !important declaration :-( our only
    // choice is a !important style attribute... We can't just clean the
    // style on inspectedRule because some other rules could also apply
    // is that one goes away.
    var txn = new diStyleAttrChangeTxn(aElement, property, value, "important");
    EditorUtils.getCurrentEditor().transactionManager.doTransaction(txn);
  }
  else {
    // oh, the property is not applied yet, let's just create a rule
    // with the ID selector for that property
    var sheet;
    var existingRule = CssInspector.findLastRuleInRulesetForSelector(
                         ruleset, aDelimitor + aIdent);
    if (existingRule &&
          (!existingRule.parentStyleSheet.href || existingRule.parentStyleSheet.href.substr(0, 4) != "http")) {
      sheet = existingRule.parentStyleSheet;
      existingRule.style.setProperty(property, value, "");
    }
    else {
      sheet = FindLastEditableStyleSheet();
      sheet.insertRule(aDelimitor + aIdent + "{" +
                         property + ": " + value + " " + "}",
                       sheet.cssRules.length);
    }
    if (sheet.ownerNode.href)
      CssInspector.serializeFileStyleSheet(sheet, sheet.href);
    else
      CssUtils.reserializeEmbeddedStylesheet(sheet, editor);
  }
}

function SetColor(aElt)
{
  var color = aElt.color;
  var toApply = [
	                {
	                  property: aElt.getAttribute("property"),
	                  value: color
	                }
                ];
  if (aElt.hasAttribute("fouredges") && aElt.hasAttribute("fouredgescontrol")) {
    if (document.getElementById(aElt.getAttribute("fouredgescontrol")).checked) {
      var edgesArray = aElt.getAttribute("fouredges").split(",");
      for (var i = 0; i < edgesArray.length; i++)
        toApply.push({
                       property: edgesArray[i],
                       value: color
                     } );
    }
  }
  ApplyStyles(toApply);
}

function CloseAllSection(aAlsoCloseOriginalTarget)
{
  var h = document.popupNode;
  while (h && !h.classList.contains("csspropertiesHeader"))
    h = h.parentNode;
  if (!h) return; // sanity check...

  var headers = document.querySelectorAll(".csspropertiesHeader");
  for (var i = 0; i < headers.length; i++) {
    var header = headers[i];
    if ((aAlsoCloseOriginalTarget || header != h) &&
        header.hasAttribute("open"))
      ToggleSection(header);
  }
}

RegisterIniter(GeneralSectionIniter);

function GeneralSectionIniter(aElt, aRuleset)
{
  deleteAllChildren(gDialog.fontFamilyListbox);

  var fontFamily = CssInspector.getCascadedValue(aRuleset, "font-family");
  if (fontFamily) {
	  var fonts = fontFamily.split(",");
	  fonts.forEach(function(aElt, aIndex, aArray) {
	      gDialog.fontFamilyListbox.appendItem(aElt, aElt);
	    });
	  //SetEnabledElement(gDialog.removeFontButton, gDialog.fontFamilyListbox.itemCount);
  }

  var webFonts = CssInspector.getWebFonts(aElt.ownerDocument);
  var child = gDialog.beforeWebfontsMenuseparator.nextSibling;
  while (child && child.id != "afterWebfontsMenuseparator") {
    var tmp = child.nextSibling;
    gDialog.addFontMenupopup.removeChild(child);
    child = tmp;
  }
  var found = false;
  for (var i in webFonts) {
    found = true;
    var item = document.createElement("menuitem");
    item.setAttribute("label", i);
    item.setAttribute("value", i);
    gDialog.addFontMenupopup.insertBefore(item, gDialog.afterWebfontsMenuseparator)
  }
  gDialog.afterWebfontsMenuseparator.hidden = !found;

  var fw = CssInspector.getCascadedValue(aRuleset, "font-weight");
  CheckToggle(gDialog.fontWeightBoldButton,    fw == "bold" || fw == "700");
  CheckToggle(gDialog.fontWeightLighterButton, fw == "lighter");
  CheckToggle(gDialog.fontWeightBolderButton,  fw == "bolder");

  var fs = CssInspector.getCascadedValue(aRuleset, "font-style");
  CheckToggle(gDialog.fontStyleItalicButton,   fs == "italic");
  CheckToggle(gDialog.fontStyleObliqueButton,  fs == "oblique");

  var td = CssInspector.getCascadedValue(aRuleset, "text-decoration");
  var tdArray = td.split(" ");
  CheckToggle(gDialog.textDecorationUnderlineButton,    tdArray.indexOf("underline") != -1);
  CheckToggle(gDialog.textDecorationOverlineButton,     tdArray.indexOf("overline") != -1);
  CheckToggle(gDialog.textDecorationLinethroughButton,  tdArray.indexOf("line-through") != -1);

  var tt = CssInspector.getCascadedValue(aRuleset, "text-transform");
  CheckToggle(gDialog.textTransformLowercaseButton,   tt == "lowercase");
  CheckToggle(gDialog.textTransformUppercaseButton,   tt == "uppercase");
  CheckToggle(gDialog.textTransformLinethroughButton, tt == "capitalize");

  var ta = CssInspector.getCascadedValue(aRuleset, "text-align");
  CheckToggle(gDialog.textAlignLeftButton,    ta == "left");
  CheckToggle(gDialog.textAlignCenterButton,  ta == "center");
  CheckToggle(gDialog.textAlignRightButton,   ta == "right");
  CheckToggle(gDialog.textAlignJustifyButton, ta == "justify");

  CheckToggle(gDialog.textAlignStartButton,   ta == "start");
  CheckToggle(gDialog.textAlignEndButton,     ta == "end");

  //var fs = CssUtils.getComputedValue(aElt, "font-size");
  var fs = CssInspector.getCascadedValue(aRuleset, "font-size");
  gDialog.fontSizeMenulist.value = fs;

  var lh = CssInspector.getCascadedValue(aRuleset, "line-height");
  gDialog.lineHeightMenulist.value = lh;

  var fv = CssInspector.getCascadedValue(aRuleset, "font-variant");
  CheckToggle(gDialog.fontVariantNormalButton,    fv == "normal");
  CheckToggle(gDialog.fontVariantSmallCapsButton, fv == "small-caps");

  var ls = CssInspector.getCascadedValue(aRuleset, "letter-spacing");
  gDialog.letterSpacingMenulist.value = ls;

  var ws = CssInspector.getCascadedValue(aRuleset, "word-spacing");
  gDialog.wordSpacingMenulist.value = ws;

  var ww = CssInspector.getCascadedValue(aRuleset, "word-wrap");
  CheckToggle(gDialog.normalWordWrapButton,    ww == "normal");
  CheckToggle(gDialog.breakWrapWordWrapButton, ww == "break-word");

  var d = CssInspector.getCascadedValue(aRuleset, "direction");
  CheckToggle(gDialog.ltrDirectionButton,    d == "ltr");
  CheckToggle(gDialog.rtlDirectionButton,    d == "rtl");

  var ti = CssInspector.getCascadedValue(aRuleset, "text-indent");
  gDialog.textIndentMenulist.value = ti;

  var va = CssInspector.getCascadedValue(aRuleset, "vertical-align");
  gDialog.verticalAlignMenulist.value = va;
}

function AddFont(aEvent)
{
  var elt = aEvent.originalTarget;
  if (elt.nodeName.toLowerCase() != "menuitem")
    return;
  var value = elt.getAttribute("label");
  if (elt.hasAttribute("global")) {
    deleteAllChildren(gDialog.fontFamilyListbox);
    var fontsArray = value.split(",");
    for (var i = 0; i < fontsArray.length; i++) {
      var v = fontsArray[i].trim();
      gDialog.fontFamilyListbox.appendItem(v, v);
    }
  }
  else {
    gDialog.fontFamilyListbox.appendItem(value, value);
  }
  ApplyFontFamily();
}

function OnFontFamilySelect(aElt)
{
  var item = aElt.selectedItem;
  SetEnabledElement(gDialog.removeFontButton, (item != null));    
}

function DeleteFont()
{
  var item = gDialog.fontFamilyListbox.selectedItem;
  if (!item) return; // sanity check
  item.parentNode.removeChild(item);
  ApplyFontFamily();
}

function ApplyFontFamily()
{
  var child = gDialog.fontFamilyListbox.firstChild;
  var ff = "";
  while (child) {
    ff += (ff ? ", " : "") + child.value;
    child = child.nextSibling;
  }
  ApplyStyles([
                {
                  property: "font-family",
                  value: ff
                }
              ]);
}

RegisterIniter(ColorsSectionIniter);

function ColorsSectionIniter(aElt, aRuleset)
{
  deleteAllChildren(gDialog.backgroundsRichlistbox);
  var color = CssInspector.getCascadedValue(aRuleset, "color");
  gDialog.colorColorpicker.color = color;

  var bgColor = CssInspector.getCascadedValue(aRuleset, "background-color");
  gDialog.bgColorColorpicker.color = bgColor;

  var bgImages = CssInspector.getCascadedValue(aRuleset, "background-image");
  var parsedImages = CssInspector.parseBackgroundImages(bgImages);
  var bgAttachment = CssInspector.getCascadedValue(aRuleset, "background-attachment").split(",");
  var bgRepeat     = CssInspector.getCascadedValue(aRuleset, "background-repeat").split(",");
  var bgPosition   = CssInspector.getCascadedValue(aRuleset, "background-position").split(",");
  var bgSize       = CssInspector.getCascadedValue(aRuleset, "background-size").split(",");
  var bgClip       = CssInspector.getCascadedValue(aRuleset, "background-clip").split(",");
  var bgOrigin     = CssInspector.getCascadedValue(aRuleset, "background-origin").split(",");
  for (var i = 0; i < parsedImages.length; i++) {
    var item = document.createElement("richlistitem");
    item.className = "backgrounditem";
    var type = parsedImages[i].type;
    item.setAttribute("type", type);
    gDialog.backgroundsRichlistbox.appendChild(item);

    item.reset();
    var button = item.getChild("backgrounditemButton");
    item.parsedValue = parsedImages[i].value;
    switch (type) {
      case "image":
        button.style.backgroundImage = item.parsedValue;
        break;
      default:
        button.style.backgroundImage =
          CssInspector.serializeGradient(item.parsedValue);
        break;
    }

    item.getChild("backgrounditem-attachment").value =
      (i < bgAttachment.length ? bgAttachment[i].trim() : "");
    item.getChild("backgrounditem-repeat").value =
      (i < bgRepeat.length ? bgRepeat[i].trim() : "");
    item.getChild("backgrounditem-position").value =
      (i < bgPosition.length ? bgPosition[i].trim() : "");
    item.getChild("backgrounditem-size").value =
      (i < bgSize.length ? bgSize[i].trim() : "");
    item.getChild("backgrounditem-clip").value =
      (i < bgClip.length ? bgClip[i].trim() : "");
    item.getChild("backgrounditem-origin").value =
      (i < bgOrigin.length ? bgOrigin[i].trim() : "");
  }
}

function AddBackground(aEvent)
{
  var type = aEvent.originalTarget.value;
  var item = document.createElement("richlistitem");
  item.className = "backgrounditem";
  item.setAttribute("type", type);
  gDialog.backgroundsRichlistbox.appendChild(item);
  item.reset();
  item.openEditor();
}

function OnBackgroundSelect(aElt)
{
  var item = aElt.selectedItem;
  SetEnabledElement(gDialog.removeBackgroundButton, (item != null));    
}

function DeleteBackground()
{
  var item = gDialog.backgroundsRichlistbox.selectedItem;
  if (!item) return; // sanity check
  item.parentNode.removeChild(item);
  SetEnabledElement(gDialog.removeBackgroundButton, (gDialog.backgroundsRichlistbox.itemCount != 0));
  ReapplyBackgrounds();
}

function LoadImage()
{
  gDialog.previewBackgroundImage.style.backgroundImage =
    'url("' + gDialog.imageURLTextbox.inputField.value + '")';
}

function BackgroundImageSelected()
{
  gDialog.backgroundImagePanel.hidePopup();
  var item = gDialog.backgroundsRichlistbox.selectedItem;
  item.applyBackgroundImage(gDialog.imageURLTextbox.value);
}

function ReapplyBackgrounds()
{
  var items = gDialog.backgroundsRichlistbox.querySelectorAll("richlistitem");
  var bgColor = "", bgImages = [];
  for (var i = 0; i < items.length; i++) {
    var item = items[i];
    bgImages.push(item.serializedValue);
  }
  ApplyStyles([
                {
                  property: "background-image",
                  value: bgImages.join(", ")
                }
              ]);
}

function RepaintGradient()
{
  var angle = gDialog.linearGradientAngleCheckbox.checked ? gDialog.linearGradientAngleRotator.value + "deg"
                                                          : "";
  var startingPoint = gDialog.linearGradientStartingPointCheckbox.checked ? gDialog.linearGradientStartingPointMenulist.value
                                                          : "";
  var hOffset = gDialog.linearGradientHorizOffsetCheckbox.checked ? gDialog.linearGradientHorizOffset.value
                                                          : "";
  var type = gDialog.shapeAndSizeTab.hidden ? "-moz-linear-gradient(" : "-moz-radial-gradient(";
  var str = type + ((angle || startingPoint) ? angle + " " + startingPoint + "," : "");
  if (!gDialog.shapeAndSizeTab.hidden) {
    var shape = gDialog.radialGradientShape.value;
    var size  = gDialog.radioGradientSize.value;
    str += ((shape || size) ? shape + " " + size + "," : "");
  }

  var stops = gDialog.colorStopsRichlistbox.querySelectorAll("richlistitem.colorstopitem");
  for (var i = 0; i < stops.length; i++) {
    if (i)
      str += ", ";
    var s = stops[i];
    str += s.color + (s.offset ? " " + s.offset : "");
  }
  str += ")";
  gDialog.linearGradientPreview.style.backgroundImage = str;
}

function SetLinearGradient()
{
  var gradient = gDialog.linearGradientPreview.style.backgroundImage;
  var item = gDialog.backgroundsRichlistbox.selectedItem;
  item.getChild("backgrounditemButton").style.backgroundImage = gradient;
  item.parsedValue = CssInspector.parseBackgroundImages(gradient)[0].value;
  gDialog.linearGradientPanel.hidePopup();
  ReapplyBackgrounds();
}

function UpdateColorStopsRichlistbox()
{
  var item = gDialog.colorStopsRichlistbox.selectedItem;
  if (gDialog.colorStopsRichlistbox.itemCount && item &&
      item.parentNode) {
    gDialog.removeColorStopButton.disabled = false;
    gDialog.upColorStopButton.disabled = !item.previousElementSibling;
    gDialog.downColorStopButton.disabled = !item.nextElementSibling;
  }
  else {
    gDialog.removeColorStopButton.disabled = true;
    gDialog.upColorStopButton.disabled = true;
    gDialog.downColorStopButton.disabled = true;
  }
  gDialog.linearGradientOkButton.disabled = (gDialog.colorStopsRichlistbox.itemCount < 2);
}

function AddColorStopToLinearGradient()
{
  var e = document.createElement("richlistitem");
  e.className = "colorstopitem";
  gDialog.colorStopsRichlistbox.appendChild(e);
  UpdateColorStopsRichlistbox();
  e.openEditor();
}

function DeleteColorStopFromLinearGradient()
{
  gDialog.colorStopsRichlistbox.removeChild(gDialog.colorStopsRichlistbox.selectedItem);
  UpdateColorStopsRichlistbox();
}

function FlushBackgroundProperties(aEvent)
{
  var target = aEvent.originalTarget;
  while (target && !target.hasAttribute("property"))
    target = target.parentNode;
  var property = target.getAttribute("property");
  var anonid = target.getAttribute("anonid");

  var valueArray = []
  var items = document.querySelectorAll("richlistitem.backgrounditem");
  for (var i = 0; i < items.length; i++) {
    var xulElt = items[i].getChild(anonid);
    valueArray.push( xulElt.value );
  }
  // cleanup
  for (var i = valueArray.length - 1 ; i >=0; i++)
    if (valueArray[i] == "")
      valueArray.pop();
    else
      break;
  ApplyStyles([
                {
                  property: property,
                  value: valueArray.join(", ")
                }
              ]);
}
RegisterIniter(GeometrySectionIniter);

function GeometrySectionIniter(aElt, aRuleset)
{
  var mt = CssInspector.getCascadedValue(aRuleset, "margin-top");
  var mb = CssInspector.getCascadedValue(aRuleset, "margin-bottom");
  var ml = CssInspector.getCascadedValue(aRuleset, "margin-left");
  var mr = CssInspector.getCascadedValue(aRuleset, "margin-right");
  var afm = (mt == mb && mt == ml && mt == mr);
  gDialog.useSameFourMarginsCheckbox.checked = afm;
  gDialog.marginRightMenulist.style.visibility = (afm ? "hidden": "");
  gDialog.marginLeftMenulist.style.visibility = (afm ? "hidden": "");
  gDialog.marginTopMenulist.style.visibility = (afm ? "hidden": "");
  gDialog.marginRightMenulist.nextElementSibling.style.visibility = afm ? "hidden": "";
  gDialog.marginLeftMenulist.nextElementSibling.style.visibility = afm ? "hidden": "";
  gDialog.marginTopMenulist.nextElementSibling.style.visibility = afm ? "hidden": "";
  gDialog.marginTopMenulist.value = mt;
  gDialog.marginBottomMenulist.value = mb;
  gDialog.marginLeftMenulist.value = ml;
  gDialog.marginRightMenulist.value = mr;

  var pt = CssInspector.getCascadedValue(aRuleset, "padding-top");
  var pb = CssInspector.getCascadedValue(aRuleset, "padding-bottom");
  var pl = CssInspector.getCascadedValue(aRuleset, "padding-left");
  var pr = CssInspector.getCascadedValue(aRuleset, "padding-right");
  var afp = (pt == pb && pt == pl && pt == pr);
  gDialog.useSameFourPaddingsCheckbox.checked = afp;
  gDialog.paddingRightMenulist.style.visibility = (afp ? "hidden" : "");
  gDialog.paddingLeftMenulist.style.visibility = (afp ? "hidden" : "");
  gDialog.paddingTopMenulist.style.visibility = (afp ? "hidden" : "");
  gDialog.paddingRightMenulist.nextElementSibling.style.visibility = (afp ? "hidden" : "");
  gDialog.paddingLeftMenulist.nextElementSibling.style.visibility = (afp ? "hidden" : "");
  gDialog.paddingTopMenulist.nextElementSibling.style.visibility = (afp ? "hidden" : "");
  gDialog.paddingTopMenulist.value = pt;
  gDialog.paddingBottomMenulist.value = pb;
  gDialog.paddingLeftMenulist.value = pl;
  gDialog.paddingRightMenulist.value = pr;

  var w = CssInspector.getCascadedValue(aRuleset, "width");
  gDialog.widthMenulist.value = w;
  var mw = CssInspector.getCascadedValue(aRuleset, "min-width");
  gDialog.minWidthMenulist.value = mw;
  var Mw = CssInspector.getCascadedValue(aRuleset, "max-width");
  gDialog.maxWidthMenulist.value = Mw;
  var h = CssInspector.getCascadedValue(aRuleset, "height");
  gDialog.heightMenulist.value = h;
  var mh = CssInspector.getCascadedValue(aRuleset, "min-height");
  gDialog.minHeightMenulist.value = mh;
  var Mh = CssInspector.getCascadedValue(aRuleset, "max-height");
  gDialog.maxHeightMenulist.value = Mh;

  var isImg = (aElt.nodeName.toLowerCase() == "img");
  gDialog.preserveImageRatioCheckbox.hidden = !isImg;
  if (isImg)
    gDialog.getNaturalSizeButton.removeAttribute("hidden");
  else
    gDialog.getNaturalSizeButton.setAttribute("hidden", "true");
}

function ToggleFourEdges(aCheckbox, aPrefix)
{
  var checked = aCheckbox.checked;
  gDialog[aPrefix + "RightMenulist"].style.visibility = (checked ? "hidden": "");
  gDialog[aPrefix + "LeftMenulist"].style.visibility = (checked ? "hidden": "");
  gDialog[aPrefix + "TopMenulist"].style.visibility = (checked ? "hidden": "");
  gDialog[aPrefix + "RightMenulist"].nextElementSibling.style.visibility = (checked ? "hidden": "");
  gDialog[aPrefix + "LeftMenulist"].nextElementSibling.style.visibility = (checked ? "hidden": "");
  gDialog[aPrefix + "TopMenulist"].nextElementSibling.style.visibility = (checked ? "hidden": "");
  if (checked) {
    var value = gDialog[aPrefix + "BottomMenulist"].value;
	  gDialog[aPrefix + "RightMenulist"].value= value;
	  gDialog[aPrefix + "LeftMenulist"].value= value;
	  gDialog[aPrefix + "TopMenulist"].value= value;
    onLengthMenulistCommand(gDialog[aPrefix + "BottomMenulist"], '% px pt cm in mm pc em ex', '', false);
  }
}

function GetNaturalSize()
{
  gDialog.widthMenulist.value = gCurrentElement.naturalWidth + "px";
  gDialog.heightMenulist.value = gCurrentElement.naturalHeight + "px";
  gDialog.preserveImageRatioCheckbox.checked = true;
  ApplyStyles( [ {
							    property: "width",
                  value: gDialog.widthMenulist.value
							  },
                {
                  property: "height",
                  value: gDialog.heightMenulist.value
                }
  ]);
}
RegisterIniter(PositionSectionIniter);

function PositionSectionIniter(aElt, aRuleset)
{
  var d = CssInspector.getCascadedValue(aRuleset, "display");
  gDialog.displayMenulist.value = d;

  var v = CssInspector.getCascadedValue(aRuleset, "visibility");
  CheckToggle(gDialog.visibleVisibilityButton,   v == "visible");
  CheckToggle(gDialog.hiddenVisibilityButton,    v == "hidden");
  CheckToggle(gDialog.collapseVisibilityButton,  v == "collapse");

  var f = CssInspector.getCascadedValue(aRuleset, "float");
  CheckToggle(gDialog.floatLeftButton,   f == "left");
  CheckToggle(gDialog.floatNoneButton,   f == "none");
  CheckToggle(gDialog.floatRightButton,  f == "right");

  var p = CssInspector.getCascadedValue(aRuleset, "position");
  CheckToggle(gDialog.positionStaticButton,   p == "static");
  CheckToggle(gDialog.positionRelativeButton, p == "relative");
  CheckToggle(gDialog.positionAbsoluteButton, p == "absolute");
  CheckToggle(gDialog.positionFixedButton,    p == "fixed");

  var zi = CssInspector.getCascadedValue(aRuleset, "z-index");
  gDialog.zIndexMenulist.value = zi;

  var t = CssInspector.getCascadedValue(aRuleset, "top");
  var l = CssInspector.getCascadedValue(aRuleset, "left");
  var r = CssInspector.getCascadedValue(aRuleset, "right");
  var b = CssInspector.getCascadedValue(aRuleset, "bottom");
  gDialog.topMenulist.value = t;
  gDialog.leftMenulist.value = l;
  gDialog.rightMenulist.value = r;
  gDialog.bottomMenulist.value = b;

  var c = CssInspector.getCascadedValue(aRuleset, "clear");
  CheckToggle(gDialog.clearLeftButton,   c == "left");
  CheckToggle(gDialog.clearRightButton,  c == "right");
  CheckToggle(gDialog.clearBothButton,   c == "both");
  CheckToggle(gDialog.clearNoneButton,   c == "none");

  var o = CssInspector.getCascadedValue(aRuleset, "overflow");
  CheckToggle(gDialog.visibleOverflowButton,  o == "visible");
  CheckToggle(gDialog.hiddenOverflowButton,   o == "hidden");
  CheckToggle(gDialog.scrollOverflowButton,   o == "scroll");
  CheckToggle(gDialog.autoOverflowButton,     o == "auto");
}
Components.utils.import("resource://gre/modules/urlHelper.jsm");

RegisterIniter(BordersSectionIniter);

function BordersSectionIniter(aElt, aRuleset)
{
  var bbw = CssInspector.getCascadedValue(aRuleset, "border-bottom-width");
  var btw = CssInspector.getCascadedValue(aRuleset, "border-top-width");
  var blw = CssInspector.getCascadedValue(aRuleset, "border-left-width");
  var brw = CssInspector.getCascadedValue(aRuleset, "border-right-width");

  var bbs = CssInspector.getCascadedValue(aRuleset, "border-bottom-style");
  var bts = CssInspector.getCascadedValue(aRuleset, "border-top-style");
  var bls = CssInspector.getCascadedValue(aRuleset, "border-left-style");
  var brs = CssInspector.getCascadedValue(aRuleset, "border-right-style");

  var bbc = CssInspector.getCascadedValue(aRuleset, "border-bottom-color");
  var btc = CssInspector.getCascadedValue(aRuleset, "border-top-color");
  var blc = CssInspector.getCascadedValue(aRuleset, "border-left-color");
  var brc = CssInspector.getCascadedValue(aRuleset, "border-right-color");

  gDialog.borderTopColorpicker.color    = btc;
  gDialog.borderLeftColorpicker.color   = blc;
  gDialog.borderRightColorpicker.color  = brc;
  gDialog.borderBottomColorpicker.color = bbc;

  gDialog.borderTopWidthMenulist.value    = btw;
  gDialog.borderLeftWidthMenulist.value   = blw;
  gDialog.borderRightWidthMenulist.value  = brw;
  gDialog.borderBottomWidthMenulist.value = bbw;

  gDialog.borderTopStyleMenulist.value    = bts;
  gDialog.borderLeftStyleMenulist.value   = bls;
  gDialog.borderRightStyleMenulist.value  = brs;
  gDialog.borderBottomStyleMenulist.value = bbs;

  var sameOnFourEdges =  (bbw == btw && bbw == blw && bbw == brw &&
                          bbs == bts && bbs == bls && bbs == brs &&
                          bbc == btc && bbc == blc && bbc == brc);
  gDialog.sameBorderOnFourEdgesCheckbox.checked = sameOnFourEdges;

  gDialog.borderTopColorpicker.parentNode.hidden = sameOnFourEdges;
  gDialog.borderLeftColorpicker.parentNode.hidden = sameOnFourEdges;
  gDialog.borderRightColorpicker.parentNode.hidden = sameOnFourEdges;
  gDialog.borderBottomLabel.style.visibility = (sameOnFourEdges ? "hidden" : "visible");

  var tlCorner = CssInspector.getCascadedValue(aRuleset, "border-top-left-radius");
  var trCorner = CssInspector.getCascadedValue(aRuleset, "border-top-right-radius");
  var blCorner = CssInspector.getCascadedValue(aRuleset, "border-bottom-left-radius");
  var brCorner = CssInspector.getCascadedValue(aRuleset, "border-bottom-right-radius");
  var sameFourCorners = (tlCorner == trCorner && tlCorner == blCorner && tlCorner == brCorner);
  var r = new RegExp( "([+-]?[0-9]*\\.[0-9]+|[+-]?[0-9]+)(%|px|pt|cm|in|mm|pc|em|ex)*", "g");
  tlCorner = tlCorner.match(r);
  trCorner = trCorner.match(r);
  blCorner = blCorner.match(r);
  brCorner = brCorner.match(r);
  gDialog.topLeftBorderRadiusXMenulist.value = (tlCorner && tlCorner.length) ? tlCorner[0] : "0px";
  gDialog.topLeftBorderRadiusYMenulist.value = (tlCorner && tlCorner.length == 2) ? tlCorner[1] : gDialog.topLeftBorderRadiusXMenulist.value;
  gDialog.topRightBorderRadiusXMenulist.value = (trCorner && trCorner.length) ? trCorner[0] : "0px";
  gDialog.topRightBorderRadiusYMenulist.value = (trCorner && trCorner.length == 2) ? trCorner[1] : gDialog.topRightBorderRadiusXMenulist.value;
  gDialog.bottomLeftBorderRadiusXMenulist.value = (blCorner && blCorner.length) ? blCorner[0] : "0px";
  gDialog.bottomLeftBorderRadiusYMenulist.value = (blCorner && blCorner.length == 2) ? blCorner[1] : gDialog.bottomLeftBorderRadiusXMenulist.value;
  gDialog.bottomRightBorderRadiusXMenulist.value = (brCorner && brCorner.length) ? brCorner[0] : "0px";
  gDialog.bottomRightBorderRadiusYMenulist.value = (brCorner && brCorner.length == 2) ? brCorner[1] : gDialog.bottomRightBorderRadiusXMenulist.value;

  gDialog.topLeftBorderRadiusXMenulist.parentNode.parentNode.hidden = sameFourCorners;
  gDialog.topRightBorderRadiusXMenulist.parentNode.parentNode.hidden = sameFourCorners;
  gDialog.bottomLeftBorderRadiusXMenulist.parentNode.parentNode.hidden = sameFourCorners;
  gDialog.bottomRightCornerLabel.style.visibility = sameFourCorners ? "hidden" : "visible";
  gDialog.sameFourCornersCheckbox.checked = sameFourCorners;

  var bi = CssInspector.getCascadedValue(aRuleset, "-moz-border-image");
  var hasBorderImage = (bi && bi != "none");
  gDialog.useImageAsBorderCheckbox.checked = hasBorderImage
  gDialog.useImageAsBorderVbox.hidden = !hasBorderImage;
  var parsedBi = CssInspector.parseBorderImage(bi);
  gDialog.borderImageURLTextbox.value = parsedBi ? MakeAbsoluteUrl(parsedBi.url) : "";
  gDialog.topEdgeSlicingTextbox.value    = 0;
  gDialog.leftEdgeSlicingTextbox.value   = 0;
  gDialog.rightEdgeSlicingTextbox.value  = 0;
  gDialog.bottomEdgeSlicingTextbox.value = 0;
  gDialog.borderSliceLeftWidthMenulist.value = "";
  gDialog.borderSliceRightWidthMenulist.value = "";
  gDialog.borderSliceTopWidthMenulist.value = "";
  gDialog.borderSliceBottomWidthMenulist.value = "";
  if (parsedBi) {
    LoadBorderImage();
    switch (parsedBi.offsets.length) {
      case 1:
        gDialog.topEdgeSlicingTextbox.value = parsedBi.offsets[0];
        gDialog.leftEdgeSlicingTextbox.value = parsedBi.offsets[0];
        gDialog.rightEdgeSlicingTextbox.value = parsedBi.offsets[0];
        gDialog.bottomEdgeSlicingTextbox.value = parsedBi.offsets[0];
        break;
      case 2:
        gDialog.topEdgeSlicingTextbox.value = parsedBi.offsets[0];
        gDialog.leftEdgeSlicingTextbox.value = parsedBi.offsets[1];
        gDialog.rightEdgeSlicingTextbox.value = parsedBi.offsets[1];
        gDialog.bottomEdgeSlicingTextbox.value = parsedBi.offsets[0];
        break;
      case 3:
        gDialog.topEdgeSlicingTextbox.value = parsedBi.offsets[0];
        gDialog.leftEdgeSlicingTextbox.value = parsedBi.offsets[1];
        gDialog.rightEdgeSlicingTextbox.value = parsedBi.offsets[1];
        gDialog.bottomEdgeSlicingTextbox.value = parsedBi.offsets[2];
        break;
      case 4:
        gDialog.topEdgeSlicingTextbox.value = parsedBi.offsets[0];
        gDialog.leftEdgeSlicingTextbox.value = parsedBi.offsets[3];
        gDialog.rightEdgeSlicingTextbox.value = parsedBi.offsets[1];
        gDialog.bottomEdgeSlicingTextbox.value = parsedBi.offsets[2];
        break;
      default: break; // should never happen
    }
    switch (parsedBi.widths.length) {
      case 1:
        gDialog.borderSliceTopWidthMenulist.value = parsedBi.widths[0];
        gDialog.borderSliceLeftWidthMenulist.value = parsedBi.widths[0];
        gDialog.borderSliceRightWidthMenulist.value = parsedBi.widths[0];
        gDialog.borderSliceBottomWidthMenulist.value = parsedBi.widths[0];
        break;
      case 2:
        gDialog.borderSliceTopWidthMenulist.value = parsedBi.widths[0];
        gDialog.borderSliceLeftWidthMenulist.value = parsedBi.widths[1];
        gDialog.borderSliceRightWidthMenulist.value = parsedBi.widths[1];
        gDialog.borderSliceBottomWidthMenulist.value = parsedBi.widths[0];
        break;
      case 3:
        gDialog.borderSliceTopWidthMenulist.value = parsedBi.widths[0];
        gDialog.borderSliceLeftWidthMenulist.value = parsedBi.widths[1];
        gDialog.borderSliceRightWidthMenulist.value = parsedBi.widths[1];
        gDialog.borderSliceBottomWidthMenulist.value = parsedBi.widths[2];
        break;
      case 4:
        gDialog.borderSliceTopWidthMenulist.value = parsedBi.widths[0];
        gDialog.borderSliceLeftWidthMenulist.value = parsedBi.widths[3];
        gDialog.borderSliceRightWidthMenulist.value = parsedBi.widths[1];
        gDialog.borderSliceBottomWidthMenulist.value = parsedBi.widths[2];
        break;
      default: break; // should never happen
    }
    MakeRelativeUrl();
    gDialog.borderImageFromTop.setAttribute("top", 15 + parseFloat(gDialog.topEdgeSlicingTextbox.value));
    gDialog.borderImageFromLeft.setAttribute("left", 15 + parseFloat(gDialog.leftEdgeSlicingTextbox.value));
    gDialog.borderImageFromRight.setAttribute("right", 15 + parseFloat(gDialog.rightEdgeSlicingTextbox.value));
    gDialog.borderImageFromBottom.setAttribute("bottom", 15 + parseFloat(gDialog.bottomEdgeSlicingTextbox.value));
  }
}

function ToggleSameBorderOnFourEdges(aElt)
{
  var sameOnFourEdges = aElt.checked;
  if (sameOnFourEdges) {
    var bbc = gDialog.borderBottomColorpicker.color;
    var bbs = gDialog.borderBottomStyleMenulist.value;
    var bbw = gDialog.borderBottomWidthMenulist.value;

    gDialog.borderTopColorpicker.color = bbc;
    gDialog.borderLeftColorpicker.color = bbc;
    gDialog.borderRightColorpicker.color = bbc;

    gDialog.borderTopStyleMenulist.value = bbs;
    gDialog.borderLeftStyleMenulist.value = bbs;
    gDialog.borderRightStyleMenulist.value = bbs;

    gDialog.borderTopWidthMenulist.value = bbw;
    gDialog.borderLeftWidthMenulist.value = bbw;
    gDialog.borderRightWidthMenulist.value = bbw;
    var toApply = [
                    {
                      property: "border-top-color",
                      value: bbc
                    },
                    {
                      property: "border-left-color",
                      value: bbc
                    },
                    {
                      property: "border-right-color",
                      value: bbc
                    },
                    {
                      property: "border-top-style",
                      value: bbs
                    },
                    {
                      property: "border-left-style",
                      value: bbs
                    },
                    {
                      property: "border-right-style",
                      value: bbs
                    },
                    {
                      property: "border-top-width",
                      value: bbw
                    },
                    {
                      property: "border-left-width",
                      value: bbw
                    },
                    {
                      property: "border-right-width",
                      value: bbw
                    }
                  ];
    ApplyStyles(toApply);
  }
  gDialog.borderTopColorpicker.parentNode.hidden = sameOnFourEdges;
  gDialog.borderLeftColorpicker.parentNode.hidden = sameOnFourEdges;
  gDialog.borderRightColorpicker.parentNode.hidden = sameOnFourEdges;
  gDialog.borderBottomLabel.style.visibility = (sameOnFourEdges ? "hidden" : "visible");
}

function ApplyBorderRadius(aElt)
{
  var id = aElt.id;
  var elts = [];
  var property = "";
  switch (id) {
    case "topLeftBorderRadiusXMenulist":
    case "topLeftBorderRadiusYMenulist":
      elts.push("topLeftBorderRadiusXMenulist");
      elts.push("topLeftBorderRadiusYMenulist");
      property = "border-top-left-radius";
      break;
    case "topRightBorderRadiusXMenulist":
    case "topRightBorderRadiusYMenulist":
      elts.push("topRightBorderRadiusXMenulist");
      elts.push("topRightBorderRadiusYMenulist");
      property = "border-top-right-radius";
      break;
    case "bottomLeftBorderRadiusXMenulist":
    case "bottomLeftBorderRadiusYMenulist":
      elts.push("bottomLeftBorderRadiusXMenulist");
      elts.push("bottomLeftBorderRadiusYMenulist");
      property = "border-bottom-left-radius";
      break;
    case "bottomRightBorderRadiusXMenulist":
    case "bottomRightBorderRadiusYMenulist":
      elts.push("bottomRightBorderRadiusXMenulist");
      elts.push("bottomRightBorderRadiusYMenulist");
      property = "border-bottom-right-radius";
      break;
  }
  var val1    = gDialog[elts[0]].value;
  var val2    = (gDialog[elts[1]].value ? "/ " + gDialog[elts[1]].value : "");
  var val2bis = (gDialog[elts[1]].value ? gDialog[elts[1]].value : "");
  if (gDialog.sameFourCornersCheckbox.checked)
    ApplyStyles([
                  {
                    property: "border-radius",
                    value: val1 + val2
                  }
                ]);
  else
    ApplyStyles([
                  {
                    property: property,
                    value: val1 + val2bis
                  }
                ]);
}

function ToggleSameFourCorners(aElt)
{
  var sameFourCorners = aElt.checked;
  if (sameFourCorners) {
    var brCX = gDialog.bottomRightBorderRadiusXMenulist.value;
    var brCY = gDialog.bottomRightBorderRadiusYMenulist.value;
    gDialog.topLeftBorderRadiusXMenulist.value = brCX;
    gDialog.topRightBorderRadiusXMenulist.value = brCX;
    gDialog.bottomLeftBorderRadiusXMenulist.value = brCX;
    gDialog.topLeftBorderRadiusYMenulist.value = brCY;
    gDialog.topRightBorderRadiusYMenulist.value = brCY;
    gDialog.bottomLeftBorderRadiusYMenulist.value = brCY;
    var str = brCX;
    str += ((str || brCY) ? " " + brCY : "");
    ApplyStyles([
                  {
                    property: "border-radius",
                    value: str.trim()
                  }
                ]);
  }
  gDialog.topLeftBorderRadiusXMenulist.parentNode.parentNode.hidden = sameFourCorners;
  gDialog.topRightBorderRadiusXMenulist.parentNode.parentNode.hidden = sameFourCorners;
  gDialog.bottomLeftBorderRadiusXMenulist.parentNode.parentNode.hidden = sameFourCorners;
  gDialog.bottomRightCornerLabel.style.visibility = sameFourCorners ? "hidden" : "visible";
}

function ToggleImageAsBorder(aElt)
{
  var ok = aElt.checked;
  gDialog.useImageAsBorderVbox.hidden = !ok;
  if (!ok) {
    ApplyStyles([
                  {
                    property: "-moz-border-image",
                    value: ""
                  }
                ]);
  }
}

function MakeRelativeUrl()
{
  var spec = gDialog.borderImageURLTextbox.value;
  var docUrl = EditorUtils.getDocumentUrl();
  var docUrlScheme = UrlUtils.getScheme(docUrl);
  if (docUrlScheme && docUrlScheme != "resource") {
    spec = UrlUtils.makeRelativeUrl(spec);
    gDialog.borderImageURLTextbox.value = spec;
  }
}

function MakeAbsoluteUrl(spec)
{
  var docUrl = EditorUtils.getDocumentUrl();
  var docUrlScheme = UrlUtils.getScheme(docUrl);
  if (docUrlScheme && docUrlScheme != "resource") {
    spec = UrlUtils.makeAbsoluteUrl(spec);
  }
  return spec;
}

function LoadBorderImage()
{
  gDialog.borderImagePreviewBox.hidden = false;
  // reset all
  gDialog.topEdgeSlicingTextbox.value    = 0;
  gDialog.leftEdgeSlicingTextbox.value   = 0;
  gDialog.rightEdgeSlicingTextbox.value  = 0;
  gDialog.bottomEdgeSlicingTextbox.value = 0;

  gDialog.borderImageFromTop.setAttribute("top", 15);
  gDialog.borderImageFromLeft.setAttribute("left", 15);
  gDialog.borderImageFromRight.setAttribute("right", 15);
  gDialog.borderImageFromBottom.setAttribute("bottom", 15);
  gDialog.borderImagePreview.setAttribute("src", gDialog.borderImageURLTextbox.value);
}

function ErrorLoadingBorderImage()
{
  gDialog.borderImagePreview.setAttribute("src", "");
  gDialog.borderImagePreviewBox.hidden = true;
}

function SizeBorderImageRulers(aElt)
{
  var w = aElt.boxObject.width;
  var h = aElt.boxObject.height;
  gDialog.borderImageFromTop.style.width = (w + 30) + "px";
  gDialog.borderImageFromBottom.style.width = (w + 30) + "px";
  gDialog.borderImageFromLeft.style.height = (h + 30) + "px";
  gDialog.borderImageFromRight.style.height = (h + 30) + "px";
}

var gMoving = false;
var gX, gY;
var gOriginal;
function StartMovingBorderImageSliceEdge(aEvent, aElt, aEdge)
{
  gMoving = true;
  gX = aEvent.clientX;
  gY = aEvent.clientY;
  gOriginal = aElt.getAttribute(aEdge);
  aElt.setCapture(false);
  aElt.className = "moving";
}

function MoveBorderImageSliceEdge(aEvent, aElt, aEdge)
{
  if (!gMoving)
    return;
  var x = aEvent.clientX
  var y = aEvent.clientY;
  var diff;
  switch (aEdge)
  {
    case "top":    diff = y - gY; break;
    case "left":   diff = x - gX; break;
    case "right":  diff = gX - x; break;
    case "bottom": diff = gY - y; break;
    default: break; //should never happen
  }
  value = parseFloat(gOriginal) + diff;
  if (value < 15)
    value = 15;
  switch (aEdge)
  {
    case "top":    
    case "bottom": value = Math.min(value, gDialog.borderImagePreview.boxObject.height + 15); break;

    case "left":
    case "right":  value = Math.min(value, gDialog.borderImagePreview.boxObject.width + 15); break;
    default: break; //should never happen
  }
  aElt.setAttribute(aEdge, value);
  gDialog[aEdge + "EdgeSlicingTextbox"].value = value - 15;
  switch (aEdge) {
    case "top":
      gDialog.borderSliceTopWidthMenulist.value = (value -15) + "px";
      break;
    case "right":
      gDialog.borderSliceRightWidthMenulist.value = (value -15) + "px";
      break;
    case "bottom":
      gDialog.borderSliceBottomWidthMenulist.value = (value -15) + "px";
      break;
    case "left":
      gDialog.borderSliceLeftWidthMenulist.value = (value -15) + "px";
      break;
  }
}

function StopMovingBorderImageSliceEdge(aEvent, aElt, aEdge)
{
  aElt.releaseCapture();
  aElt.className = "";
  gMoving = false;
  ApplyBorderImage(false);
}

function ApplyBorderImageSliceChangeFromTextbox(aElt)
{
  var id = aElt.id;
  var value = aElt.value;
  switch (id) {
    case "leftEdgeSlicingTextbox":
      gDialog.borderImageFromLeft.setAttribute("left", 15 + Number(value));
      gDialog.borderSliceLeftWidthMenulist.value = value + "px";
      break;
    case "rightEdgeSlicingTextbox":
      gDialog.borderImageFromRight.setAttribute("right", 15 + Number(value));
      gDialog.borderSliceRightWidthMenulist.value = value + "px";
      break;
    case "topEdgeSlicingTextbox":
      gDialog.borderImageFromTop.setAttribute("top", 15 + Number(value));
      gDialog.borderSliceRightWidthMenulist.value = value + "px";
      break;
    case "bottomEdgeSlicingTextbox":
      gDialog.borderImageFromBottom.setAttribute("bottom", 15 + Number(value));
      gDialog.borderSliceRightWidthMenulist.value = value + "px";
      break;
    default: break; // should never happen
  }
  ApplyBorderImage(false);
}

function ApplyBorderImage(aZeroWidths)
{
  var url = gDialog.borderImageURLTextbox.value;

  var leftOffset    = gDialog.leftEdgeSlicingTextbox.value;
  var rightOffset   = gDialog.rightEdgeSlicingTextbox.value;
  var topOffset     = gDialog.topEdgeSlicingTextbox.value;
  var bottomOffset = gDialog.bottomEdgeSlicingTextbox.value;

  function ZeroTextboxIfNeededed(id)
  {
    if (gDialog[id].value == "")
      gDialog[id].value = "0px";
  }
  if (aZeroWidths) {
	  ZeroTextboxIfNeededed("borderSliceLeftWidthMenulist");
	  ZeroTextboxIfNeededed("borderSliceRightWidthMenulist");
	  ZeroTextboxIfNeededed("borderSliceTopWidthMenulist");
	  ZeroTextboxIfNeededed("borderSliceBottomWidthMenulist");
  }
  var leftWidth   = gDialog.borderSliceLeftWidthMenulist.value;
  var rightWidth  = gDialog.borderSliceRightWidthMenulist.value;
  var topWidth    = gDialog.borderSliceTopWidthMenulist.value;
  var bottomWidth = gDialog.borderSliceBottomWidthMenulist.value;

  var repeatHoriz = gDialog.horizontalBorderImageRepeatMenulist.value;
  var repeatVert  = gDialog.VerticalBorderImageRepeatMenulist.value;

  str = "url('" + url + "') " +
        topOffset + " " + rightOffset + " " + bottomOffset + " " + leftOffset +
        (topWidth ? " / " + topWidth + " " + rightWidth + " " + bottomWidth + " " + leftWidth : "") +
        " " + gDialog.horizontalBorderImageRepeatMenulist.value + " " +
        gDialog.VerticalBorderImageRepeatMenulist.value;
  ApplyStyles( [
                 {
                  property: "-moz-border-image",
                  value: str
                 }
               ]);
}

RegisterIniter(ShadowsSectionIniter);

function ShadowsSectionIniter(aElt, aRuleset)
{
  deleteAllChildren(gDialog.textShadowRichlistbox);
  var ts = CssInspector.getCascadedValue(aRuleset, "text-shadow");
  var shadows = CssInspector.parseTextShadows(ts);
  for (var i = 0; i < shadows.length; i++) {
    var s = shadows[i];
    var item = document.createElement("richlistitem");
    item.className = s.none ? "noneTextShadow" : "shadowTextShadow";
    gDialog.textShadowRichlistbox.appendChild(item);
    if (!s.none) {
      item.color = s.color;
      item.offsetX = s.offsetX;
      item.offsetY = s.offsetY;
      item.blurRadius = s.blurRadius;
    }
  }

  deleteAllChildren(gDialog.boxShadowRichlistbox);
  var bs = CssInspector.getCascadedValue(aRuleset, "box-shadow");
  var shadows = CssInspector.parseBoxShadows(bs);
  for (var i = 0; i < shadows.length; i++) {
    var s = shadows[i];
    var item = document.createElement("richlistitem");
    item.className = s.none ? "noneBoxShadow" : "shadowBoxShadow";
    gDialog.boxShadowRichlistbox.appendChild(item);
    if (!s.none) {
      item.inset = s.inset;
      item.color = s.color;
      item.offsetX = s.offsetX;
      item.offsetY = s.offsetY;
      item.blurRadius = s.blurRadius;
      item.spreadRadius = s.spreadRadius;
    }
  }
}

function OnTextShadowSelect(aElt)
{
  var item = aElt.selectedItem;
  SetEnabledElement(gDialog.removeTextShadowButton, (item != null));    
}

function AddTextShadow(aEvent)
{
  var type = aEvent.originalTarget.value;
  var item = document.createElement("richlistitem");
  item.className = type + "TextShadow";
  gDialog.textShadowRichlistbox.appendChild(item);
  UpdateTextShadowUI();
  ReapplyTextShadows();
}

function DeleteTextShadow()
{
  var item = gDialog.textShadowRichlistbox.selectedItem;
  if (!item) return; // sanity check
  item.parentNode.removeChild(item);
  UpdateTextShadowUI();
  ReapplyTextShadows();
}

function ReapplyTextShadows()
{
  var items = gDialog.textShadowRichlistbox.querySelectorAll("richlistitem");
  var shadows = [];
  for (var i = 0; i < items.length; i++) {
    var item = items[i];
    var s;
    if (!item.none) {
      s = item.color + " " + item.offsetX + " " + item.offsetY + " " + item.blurRadius;
    }
    else
      s = "none";
    shadows.push(s);
  }
  ApplyStyles([{
                 property: "text-shadow",
                 value: shadows.join(",")
               }])
}

function UpdateTextShadowUI()
{
  var isEmpty = (gDialog.textShadowRichlistbox.itemCount == 0);
  var isNone = !isEmpty &&
                    (gDialog.textShadowRichlistbox.getItemAtIndex(0).className == "noneTextShadow");
  SetEnabledElement(gDialog.addTextShadowButton, !isNone);
  SetEnabledElement(gDialog.removeTextShadowButton, false);
  
  SetEnabledElement(gDialog.shadowTextShadowMenuitem, isEmpty || !isNone);
  SetEnabledElement(gDialog.noneTextShadowMenuitem, isEmpty);
}

function OnBoxShadowSelect(aElt)
{
  var item = aElt.selectedItem;
  SetEnabledElement(gDialog.removeBoxShadowButton, (item != null));    
}

function AddBoxShadow(aEvent)
{
  var type = aEvent.originalTarget.value;
  var item = document.createElement("richlistitem");
  item.className = type + "BoxShadow";
  gDialog.boxShadowRichlistbox.appendChild(item);
  UpdateBoxShadowUI();
  ReapplyBoxShadows();
}

function DeleteBoxShadow()
{
  var item = gDialog.boxShadowRichlistbox.selectedItem;
  if (!item) return; // sanity check
  item.parentNode.removeChild(item);
  UpdateBoxShadowUI();
  ReapplyBoxShadows();
}

function ReapplyBoxShadows()
{
  var items = gDialog.boxShadowRichlistbox.querySelectorAll("richlistitem");
  var shadows = [];
  for (var i = 0; i < items.length; i++) {
    var item = items[i];
    var s;
    if (!item.none) {
	    s = (item.inset ? "inset " : "");
	    s += item.offsetX + " " + item.offsetY + " " + item.blurRadius + " " +
	         item.spreadRadius + " " + item.color;
    }
    else
     s = "none";
    shadows.push(s);
  }
  ApplyStyles([{
                 property: "box-shadow",
                 value: shadows.join(",")
               }])
}

function UpdateBoxShadowUI()
{
  var isEmpty = (gDialog.boxShadowRichlistbox.itemCount == 0);
  var isNone = !isEmpty &&
                    (gDialog.boxShadowRichlistbox.getItemAtIndex(0).className == "noneBoxShadow");
  SetEnabledElement(gDialog.addBoxShadowButton, !isNone);
  SetEnabledElement(gDialog.removeBoxShadowButton, false);
  
  SetEnabledElement(gDialog.shadowBoxShadowMenuitem, isEmpty || !isNone);
  SetEnabledElement(gDialog.noneBoxShadowMenuitem, isEmpty);
}
RegisterIniter(ListsSectionIniter);

function ListsSectionIniter(aElt, aRuleset)
{
  var lst = CssInspector.getCascadedValue(aRuleset, "list-style-type");
  gDialog.listStyleTypeMenulist.value = lst;

  var lsp = CssInspector.getCascadedValue(aRuleset, "list-style-position");
  CheckToggle(gDialog.insideListStylePositionButton,    lsp == "inside");
  CheckToggle(gDialog.outsideListStylePositionButton,   lsp == "outside");

  var lsi = CssInspector.getCascadedValue(aRuleset, "list-style-image");
  gDialog.listStyleImageURLTextbox.value = lsi;
}

function LoadListStyleImage()
{
  ApplyStyles( [
							   {
							     property: "list-style-image",
                   value: 'url("' + gDialog.listStyleImageURLTextbox.value + '")'
							   }
               ]);
}
RegisterIniter(TransformsSectionIniter);

function TransformsSectionIniter(aElt, aRuleset)
{
  var mto = CssInspector.getCascadedValue(aRuleset, "-moz-transform-origin");
  var mtoArray = mto.split(" ");
  switch (mtoArray.length) {
    case 1:
      gDialog.transformOriginXMenulist.value = mtoArray[0];
      gDialog.transformOriginYMenulist.value = "";
      break;
    case 2:
      gDialog.transformOriginXMenulist.value = mtoArray[0];
      gDialog.transformOriginYMenulist.value = mtoArray[1];
      break;
    default:
      gDialog.transformOriginXMenulist.value = "";
      gDialog.transformOriginYMenulist.value = "";
      break;
  }

  deleteAllChildren(gDialog.transformsRichlistbox);
  var mt = CssInspector.getCascadedValue(aRuleset, "-moz-transform");
  var transformsArray = [];
  if (mt) {
   var mtArray = mt.split(")");
   for (var i = 0; i < mtArray.length; i++) {
    var transformation = mtArray[i].trim();
    var parsed = transformation.match(/([a-z0-9]*)\((.*)/i);
    if (parsed) {
      var t = parsed[1];
      var values = parsed[2];
      var valuesArray = values.split(",");
      valuesArray = valuesArray.map(function(s){return s.trim();})
      transformsArray.push( {
                              transformation: t,
                              values: valuesArray
                            });
    }
   }
  }

  for (var i = 0; i < transformsArray.length; i++) {
    var t = transformsArray[i];
    var item = document.createElement("richlistitem");
    switch (t.transformation.toLowerCase()) {
      case "rotate":
        item.className = "rotateTransform";
        if (i >= gDialog.transformsRichlistbox.itemCount)
          gDialog.transformsRichlistbox.appendChild(item);
        else if (gDialog.transformsRichlistbox.getItemAtIndex(i).className != "rotateTransform")
          gDialog.transformsRichlistbox.replaceChild(gDialog.transformsRichlistbox.getItemAtIndex(i), item);
        else
          item = gDialog.transformsRichlistbox.getItemAtIndex(i);
        item.value = parseFloat(t.values[0]);
        break;
      case "translate":
        item.className = "translateTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.horizontally = t.values[0];
        if (t.values.length > 1)
          item.vertically = t.values[1];
        else
          item.vertically = "";
        break;
      case "translatex":
        item.className = "translateTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.horizontally = t.values[0];
        item.vertically = "";
        break;
      case "translatey":
        item.className = "translateTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.horizontally = "";
        item.vertically = t.values[0];
        break;
      case "skew":
        item.className = "skewTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.valueX = t.values[0];
        item.valueY = t.values[1];
        break;
      case "skewx":
        item.className = "skewTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.valueX = t.values[0];
        item.valueY = "";
        break;
      case "skewy":
        item.className = "skewTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.valueX = "";
        item.valueY = t.values[0];
        break;
      case "scale":
        item.className = "scaleTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.horizontally = t.values[0];
        item.vertically = t.values[1];
        break;
      case "scalex":
        item.className = "scaleTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.horizontally = t.values[0];
        item.vertically = "";
        break;
      case "scaley":
        item.className = "scaleTransform";
        gDialog.transformsRichlistbox.appendChild(item);
        item.horizontally = "";
        item.vertically = t.values[0];
        break;
      default: break;
    }
  }
}

function OnTransformSelect(aElt)
{
  var item = aElt.selectedItem;
  SetEnabledElement(gDialog.removeTransformButton, (item != null));    
}

function AddTransform(aEvent)
{
  var type = aEvent.originalTarget.value;
  var item = document.createElement("richlistitem");
  item.className = type + "Transform";
  gDialog.transformsRichlistbox.appendChild(item);
}

function DeleteTransform()
{
  var item = gDialog.transformsRichlistbox.selectedItem;
  if (!item) return; // sanity check
  item.parentNode.removeChild(item);
  SetEnabledElement(gDialog.removeTransformButton, (gDialog.transformsRichlistbox.itemCount != 0));
  ReapplyTransforms();
}

function ReapplyTransforms()
{
  var items = gDialog.transformsRichlistbox.querySelectorAll("richlistitem");
  var transforms = [];
  for (var i = 0; i < items.length; i++) {
    var item = items[i];
    switch (item.className) {
      case "rotateTransform":
        transforms.push( "rotate(" + item.value + "deg)");
        break;
      case "translateTransform":
        {
          var h = item.horizontally;
          var v = item.vertically;
          if (h && v && parseFloat(h) && parseFloat(v))
            transforms.push("translate(" + h + ", " + v + ")");
          else if (h && parseFloat(h))
            transforms.push("translateX(" + h + ")");
          else if (v && parseFloat(v))
            transforms.push("translateY(" + v + ")");
        }
        break;
      case "skewTransform":
        {
          var x = item.valueX;
          var y = item.valueY;
          if (x && y && parseFloat(x) && parseFloat(y))
            transforms.push("skew(" + x + "deg, " + y + "deg)");
          else if (x && parseFloat(x))
            transforms.push("skewX(" + x + "deg)");
          else if (y && parseFloat(y))
            transforms.push("skewY(" + y + "deg)");
        }
        break;
      case "scaleTransform":
        {
          var h = item.horizontally;
          var v = item.vertically;
          if (h && v && parseFloat(h) && parseFloat(v))
            transforms.push("scale(" + h + ", " + v + ")");
          else if (h && parseFloat(h))
            transforms.push("scaleX(" + h + ")");
          else if (v && parseFloat(v))
            transforms.push("scaleY(" + v + ")");
        }
        break;
      default: break;
    }
  }
  ApplyStyles([
                {
                  property: "-moz-transform",
                  value: transforms.join(" ")
                },
                {
                  property: "-moz-transform-origin",
                  value: (gDialog.transformOriginXMenulist.value || gDialog.transformOriginYMenulist.value)
                           ? (gDialog.transformOriginXMenulist.value + " " + gDialog.transformOriginYMenulist.value).trim()
                           : ""
                }
              ]);
}


// === Sylvester ===
// Vector and Matrix mathematics modules for JavaScript
// Copyright (c) 2007 James Coglan
// 
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

var Sylvester = {
  version: '0.1.3',
  precision: 1e-6
};

function Vector() {}
Vector.prototype = {

  // Returns element i of the vector
  e: function(i) {
    return (i < 1 || i > this.elements.length) ? null : this.elements[i-1];
  },

  // Returns the number of elements the vector has
  dimensions: function() {
    return this.elements.length;
  },

  // Returns the modulus ('length') of the vector
  modulus: function() {
    return Math.sqrt(this.dot(this));
  },

  // Returns true iff the vector is equal to the argument
  eql: function(vector) {
    var n = this.elements.length;
    var V = vector.elements || vector;
    if (n != V.length) { return false; }
    do {
      if (Math.abs(this.elements[n-1] - V[n-1]) > Sylvester.precision) { return false; }
    } while (--n);
    return true;
  },

  // Returns a copy of the vector
  dup: function() {
    return Vector.create(this.elements);
  },

  // Maps the vector to another vector according to the given function
  map: function(fn) {
    var elements = [];
    this.each(function(x, i) {
      elements.push(fn(x, i));
    });
    return Vector.create(elements);
  },
  
  // Calls the iterator for each element of the vector in turn
  each: function(fn) {
    var n = this.elements.length, k = n, i;
    do { i = k - n;
      fn(this.elements[i], i+1);
    } while (--n);
  },

  // Returns a new vector created by normalizing the receiver
  toUnitVector: function() {
    var r = this.modulus();
    if (r === 0) { return this.dup(); }
    return this.map(function(x) { return x/r; });
  },

  // Returns the angle between the vector and the argument (also a vector)
  angleFrom: function(vector) {
    var V = vector.elements || vector;
    var n = this.elements.length, k = n, i;
    if (n != V.length) { return null; }
    var dot = 0, mod1 = 0, mod2 = 0;
    // Work things out in parallel to save time
    this.each(function(x, i) {
      dot += x * V[i-1];
      mod1 += x * x;
      mod2 += V[i-1] * V[i-1];
    });
    mod1 = Math.sqrt(mod1); mod2 = Math.sqrt(mod2);
    if (mod1*mod2 === 0) { return null; }
    var theta = dot / (mod1*mod2);
    if (theta < -1) { theta = -1; }
    if (theta > 1) { theta = 1; }
    return Math.acos(theta);
  },

  // Returns true iff the vector is parallel to the argument
  isParallelTo: function(vector) {
    var angle = this.angleFrom(vector);
    return (angle === null) ? null : (angle <= Sylvester.precision);
  },

  // Returns true iff the vector is antiparallel to the argument
  isAntiparallelTo: function(vector) {
    var angle = this.angleFrom(vector);
    return (angle === null) ? null : (Math.abs(angle - Math.PI) <= Sylvester.precision);
  },

  // Returns true iff the vector is perpendicular to the argument
  isPerpendicularTo: function(vector) {
    var dot = this.dot(vector);
    return (dot === null) ? null : (Math.abs(dot) <= Sylvester.precision);
  },

  // Returns the result of adding the argument to the vector
  add: function(vector) {
    var V = vector.elements || vector;
    if (this.elements.length != V.length) { return null; }
    return this.map(function(x, i) { return x + V[i-1]; });
  },

  // Returns the result of subtracting the argument from the vector
  subtract: function(vector) {
    var V = vector.elements || vector;
    if (this.elements.length != V.length) { return null; }
    return this.map(function(x, i) { return x - V[i-1]; });
  },

  // Returns the result of multiplying the elements of the vector by the argument
  multiply: function(k) {
    return this.map(function(x) { return x*k; });
  },

  x: function(k) { return this.multiply(k); },

  // Returns the scalar product of the vector with the argument
  // Both vectors must have equal dimensionality
  dot: function(vector) {
    var V = vector.elements || vector;
    var i, product = 0, n = this.elements.length;
    if (n != V.length) { return null; }
    do { product += this.elements[n-1] * V[n-1]; } while (--n);
    return product;
  },

  // Returns the vector product of the vector with the argument
  // Both vectors must have dimensionality 3
  cross: function(vector) {
    var B = vector.elements || vector;
    if (this.elements.length != 3 || B.length != 3) { return null; }
    var A = this.elements;
    return Vector.create([
      (A[1] * B[2]) - (A[2] * B[1]),
      (A[2] * B[0]) - (A[0] * B[2]),
      (A[0] * B[1]) - (A[1] * B[0])
    ]);
  },

  // Returns the (absolute) largest element of the vector
  max: function() {
    var m = 0, n = this.elements.length, k = n, i;
    do { i = k - n;
      if (Math.abs(this.elements[i]) > Math.abs(m)) { m = this.elements[i]; }
    } while (--n);
    return m;
  },

  // Returns the index of the first match found
  indexOf: function(x) {
    var index = null, n = this.elements.length, k = n, i;
    do { i = k - n;
      if (index === null && this.elements[i] == x) {
        index = i + 1;
      }
    } while (--n);
    return index;
  },

  // Returns a diagonal matrix with the vector's elements as its diagonal elements
  toDiagonalMatrix: function() {
    return Matrix.Diagonal(this.elements);
  },

  // Returns the result of rounding the elements of the vector
  round: function() {
    return this.map(function(x) { return Math.round(x); });
  },

  // Returns a copy of the vector with elements set to the given value if they
  // differ from it by less than Sylvester.precision
  snapTo: function(x) {
    return this.map(function(y) {
      return (Math.abs(y - x) <= Sylvester.precision) ? x : y;
    });
  },

  // Returns the vector's distance from the argument, when considered as a point in space
  distanceFrom: function(obj) {
    if (obj.anchor) { return obj.distanceFrom(this); }
    var V = obj.elements || obj;
    if (V.length != this.elements.length) { return null; }
    var sum = 0, part;
    this.each(function(x, i) {
      part = x - V[i-1];
      sum += part * part;
    });
    return Math.sqrt(sum);
  },

  // Returns true if the vector is point on the given line
  liesOn: function(line) {
    return line.contains(this);
  },

  // Return true iff the vector is a point in the given plane
  liesIn: function(plane) {
    return plane.contains(this);
  },

  // Rotates the vector about the given object. The object should be a 
  // point if the vector is 2D, and a line if it is 3D. Be careful with line directions!
  rotate: function(t, obj) {
    var V, R, x, y, z;
    switch (this.elements.length) {
      case 2:
        V = obj.elements || obj;
        if (V.length != 2) { return null; }
        R = Matrix.Rotation(t).elements;
        x = this.elements[0] - V[0];
        y = this.elements[1] - V[1];
        return Vector.create([
          V[0] + R[0][0] * x + R[0][1] * y,
          V[1] + R[1][0] * x + R[1][1] * y
        ]);
        break;
      case 3:
        if (!obj.direction) { return null; }
        var C = obj.pointClosestTo(this).elements;
        R = Matrix.Rotation(t, obj.direction).elements;
        x = this.elements[0] - C[0];
        y = this.elements[1] - C[1];
        z = this.elements[2] - C[2];
        return Vector.create([
          C[0] + R[0][0] * x + R[0][1] * y + R[0][2] * z,
          C[1] + R[1][0] * x + R[1][1] * y + R[1][2] * z,
          C[2] + R[2][0] * x + R[2][1] * y + R[2][2] * z
        ]);
        break;
      default:
        return null;
    }
  },

  // Returns the result of reflecting the point in the given point, line or plane
  reflectionIn: function(obj) {
    if (obj.anchor) {
      // obj is a plane or line
      var P = this.elements.slice();
      var C = obj.pointClosestTo(P).elements;
      return Vector.create([C[0] + (C[0] - P[0]), C[1] + (C[1] - P[1]), C[2] + (C[2] - (P[2] || 0))]);
    } else {
      // obj is a point
      var Q = obj.elements || obj;
      if (this.elements.length != Q.length) { return null; }
      return this.map(function(x, i) { return Q[i-1] + (Q[i-1] - x); });
    }
  },

  // Utility to make sure vectors are 3D. If they are 2D, a zero z-component is added
  to3D: function() {
    var V = this.dup();
    switch (V.elements.length) {
      case 3: break;
      case 2: V.elements.push(0); break;
      default: return null;
    }
    return V;
  },

  // Returns a string representation of the vector
  inspect: function() {
    return '[' + this.elements.join(', ') + ']';
  },

  // Set vector's elements from an array
  setElements: function(els) {
    this.elements = (els.elements || els).slice();
    return this;
  }
};
  
// Constructor function
Vector.create = function(elements) {
  var V = new Vector();
  return V.setElements(elements);
};

// i, j, k unit vectors
Vector.i = Vector.create([1,0,0]);
Vector.j = Vector.create([0,1,0]);
Vector.k = Vector.create([0,0,1]);

// Random vector of size n
Vector.Random = function(n) {
  var elements = [];
  do { elements.push(Math.random());
  } while (--n);
  return Vector.create(elements);
};

// Vector filled with zeros
Vector.Zero = function(n) {
  var elements = [];
  do { elements.push(0);
  } while (--n);
  return Vector.create(elements);
};



function Matrix() {}
Matrix.prototype = {

  // Returns element (i,j) of the matrix
  e: function(i,j) {
    if (i < 1 || i > this.elements.length || j < 1 || j > this.elements[0].length) { return null; }
    return this.elements[i-1][j-1];
  },

  // Returns row k of the matrix as a vector
  row: function(i) {
    if (i > this.elements.length) { return null; }
    return Vector.create(this.elements[i-1]);
  },

  // Returns column k of the matrix as a vector
  col: function(j) {
    if (j > this.elements[0].length) { return null; }
    var col = [], n = this.elements.length, k = n, i;
    do { i = k - n;
      col.push(this.elements[i][j-1]);
    } while (--n);
    return Vector.create(col);
  },

  // Returns the number of rows/columns the matrix has
  dimensions: function() {
    return {rows: this.elements.length, cols: this.elements[0].length};
  },

  // Returns the number of rows in the matrix
  rows: function() {
    return this.elements.length;
  },

  // Returns the number of columns in the matrix
  cols: function() {
    return this.elements[0].length;
  },

  // Returns true iff the matrix is equal to the argument. You can supply
  // a vector as the argument, in which case the receiver must be a
  // one-column matrix equal to the vector.
  eql: function(matrix) {
    var M = matrix.elements || matrix;
    if (typeof(M[0][0]) == 'undefined') { M = Matrix.create(M).elements; }
    if (this.elements.length != M.length ||
        this.elements[0].length != M[0].length) { return false; }
    var ni = this.elements.length, ki = ni, i, nj, kj = this.elements[0].length, j;
    do { i = ki - ni;
      nj = kj;
      do { j = kj - nj;
        if (Math.abs(this.elements[i][j] - M[i][j]) > Sylvester.precision) { return false; }
      } while (--nj);
    } while (--ni);
    return true;
  },

  // Returns a copy of the matrix
  dup: function() {
    return Matrix.create(this.elements);
  },

  // Maps the matrix to another matrix (of the same dimensions) according to the given function
  map: function(fn) {
    var els = [], ni = this.elements.length, ki = ni, i, nj, kj = this.elements[0].length, j;
    do { i = ki - ni;
      nj = kj;
      els[i] = [];
      do { j = kj - nj;
        els[i][j] = fn(this.elements[i][j], i + 1, j + 1);
      } while (--nj);
    } while (--ni);
    return Matrix.create(els);
  },

  // Returns true iff the argument has the same dimensions as the matrix
  isSameSizeAs: function(matrix) {
    var M = matrix.elements || matrix;
    if (typeof(M[0][0]) == 'undefined') { M = Matrix.create(M).elements; }
    return (this.elements.length == M.length &&
        this.elements[0].length == M[0].length);
  },

  // Returns the result of adding the argument to the matrix
  add: function(matrix) {
    var M = matrix.elements || matrix;
    if (typeof(M[0][0]) == 'undefined') { M = Matrix.create(M).elements; }
    if (!this.isSameSizeAs(M)) { return null; }
    return this.map(function(x, i, j) { return x + M[i-1][j-1]; });
  },

  // Returns the result of subtracting the argument from the matrix
  subtract: function(matrix) {
    var M = matrix.elements || matrix;
    if (typeof(M[0][0]) == 'undefined') { M = Matrix.create(M).elements; }
    if (!this.isSameSizeAs(M)) { return null; }
    return this.map(function(x, i, j) { return x - M[i-1][j-1]; });
  },

  // Returns true iff the matrix can multiply the argument from the left
  canMultiplyFromLeft: function(matrix) {
    var M = matrix.elements || matrix;
    if (typeof(M[0][0]) == 'undefined') { M = Matrix.create(M).elements; }
    // this.columns should equal matrix.rows
    return (this.elements[0].length == M.length);
  },

  // Returns the result of multiplying the matrix from the right by the argument.
  // If the argument is a scalar then just multiply all the elements. If the argument is
  // a vector, a vector is returned, which saves you having to remember calling
  // col(1) on the result.
  multiply: function(matrix) {
    if (!matrix.elements) {
      return this.map(function(x) { return x * matrix; });
    }
    var returnVector = matrix.modulus ? true : false;
    var M = matrix.elements || matrix;
    if (typeof(M[0][0]) == 'undefined') { M = Matrix.create(M).elements; }
    if (!this.canMultiplyFromLeft(M)) { return null; }
    var ni = this.elements.length, ki = ni, i, nj, kj = M[0].length, j;
    var cols = this.elements[0].length, elements = [], sum, nc, c;
    do { i = ki - ni;
      elements[i] = [];
      nj = kj;
      do { j = kj - nj;
        sum = 0;
        nc = cols;
        do { c = cols - nc;
          sum += this.elements[i][c] * M[c][j];
        } while (--nc);
        elements[i][j] = sum;
      } while (--nj);
    } while (--ni);
    var M = Matrix.create(elements);
    return returnVector ? M.col(1) : M;
  },

  x: function(matrix) { return this.multiply(matrix); },

  // Returns a submatrix taken from the matrix
  // Argument order is: start row, start col, nrows, ncols
  // Element selection wraps if the required index is outside the matrix's bounds, so you could
  // use this to perform row/column cycling or copy-augmenting.
  minor: function(a, b, c, d) {
    var elements = [], ni = c, i, nj, j;
    var rows = this.elements.length, cols = this.elements[0].length;
    do { i = c - ni;
      elements[i] = [];
      nj = d;
      do { j = d - nj;
        elements[i][j] = this.elements[(a+i-1)%rows][(b+j-1)%cols];
      } while (--nj);
    } while (--ni);
    return Matrix.create(elements);
  },

  // Returns the transpose of the matrix
  transpose: function() {
    var rows = this.elements.length, cols = this.elements[0].length;
    var elements = [], ni = cols, i, nj, j;
    do { i = cols - ni;
      elements[i] = [];
      nj = rows;
      do { j = rows - nj;
        elements[i][j] = this.elements[j][i];
      } while (--nj);
    } while (--ni);
    return Matrix.create(elements);
  },

  // Returns true iff the matrix is square
  isSquare: function() {
    return (this.elements.length == this.elements[0].length);
  },

  // Returns the (absolute) largest element of the matrix
  max: function() {
    var m = 0, ni = this.elements.length, ki = ni, i, nj, kj = this.elements[0].length, j;
    do { i = ki - ni;
      nj = kj;
      do { j = kj - nj;
        if (Math.abs(this.elements[i][j]) > Math.abs(m)) { m = this.elements[i][j]; }
      } while (--nj);
    } while (--ni);
    return m;
  },

  // Returns the indeces of the first match found by reading row-by-row from left to right
  indexOf: function(x) {
    var index = null, ni = this.elements.length, ki = ni, i, nj, kj = this.elements[0].length, j;
    do { i = ki - ni;
      nj = kj;
      do { j = kj - nj;
        if (this.elements[i][j] == x) { return {i: i+1, j: j+1}; }
      } while (--nj);
    } while (--ni);
    return null;
  },

  // If the matrix is square, returns the diagonal elements as a vector.
  // Otherwise, returns null.
  diagonal: function() {
    if (!this.isSquare) { return null; }
    var els = [], n = this.elements.length, k = n, i;
    do { i = k - n;
      els.push(this.elements[i][i]);
    } while (--n);
    return Vector.create(els);
  },

  // Make the matrix upper (right) triangular by Gaussian elimination.
  // This method only adds multiples of rows to other rows. No rows are
  // scaled up or switched, and the determinant is preserved.
  toRightTriangular: function() {
    var M = this.dup(), els;
    var n = this.elements.length, k = n, i, np, kp = this.elements[0].length, p;
    do { i = k - n;
      if (M.elements[i][i] == 0) {
        for (j = i + 1; j < k; j++) {
          if (M.elements[j][i] != 0) {
            els = []; np = kp;
            do { p = kp - np;
              els.push(M.elements[i][p] + M.elements[j][p]);
            } while (--np);
            M.elements[i] = els;
            break;
          }
        }
      }
      if (M.elements[i][i] != 0) {
        for (j = i + 1; j < k; j++) {
          var multiplier = M.elements[j][i] / M.elements[i][i];
          els = []; np = kp;
          do { p = kp - np;
            // Elements with column numbers up to an including the number
            // of the row that we're subtracting can safely be set straight to
            // zero, since that's the point of this routine and it avoids having
            // to loop over and correct rounding errors later
            els.push(p <= i ? 0 : M.elements[j][p] - M.elements[i][p] * multiplier);
          } while (--np);
          M.elements[j] = els;
        }
      }
    } while (--n);
    return M;
  },

  toUpperTriangular: function() { return this.toRightTriangular(); },

  // Returns the determinant for square matrices
  determinant: function() {
    if (!this.isSquare()) { return null; }
    var M = this.toRightTriangular();
    var det = M.elements[0][0], n = M.elements.length - 1, k = n, i;
    do { i = k - n + 1;
      det = det * M.elements[i][i];
    } while (--n);
    return det;
  },

  det: function() { return this.determinant(); },

  // Returns true iff the matrix is singular
  isSingular: function() {
    return (this.isSquare() && this.determinant() === 0);
  },

  // Returns the trace for square matrices
  trace: function() {
    if (!this.isSquare()) { return null; }
    var tr = this.elements[0][0], n = this.elements.length - 1, k = n, i;
    do { i = k - n + 1;
      tr += this.elements[i][i];
    } while (--n);
    return tr;
  },

  tr: function() { return this.trace(); },

  // Returns the rank of the matrix
  rank: function() {
    var M = this.toRightTriangular(), rank = 0;
    var ni = this.elements.length, ki = ni, i, nj, kj = this.elements[0].length, j;
    do { i = ki - ni;
      nj = kj;
      do { j = kj - nj;
        if (Math.abs(M.elements[i][j]) > Sylvester.precision) { rank++; break; }
      } while (--nj);
    } while (--ni);
    return rank;
  },
  
  rk: function() { return this.rank(); },

  // Returns the result of attaching the given argument to the right-hand side of the matrix
  augment: function(matrix) {
    var M = matrix.elements || matrix;
    if (typeof(M[0][0]) == 'undefined') { M = Matrix.create(M).elements; }
    var T = this.dup(), cols = T.elements[0].length;
    var ni = T.elements.length, ki = ni, i, nj, kj = M[0].length, j;
    if (ni != M.length) { return null; }
    do { i = ki - ni;
      nj = kj;
      do { j = kj - nj;
        T.elements[i][cols + j] = M[i][j];
      } while (--nj);
    } while (--ni);
    return T;
  },

  // Returns the inverse (if one exists) using Gauss-Jordan
  inverse: function() {
    if (!this.isSquare() || this.isSingular()) { return null; }
    var ni = this.elements.length, ki = ni, i, j;
    var M = this.augment(Matrix.I(ni)).toRightTriangular();
    var np, kp = M.elements[0].length, p, els, divisor;
    var inverse_elements = [], new_element;
    // Matrix is non-singular so there will be no zeros on the diagonal
    // Cycle through rows from last to first
    do { i = ni - 1;
      // First, normalise diagonal elements to 1
      els = []; np = kp;
      inverse_elements[i] = [];
      divisor = M.elements[i][i];
      do { p = kp - np;
        new_element = M.elements[i][p] / divisor;
        els.push(new_element);
        // Shuffle of the current row of the right hand side into the results
        // array as it will not be modified by later runs through this loop
        if (p >= ki) { inverse_elements[i].push(new_element); }
      } while (--np);
      M.elements[i] = els;
      // Then, subtract this row from those above it to
      // give the identity matrix on the left hand side
      for (j = 0; j < i; j++) {
        els = []; np = kp;
        do { p = kp - np;
          els.push(M.elements[j][p] - M.elements[i][p] * M.elements[j][i]);
        } while (--np);
        M.elements[j] = els;
      }
    } while (--ni);
    return Matrix.create(inverse_elements);
  },

  inv: function() { return this.inverse(); },

  // Returns the result of rounding all the elements
  round: function() {
    return this.map(function(x) { return Math.round(x); });
  },

  // Returns a copy of the matrix with elements set to the given value if they
  // differ from it by less than Sylvester.precision
  snapTo: function(x) {
    return this.map(function(p) {
      return (Math.abs(p - x) <= Sylvester.precision) ? x : p;
    });
  },

  // Returns a string representation of the matrix
  inspect: function() {
    var matrix_rows = [];
    var n = this.elements.length, k = n, i;
    do { i = k - n;
      matrix_rows.push(Vector.create(this.elements[i]).inspect());
    } while (--n);
    return matrix_rows.join('\n');
  },

  // Set the matrix's elements from an array. If the argument passed
  // is a vector, the resulting matrix will be a single column.
  setElements: function(els) {
    var i, elements = els.elements || els;
    if (typeof(elements[0][0]) != 'undefined') {
      var ni = elements.length, ki = ni, nj, kj, j;
      this.elements = [];
      do { i = ki - ni;
        nj = elements[i].length; kj = nj;
        this.elements[i] = [];
        do { j = kj - nj;
          this.elements[i][j] = elements[i][j];
        } while (--nj);
      } while(--ni);
      return this;
    }
    var n = elements.length, k = n;
    this.elements = [];
    do { i = k - n;
      this.elements.push([elements[i]]);
    } while (--n);
    return this;
  }
};

// Constructor function
Matrix.create = function(elements) {
  var M = new Matrix();
  return M.setElements(elements);
};

// Identity matrix of size n
Matrix.I = function(n) {
  var els = [], k = n, i, nj, j;
  do { i = k - n;
    els[i] = []; nj = k;
    do { j = k - nj;
      els[i][j] = (i == j) ? 1 : 0;
    } while (--nj);
  } while (--n);
  return Matrix.create(els);
};

// Diagonal matrix - all off-diagonal elements are zero
Matrix.Diagonal = function(elements) {
  var n = elements.length, k = n, i;
  var M = Matrix.I(n);
  do { i = k - n;
    M.elements[i][i] = elements[i];
  } while (--n);
  return M;
};

// Rotation matrix about some axis. If no axis is
// supplied, assume we're after a 2D transform
Matrix.Rotation = function(theta, a) {
  if (!a) {
    return Matrix.create([
      [Math.cos(theta),  -Math.sin(theta)],
      [Math.sin(theta),   Math.cos(theta)]
    ]);
  }
  var axis = a.dup();
  if (axis.elements.length != 3) { return null; }
  var mod = axis.modulus();
  var x = axis.elements[0]/mod, y = axis.elements[1]/mod, z = axis.elements[2]/mod;
  var s = Math.sin(theta), c = Math.cos(theta), t = 1 - c;
  // Formula derived here: http://www.gamedev.net/reference/articles/article1199.asp
  // That proof rotates the co-ordinate system so theta
  // becomes -theta and sin becomes -sin here.
  return Matrix.create([
    [ t*x*x + c, t*x*y - s*z, t*x*z + s*y ],
    [ t*x*y + s*z, t*y*y + c, t*y*z - s*x ],
    [ t*x*z - s*y, t*y*z + s*x, t*z*z + c ]
  ]);
};

// Special case rotations
Matrix.RotationX = function(t) {
  var c = Math.cos(t), s = Math.sin(t);
  return Matrix.create([
    [  1,  0,  0 ],
    [  0,  c, -s ],
    [  0,  s,  c ]
  ]);
};
Matrix.RotationY = function(t) {
  var c = Math.cos(t), s = Math.sin(t);
  return Matrix.create([
    [  c,  0,  s ],
    [  0,  1,  0 ],
    [ -s,  0,  c ]
  ]);
};
Matrix.RotationZ = function(t) {
  var c = Math.cos(t), s = Math.sin(t);
  return Matrix.create([
    [  c, -s,  0 ],
    [  s,  c,  0 ],
    [  0,  0,  1 ]
  ]);
};

// Random matrix of n rows, m columns
Matrix.Random = function(n, m) {
  return Matrix.Zero(n, m).map(
    function() { return Math.random(); }
  );
};

// Matrix filled with zeros
Matrix.Zero = function(n, m) {
  var els = [], ni = n, i, nj, j;
  do { i = n - ni;
    els[i] = [];
    nj = m;
    do { j = m - nj;
      els[i][j] = 0;
    } while (--nj);
  } while (--ni);
  return Matrix.create(els);
};



function Line() {}
Line.prototype = {

  // Returns true if the argument occupies the same space as the line
  eql: function(line) {
    return (this.isParallelTo(line) && this.contains(line.anchor));
  },

  // Returns a copy of the line
  dup: function() {
    return Line.create(this.anchor, this.direction);
  },

  // Returns the result of translating the line by the given vector/array
  translate: function(vector) {
    var V = vector.elements || vector;
    return Line.create([
      this.anchor.elements[0] + V[0],
      this.anchor.elements[1] + V[1],
      this.anchor.elements[2] + (V[2] || 0)
    ], this.direction);
  },

  // Returns true if the line is parallel to the argument. Here, 'parallel to'
  // means that the argument's direction is either parallel or antiparallel to
  // the line's own direction. A line is parallel to a plane if the two do not
  // have a unique intersection.
  isParallelTo: function(obj) {
    if (obj.normal) { return obj.isParallelTo(this); }
    var theta = this.direction.angleFrom(obj.direction);
    return (Math.abs(theta) <= Sylvester.precision || Math.abs(theta - Math.PI) <= Sylvester.precision);
  },

  // Returns the line's perpendicular distance from the argument,
  // which can be a point, a line or a plane
  distanceFrom: function(obj) {
    if (obj.normal) { return obj.distanceFrom(this); }
    if (obj.direction) {
      // obj is a line
      if (this.isParallelTo(obj)) { return this.distanceFrom(obj.anchor); }
      var N = this.direction.cross(obj.direction).toUnitVector().elements;
      var A = this.anchor.elements, B = obj.anchor.elements;
      return Math.abs((A[0] - B[0]) * N[0] + (A[1] - B[1]) * N[1] + (A[2] - B[2]) * N[2]);
    } else {
      // obj is a point
      var P = obj.elements || obj;
      var A = this.anchor.elements, D = this.direction.elements;
      var PA1 = P[0] - A[0], PA2 = P[1] - A[1], PA3 = (P[2] || 0) - A[2];
      var modPA = Math.sqrt(PA1*PA1 + PA2*PA2 + PA3*PA3);
      if (modPA === 0) return 0;
      // Assumes direction vector is normalized
      var cosTheta = (PA1 * D[0] + PA2 * D[1] + PA3 * D[2]) / modPA;
      var sin2 = 1 - cosTheta*cosTheta;
      return Math.abs(modPA * Math.sqrt(sin2 < 0 ? 0 : sin2));
    }
  },

  // Returns true iff the argument is a point on the line
  contains: function(point) {
    var dist = this.distanceFrom(point);
    return (dist !== null && dist <= Sylvester.precision);
  },

  // Returns true iff the line lies in the given plane
  liesIn: function(plane) {
    return plane.contains(this);
  },

  // Returns true iff the line has a unique point of intersection with the argument
  intersects: function(obj) {
    if (obj.normal) { return obj.intersects(this); }
    return (!this.isParallelTo(obj) && this.distanceFrom(obj) <= Sylvester.precision);
  },

  // Returns the unique intersection point with the argument, if one exists
  intersectionWith: function(obj) {
    if (obj.normal) { return obj.intersectionWith(this); }
    if (!this.intersects(obj)) { return null; }
    var P = this.anchor.elements, X = this.direction.elements,
        Q = obj.anchor.elements, Y = obj.direction.elements;
    var X1 = X[0], X2 = X[1], X3 = X[2], Y1 = Y[0], Y2 = Y[1], Y3 = Y[2];
    var PsubQ1 = P[0] - Q[0], PsubQ2 = P[1] - Q[1], PsubQ3 = P[2] - Q[2];
    var XdotQsubP = - X1*PsubQ1 - X2*PsubQ2 - X3*PsubQ3;
    var YdotPsubQ = Y1*PsubQ1 + Y2*PsubQ2 + Y3*PsubQ3;
    var XdotX = X1*X1 + X2*X2 + X3*X3;
    var YdotY = Y1*Y1 + Y2*Y2 + Y3*Y3;
    var XdotY = X1*Y1 + X2*Y2 + X3*Y3;
    var k = (XdotQsubP * YdotY / XdotX + XdotY * YdotPsubQ) / (YdotY - XdotY * XdotY);
    return Vector.create([P[0] + k*X1, P[1] + k*X2, P[2] + k*X3]);
  },

  // Returns the point on the line that is closest to the given point or line
  pointClosestTo: function(obj) {
    if (obj.direction) {
      // obj is a line
      if (this.intersects(obj)) { return this.intersectionWith(obj); }
      if (this.isParallelTo(obj)) { return null; }
      var D = this.direction.elements, E = obj.direction.elements;
      var D1 = D[0], D2 = D[1], D3 = D[2], E1 = E[0], E2 = E[1], E3 = E[2];
      // Create plane containing obj and the shared normal and intersect this with it
      // Thank you: http://www.cgafaq.info/wiki/Line-line_distance
      var x = (D3 * E1 - D1 * E3), y = (D1 * E2 - D2 * E1), z = (D2 * E3 - D3 * E2);
      var N = Vector.create([x * E3 - y * E2, y * E1 - z * E3, z * E2 - x * E1]);
      var P = Plane.create(obj.anchor, N);
      return P.intersectionWith(this);
    } else {
      // obj is a point
      var P = obj.elements || obj;
      if (this.contains(P)) { return Vector.create(P); }
      var A = this.anchor.elements, D = this.direction.elements;
      var D1 = D[0], D2 = D[1], D3 = D[2], A1 = A[0], A2 = A[1], A3 = A[2];
      var x = D1 * (P[1]-A2) - D2 * (P[0]-A1), y = D2 * ((P[2] || 0) - A3) - D3 * (P[1]-A2),
          z = D3 * (P[0]-A1) - D1 * ((P[2] || 0) - A3);
      var V = Vector.create([D2 * x - D3 * z, D3 * y - D1 * x, D1 * z - D2 * y]);
      var k = this.distanceFrom(P) / V.modulus();
      return Vector.create([
        P[0] + V.elements[0] * k,
        P[1] + V.elements[1] * k,
        (P[2] || 0) + V.elements[2] * k
      ]);
    }
  },

  // Returns a copy of the line rotated by t radians about the given line. Works by
  // finding the argument's closest point to this line's anchor point (call this C) and
  // rotating the anchor about C. Also rotates the line's direction about the argument's.
  // Be careful with this - the rotation axis' direction affects the outcome!
  rotate: function(t, line) {
    // If we're working in 2D
    if (typeof(line.direction) == 'undefined') { line = Line.create(line.to3D(), Vector.k); }
    var R = Matrix.Rotation(t, line.direction).elements;
    var C = line.pointClosestTo(this.anchor).elements;
    var A = this.anchor.elements, D = this.direction.elements;
    var C1 = C[0], C2 = C[1], C3 = C[2], A1 = A[0], A2 = A[1], A3 = A[2];
    var x = A1 - C1, y = A2 - C2, z = A3 - C3;
    return Line.create([
      C1 + R[0][0] * x + R[0][1] * y + R[0][2] * z,
      C2 + R[1][0] * x + R[1][1] * y + R[1][2] * z,
      C3 + R[2][0] * x + R[2][1] * y + R[2][2] * z
    ], [
      R[0][0] * D[0] + R[0][1] * D[1] + R[0][2] * D[2],
      R[1][0] * D[0] + R[1][1] * D[1] + R[1][2] * D[2],
      R[2][0] * D[0] + R[2][1] * D[1] + R[2][2] * D[2]
    ]);
  },

  // Returns the line's reflection in the given point or line
  reflectionIn: function(obj) {
    if (obj.normal) {
      // obj is a plane
      var A = this.anchor.elements, D = this.direction.elements;
      var A1 = A[0], A2 = A[1], A3 = A[2], D1 = D[0], D2 = D[1], D3 = D[2];
      var newA = this.anchor.reflectionIn(obj).elements;
      // Add the line's direction vector to its anchor, then mirror that in the plane
      var AD1 = A1 + D1, AD2 = A2 + D2, AD3 = A3 + D3;
      var Q = obj.pointClosestTo([AD1, AD2, AD3]).elements;
      var newD = [Q[0] + (Q[0] - AD1) - newA[0], Q[1] + (Q[1] - AD2) - newA[1], Q[2] + (Q[2] - AD3) - newA[2]];
      return Line.create(newA, newD);
    } else if (obj.direction) {
      // obj is a line - reflection obtained by rotating PI radians about obj
      return this.rotate(Math.PI, obj);
    } else {
      // obj is a point - just reflect the line's anchor in it
      var P = obj.elements || obj;
      return Line.create(this.anchor.reflectionIn([P[0], P[1], (P[2] || 0)]), this.direction);
    }
  },

  // Set the line's anchor point and direction.
  setVectors: function(anchor, direction) {
    // Need to do this so that line's properties are not
    // references to the arguments passed in
    anchor = Vector.create(anchor);
    direction = Vector.create(direction);
    if (anchor.elements.length == 2) {anchor.elements.push(0); }
    if (direction.elements.length == 2) { direction.elements.push(0); }
    if (anchor.elements.length > 3 || direction.elements.length > 3) { return null; }
    var mod = direction.modulus();
    if (mod === 0) { return null; }
    this.anchor = anchor;
    this.direction = Vector.create([
      direction.elements[0] / mod,
      direction.elements[1] / mod,
      direction.elements[2] / mod
    ]);
    return this;
  }
};

  
// Constructor function
Line.create = function(anchor, direction) {
  var L = new Line();
  return L.setVectors(anchor, direction);
};

// Axes
Line.X = Line.create(Vector.Zero(3), Vector.i);
Line.Y = Line.create(Vector.Zero(3), Vector.j);
Line.Z = Line.create(Vector.Zero(3), Vector.k);



function Plane() {}
Plane.prototype = {

  // Returns true iff the plane occupies the same space as the argument
  eql: function(plane) {
    return (this.contains(plane.anchor) && this.isParallelTo(plane));
  },

  // Returns a copy of the plane
  dup: function() {
    return Plane.create(this.anchor, this.normal);
  },

  // Returns the result of translating the plane by the given vector
  translate: function(vector) {
    var V = vector.elements || vector;
    return Plane.create([
      this.anchor.elements[0] + V[0],
      this.anchor.elements[1] + V[1],
      this.anchor.elements[2] + (V[2] || 0)
    ], this.normal);
  },

  // Returns true iff the plane is parallel to the argument. Will return true
  // if the planes are equal, or if you give a line and it lies in the plane.
  isParallelTo: function(obj) {
    var theta;
    if (obj.normal) {
      // obj is a plane
      theta = this.normal.angleFrom(obj.normal);
      return (Math.abs(theta) <= Sylvester.precision || Math.abs(Math.PI - theta) <= Sylvester.precision);
    } else if (obj.direction) {
      // obj is a line
      return this.normal.isPerpendicularTo(obj.direction);
    }
    return null;
  },
  
  // Returns true iff the receiver is perpendicular to the argument
  isPerpendicularTo: function(plane) {
    var theta = this.normal.angleFrom(plane.normal);
    return (Math.abs(Math.PI/2 - theta) <= Sylvester.precision);
  },

  // Returns the plane's distance from the given object (point, line or plane)
  distanceFrom: function(obj) {
    if (this.intersects(obj) || this.contains(obj)) { return 0; }
    if (obj.anchor) {
      // obj is a plane or line
      var A = this.anchor.elements, B = obj.anchor.elements, N = this.normal.elements;
      return Math.abs((A[0] - B[0]) * N[0] + (A[1] - B[1]) * N[1] + (A[2] - B[2]) * N[2]);
    } else {
      // obj is a point
      var P = obj.elements || obj;
      var A = this.anchor.elements, N = this.normal.elements;
      return Math.abs((A[0] - P[0]) * N[0] + (A[1] - P[1]) * N[1] + (A[2] - (P[2] || 0)) * N[2]);
    }
  },

  // Returns true iff the plane contains the given point or line
  contains: function(obj) {
    if (obj.normal) { return null; }
    if (obj.direction) {
      return (this.contains(obj.anchor) && this.contains(obj.anchor.add(obj.direction)));
    } else {
      var P = obj.elements || obj;
      var A = this.anchor.elements, N = this.normal.elements;
      var diff = Math.abs(N[0]*(A[0] - P[0]) + N[1]*(A[1] - P[1]) + N[2]*(A[2] - (P[2] || 0)));
      return (diff <= Sylvester.precision);
    }
  },

  // Returns true iff the plane has a unique point/line of intersection with the argument
  intersects: function(obj) {
    if (typeof(obj.direction) == 'undefined' && typeof(obj.normal) == 'undefined') { return null; }
    return !this.isParallelTo(obj);
  },

  // Returns the unique intersection with the argument, if one exists. The result
  // will be a vector if a line is supplied, and a line if a plane is supplied.
  intersectionWith: function(obj) {
    if (!this.intersects(obj)) { return null; }
    if (obj.direction) {
      // obj is a line
      var A = obj.anchor.elements, D = obj.direction.elements,
          P = this.anchor.elements, N = this.normal.elements;
      var multiplier = (N[0]*(P[0]-A[0]) + N[1]*(P[1]-A[1]) + N[2]*(P[2]-A[2])) / (N[0]*D[0] + N[1]*D[1] + N[2]*D[2]);
      return Vector.create([A[0] + D[0]*multiplier, A[1] + D[1]*multiplier, A[2] + D[2]*multiplier]);
    } else if (obj.normal) {
      // obj is a plane
      var direction = this.normal.cross(obj.normal).toUnitVector();
      // To find an anchor point, we find one co-ordinate that has a value
      // of zero somewhere on the intersection, and remember which one we picked
      var N = this.normal.elements, A = this.anchor.elements,
          O = obj.normal.elements, B = obj.anchor.elements;
      var solver = Matrix.Zero(2,2), i = 0;
      while (solver.isSingular()) {
        i++;
        solver = Matrix.create([
          [ N[i%3], N[(i+1)%3] ],
          [ O[i%3], O[(i+1)%3]  ]
        ]);
      }
      // Then we solve the simultaneous equations in the remaining dimensions
      var inverse = solver.inverse().elements;
      var x = N[0]*A[0] + N[1]*A[1] + N[2]*A[2];
      var y = O[0]*B[0] + O[1]*B[1] + O[2]*B[2];
      var intersection = [
        inverse[0][0] * x + inverse[0][1] * y,
        inverse[1][0] * x + inverse[1][1] * y
      ];
      var anchor = [];
      for (var j = 1; j <= 3; j++) {
        // This formula picks the right element from intersection by
        // cycling depending on which element we set to zero above
        anchor.push((i == j) ? 0 : intersection[(j + (5 - i)%3)%3]);
      }
      return Line.create(anchor, direction);
    }
  },

  // Returns the point in the plane closest to the given point
  pointClosestTo: function(point) {
    var P = point.elements || point;
    var A = this.anchor.elements, N = this.normal.elements;
    var dot = (A[0] - P[0]) * N[0] + (A[1] - P[1]) * N[1] + (A[2] - (P[2] || 0)) * N[2];
    return Vector.create([P[0] + N[0] * dot, P[1] + N[1] * dot, (P[2] || 0) + N[2] * dot]);
  },

  // Returns a copy of the plane, rotated by t radians about the given line
  // See notes on Line#rotate.
  rotate: function(t, line) {
    var R = Matrix.Rotation(t, line.direction).elements;
    var C = line.pointClosestTo(this.anchor).elements;
    var A = this.anchor.elements, N = this.normal.elements;
    var C1 = C[0], C2 = C[1], C3 = C[2], A1 = A[0], A2 = A[1], A3 = A[2];
    var x = A1 - C1, y = A2 - C2, z = A3 - C3;
    return Plane.create([
      C1 + R[0][0] * x + R[0][1] * y + R[0][2] * z,
      C2 + R[1][0] * x + R[1][1] * y + R[1][2] * z,
      C3 + R[2][0] * x + R[2][1] * y + R[2][2] * z
    ], [
      R[0][0] * N[0] + R[0][1] * N[1] + R[0][2] * N[2],
      R[1][0] * N[0] + R[1][1] * N[1] + R[1][2] * N[2],
      R[2][0] * N[0] + R[2][1] * N[1] + R[2][2] * N[2]
    ]);
  },

  // Returns the reflection of the plane in the given point, line or plane.
  reflectionIn: function(obj) {
    if (obj.normal) {
      // obj is a plane
      var A = this.anchor.elements, N = this.normal.elements;
      var A1 = A[0], A2 = A[1], A3 = A[2], N1 = N[0], N2 = N[1], N3 = N[2];
      var newA = this.anchor.reflectionIn(obj).elements;
      // Add the plane's normal to its anchor, then mirror that in the other plane
      var AN1 = A1 + N1, AN2 = A2 + N2, AN3 = A3 + N3;
      var Q = obj.pointClosestTo([AN1, AN2, AN3]).elements;
      var newN = [Q[0] + (Q[0] - AN1) - newA[0], Q[1] + (Q[1] - AN2) - newA[1], Q[2] + (Q[2] - AN3) - newA[2]];
      return Plane.create(newA, newN);
    } else if (obj.direction) {
      // obj is a line
      return this.rotate(Math.PI, obj);
    } else {
      // obj is a point
      var P = obj.elements || obj;
      return Plane.create(this.anchor.reflectionIn([P[0], P[1], (P[2] || 0)]), this.normal);
    }
  },

  // Sets the anchor point and normal to the plane. If three arguments are specified,
  // the normal is calculated by assuming the three points should lie in the same plane.
  // If only two are sepcified, the second is taken to be the normal. Normal vector is
  // normalised before storage.
  setVectors: function(anchor, v1, v2) {
    anchor = Vector.create(anchor);
    anchor = anchor.to3D(); if (anchor === null) { return null; }
    v1 = Vector.create(v1);
    v1 = v1.to3D(); if (v1 === null) { return null; }
    if (typeof(v2) == 'undefined') {
      v2 = null;
    } else {
      v2 = Vector.create(v2);
      v2 = v2.to3D(); if (v2 === null) { return null; }
    }
    var A1 = anchor.elements[0], A2 = anchor.elements[1], A3 = anchor.elements[2];
    var v11 = v1.elements[0], v12 = v1.elements[1], v13 = v1.elements[2];
    var normal, mod;
    if (v2 !== null) {
      var v21 = v2.elements[0], v22 = v2.elements[1], v23 = v2.elements[2];
      normal = Vector.create([
        (v12 - A2) * (v23 - A3) - (v13 - A3) * (v22 - A2),
        (v13 - A3) * (v21 - A1) - (v11 - A1) * (v23 - A3),
        (v11 - A1) * (v22 - A2) - (v12 - A2) * (v21 - A1)
      ]);
      mod = normal.modulus();
      if (mod === 0) { return null; }
      normal = Vector.create([normal.elements[0] / mod, normal.elements[1] / mod, normal.elements[2] / mod]);
    } else {
      mod = Math.sqrt(v11*v11 + v12*v12 + v13*v13);
      if (mod === 0) { return null; }
      normal = Vector.create([v1.elements[0] / mod, v1.elements[1] / mod, v1.elements[2] / mod]);
    }
    this.anchor = anchor;
    this.normal = normal;
    return this;
  }
};

// Constructor function
Plane.create = function(anchor, v1, v2) {
  var P = new Plane();
  return P.setVectors(anchor, v1, v2);
};

// X-Y-Z planes
Plane.XY = Plane.create(Vector.Zero(3), Vector.k);
Plane.YZ = Plane.create(Vector.Zero(3), Vector.i);
Plane.ZX = Plane.create(Vector.Zero(3), Vector.j);
Plane.YX = Plane.XY; Plane.ZY = Plane.YZ; Plane.XZ = Plane.ZX;


RegisterIniter(TransitionsSectionIniter);

function TransitionsSectionIniter(aElt, aRuleset)
{
  deleteAllChildren(gDialog.transitionsRichlistbox);
  var mtp = CssInspector.getCascadedValue(aRuleset, "-moz-transition-property");
  var mtpArray = [];
  if (mtp) {
    mtpArray = mtp.split(",");
	  for (var i = 0; i < mtpArray.length; i++) {
	    var item = document.createElement("richlistitem");
	    var v = mtpArray[i].trim();
	    switch (v) {
	      case "all":
	      case "none":
	        item.className = v + "Transition";
	        gDialog.transitionsRichlistbox.appendChild(item)
	        break;
	      default:
	        item.className = "propertyTransition";
	        gDialog.transitionsRichlistbox.appendChild(item);
	        item.propertyValue = v;
	        break;
	    }
	  }
  }

  var mtde = CssInspector.getCascadedValue(aRuleset, "-moz-transition-delay") || "0s";
  var mtdeArray = mtde.split(",");
  while (mtdeArray.length < mtpArray.length)
    mtdeArray = mtdeArray.concat(mtdeArray);
  for (var i = 0 ; i < mtpArray.length; i++) {
    var item = gDialog.transitionsRichlistbox.getItemAtIndex(i);
    item.delayValue = parseFloat(mtdeArray[i]);
  }

  var mtdu = CssInspector.getCascadedValue(aRuleset, "-moz-transition-duration") || "0s";
  var mtduArray = mtdu.split(",");
  while (mtduArray.length < mtpArray.length)
    mtduArray = mtduArray.concat(mtduArray);
  for (var i = 0 ; i < mtpArray.length; i++) {
    var item = gDialog.transitionsRichlistbox.getItemAtIndex(i);
    item.durationValue = parseFloat(mtduArray[i]);
  }

  var mttf = CssInspector.getCascadedValue(aRuleset, "-moz-transition-timing-function") || "ease";
  var mttfArray = mttf.match( /ease-in-out|ease-in|ease-out|ease|cubic-bezier\([^\)]*\)/g ) || [];
  while (mttfArray.length < mtpArray.length)
    mttfArray = mttfArray.concat(mttfArray);
  for (var i = 0 ; i < mtpArray.length; i++) {
    var item = gDialog.transitionsRichlistbox.getItemAtIndex(i);
    item.functionValue = mttfArray[i];
  }

  UpdateTransitionUI();
}

function OnTransitionSelect(aElt)
{
  var item = aElt.selectedItem;
  SetEnabledElement(gDialog.removeTransitionButton, (item != null));    
}

function AddTransition(aEvent)
{
  var type = aEvent.originalTarget.value;
  var item = document.createElement("richlistitem");
  item.className = type + "Transition";
  gDialog.transitionsRichlistbox.appendChild(item);
  UpdateTransitionUI();
  ReapplyTransitions();
}

function DeleteTransition()
{
  var item = gDialog.transitionsRichlistbox.selectedItem;
  if (!item) return; // sanity check
  item.parentNode.removeChild(item);
  UpdateTransitionUI();
  ReapplyTransitions();
}

function ReapplyTransitions()
{
  var items = gDialog.transitionsRichlistbox.querySelectorAll("richlistitem");
  var properties = [];
  var durations  = [];
  var functions  = [];
  var delays     = [];
  for (var i = 0; i < items.length; i++) {
    var item = items[i];
    if (item.propertyValue) {
	    properties.push( item.propertyValue );
	    durations.push( item.durationValue + "s" );
	    functions.push( item.functionValue );
	    delays.push( item.delayValue + "s");
    }
  }
  ApplyStyles( [
                 {
                   property: "-moz-transition-property",
                   value: properties.join(", ")
                 },
                 {
                   property: "-moz-transition-duration",
                   value: durations.join(", ")
                 },
                 {
                   property: "-moz-transition-timing-function",
                   value: functions.join(", ")
                 },
                 {
                   property: "-moz-transition-delay",
                   value: delays.join(", ")
                 }
               ] );
}

function UpdateTransitionUI()
{
  var isEmpty = (gDialog.transitionsRichlistbox.itemCount == 0);
  var isNoneOrAll = !isEmpty &&
                    (gDialog.transitionsRichlistbox.getItemAtIndex(0).className == "noneTransition" ||
                     gDialog.transitionsRichlistbox.getItemAtIndex(0).className == "allTransition");
  SetEnabledElement(gDialog.addTransitionButton, !isNoneOrAll);
  SetEnabledElement(gDialog.removeTransitionButton, false);
  
  SetEnabledElement(gDialog.onePropertyTransitionMenuitem, isEmpty || !isNoneOrAll);
  SetEnabledElement(gDialog.noneTransitionMenuitem, isEmpty);
  SetEnabledElement(gDialog.allTransitionMenuitem, isEmpty);
}

function OpenPanelIfBezier(e)
{
  var v = e.value.trim();
  gDialog.bezierPanel.openPopupAtScreen(e.boxObject.screenX,
                                        e.boxObject.screenY,
                                        false);
  Bezier.initWithBezier(v, e);
  setTimeout(function() {
    gDialog.p1_x.focus(); }, 100);
}RegisterIniter(FlexBoxSectionIniter);

function FlexBoxSectionIniter(aElt, aRuleset)
{
  var d = CssInspector.getCascadedValue(aRuleset, "display");
  gDialog.flexBoxEnabledCheckbox.checked = (d == "-moz-box" || d == "-moz-inline-box");
  gDialog.inlineBoxCheckbox.disabled = !gDialog.flexBoxEnabledCheckbox.checked;
  gDialog.inlineBoxCheckbox.checked = (d == "-moz-inline-box");

  var ba = CssInspector.getCascadedValue(aRuleset, "-moz-box-align");
  CheckToggle(gDialog.startBoxAlignButton,    ba == "start");
  CheckToggle(gDialog.centerBoxAlignButton,   ba == "center");
  CheckToggle(gDialog.endBoxAlignButton,      ba == "end");
  CheckToggle(gDialog.baselineBoxAlignButton, ba == "baseline");
  CheckToggle(gDialog.stretchBoxAlignButton,  ba == "stretch");

  var bd = CssInspector.getCascadedValue(aRuleset, "-moz-box-direction");
  CheckToggle(gDialog.normalBoxDirectionButton,    bd == "normal");
  CheckToggle(gDialog.reverseBoxDirectionButton,   bd == "reverse");

  var bf = CssInspector.getCascadedValue(aRuleset, "-moz-box-flex");
  gDialog.boxFlexTextbox.value = bf;

  var bo = CssInspector.getCascadedValue(aRuleset, "-moz-box-orient");
  CheckToggle(gDialog.horizontalBoxOrientButton,   bo == "horizontal");
  CheckToggle(gDialog.verticalBoxOrientButton,     bo == "vertical");

  var bog = CssInspector.getCascadedValue(aRuleset, "-moz-box-ordinal-group");
  gDialog.boxOrdinalGroupTextbox.value = bog;

  var bp = CssInspector.getCascadedValue(aRuleset, "-moz-box-pack");
  CheckToggle(gDialog.startBoxPackButton,    bp == "start");
  CheckToggle(gDialog.centerBoxPackButton,   bp == "center");
  CheckToggle(gDialog.endBoxPackButton,      bp == "end");
  CheckToggle(gDialog.justifyBoxPackButton,  bp == "justify");
}

function ToggleFlexBox()
{
  gDialog.inlineBoxCheckbox.disabled = !gDialog.flexBoxEnabledCheckbox.checked;
  ApplyStyles( [
							   {
							     property: "display",
                   value: gDialog.flexBoxEnabledCheckbox.checked ?
                          (gDialog.inlineBoxCheckbox.checked ? "-moz-inline-box" : "-moz-box") :
                          ""
							   }
               ]);
}
RegisterIniter(ColumnsSectionIniter);

function ColumnsSectionIniter(aElt, aRuleset)
{
  var cc = CssInspector.getCascadedValue(aRuleset, "-moz-column-count");
  if (cc == "auto")
    cc = "1";
  gDialog.columnCount.value = cc;

  var cw = CssInspector.getCascadedValue(aRuleset, "-moz-column-width");
  gDialog.columnWidthMenulist.value = cw;

  var cg = CssInspector.getCascadedValue(aRuleset, "-moz-column-gap");
  gDialog.columnGapMenulist.value = cg;

  var crc = CssInspector.getCascadedValue(aRuleset, "-moz-column-rule-color");
  gDialog.columnRuleColorpicker.color = crc;
  var crs = CssInspector.getCascadedValue(aRuleset, "-moz-column-rule-style");
  gDialog.columnRuleStyleMenulist.value = crs;
  var crw = CssInspector.getCascadedValue(aRuleset, "-moz-column-rule-width");
  gDialog.columnRuleWidthMenulist.value = crw;
}

function SetColumnCount(aN)
{
  gDialog.columnCount.value = aN;
  ColumnCountChanged();
}

function ColumnCountChanged()
{
  var count = gDialog.columnCount.value;
  if (count == "1")
    count = "";

  ApplyStyles([
	              {
	                property: "-moz-column-count",
	                value: count
	              }
              ]);
}

RegisterIniter(TablesSectionIniter);

function TablesSectionIniter(aElt, aRuleset)
{
  var c = CssInspector.getCascadedValue(aRuleset, "table-layout");
  CheckToggle(gDialog.autoTableLayoutButton, c == "auto");
  CheckToggle(gDialog.fixedTableLayoutButton, c == "fixed");

  var bc = CssInspector.getCascadedValue(aRuleset, "border-collapse");
  CheckToggle(gDialog.collapseBorderCollapseButton, bc == "collapse");
  CheckToggle(gDialog.separateBorderCollapseButton, bc == "separate");

  var bs = CssInspector.getCascadedValue(aRuleset, "border-spacing");
  if (bs) {
    var bsArray = bs.split(" ");
    gDialog.borderSpacingHMenulist.value = bsArray[0];
    if (bsArray.length == 2)
      gDialog.borderSpacingVMenulist.value = bsArray[1];
    else
      gDialog.borderSpacingVMenulist.value = "";
  }
  else {
    gDialog.borderSpacingHMenulist.value = "";
    gDialog.borderSpacingVMenulist.value = "";
  }

  var ec = CssInspector.getCascadedValue(aRuleset, "empty-cells");
  CheckToggle(gDialog.showEmptyCellsButton, ec == "show");
  CheckToggle(gDialog.hideEmptyCellsButton, ec == "hide");
}

function ApplyBorderSpacing()
{
  var h = gDialog.borderSpacingHMenulist.value;
  var v = gDialog.borderSpacingVMenulist.value;
  ApplyStyles( [ {
                   property: "border-spacing",
                   value: h + " " + v
                 }])
}
RegisterIniter(MiscSectionIniter);

function MiscSectionIniter(aElt, aRuleset)
{
  var c = CssInspector.getCascadedValue(aRuleset, "cursor");
  gDialog.cursorMenulist.value = c;

  var ub = CssInspector.getCascadedValue(aRuleset, "unicode-bidi");
  CheckToggle(gDialog.normalUnicodeBidiButton,       ub == "normal");
  CheckToggle(gDialog.embedUnicodeBidiButton,        ub == "embed");
  CheckToggle(gDialog.bidiOverrideUnicodeBidiButton, ub == "bidi-override");

  var w = CssInspector.getCascadedValue(aRuleset, "widows");
  gDialog.widowsTextbox.value = w;

  var o = CssInspector.getCascadedValue(aRuleset, "orphans");
  gDialog.orphansTextbox.value = o;

  var pbb = CssInspector.getCascadedValue(aRuleset, "page-break-before");
  gDialog.pageBreakBeforeMenulist.value = pbb;

  var pbi = CssInspector.getCascadedValue(aRuleset, "page-break-inside");
  gDialog.pageBreakInsideMenulist.value = pbi;

  var pba = CssInspector.getCascadedValue(aRuleset, "page-break-after");
  gDialog.pageBreakAfterMenulist.value = pba;
}
//@line 813 "c:\trees\bg-trunk\bluegriffon\sidebars\cssproperties\content\cssproperties.js"

function ToggleHover(aElt)
{
  if (aElt.checked)
    gDialog.cssPolicyMenulist.value = "id";
  var node = gCurrentElement;
  gCurrentElement = null;
  SelectionChanged(null, node, null);
}